# 1. Preparation

```shell
pip3 install -r requirements.txt
```
Note that we exclude "pytorch" in requirments.txt. Recommend to use any pytorch version < 2.0.0 from "https://pytorch.org/get-started/previous-versions/". We utilized pytorch 1.9.1+cu111.

For dataset, we recommend to use FairytaleQA dataset(https://aclanthology.org/2022.acl-long.34.pdf) from huggingface "datasets"(https://huggingface.co/docs/datasets/v1.8.0/loading_datasets.html)

# 2. Training
Prior to run our code, we recommend to run "ConfigModule.py" in "module" folder, to build config files.
```shell
cd module
python ConfigModule.py
```
Then run the code below. Training type determines "n_s". In our paper, we report our best performance in training_type==5.

```shell
CUDA_VISIBLE_DEVICES=0 nohup python train.py \
--save_filename "ckpt" \
--training_type 5 \
--train_file "QAgen/train.csv" \
--valid_file "QAgen/validation.csv" \
--wb_name "" > logs/train.logs &
```

If you want to make default argument, 
- modify "config/config_manual.yaml" or 
- modify "module/ConfigModule.py" and re-run ConfigModule.py

# 3. Inference
Note that
- If "--save_filename" in training phase is set to "ckpt", "--ckpt" shoule be set to "ckpt/**checkpoints**"
- Type should be the same as the training_type in training phase 
```shell
CUDA_VISIBLE_DEVICES=0 python inference.py \
--ckpt ckpt_dir/checkpoints \
--type 5 \
--savefile results \
--testfile QAgen/test.csv
```