"""Prompt templates for real-world data prompt generation.

These are the templates used to generate the real-world data prompts.
"""


avg_step_count_percentile_prompt = """
## You are an expert on population health and wearable fitness devices. Your task is to estimate the percentile of a given average step count value for a population that regularly uses Fitbit devices and is active on a daily basis. The data is filtered for individuals aged 18-65. The data is age-balanced and gender-balanced, and pertains to the U.S. population only. Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>.

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Normal Distribution
  Mean: 8366.971
  Standard Deviation: 3291.940


## Here is your question:
Question:
What is the percentile of the average step count value {target_number} steps for users of Fitbit devices?
Answer:
"""


avg_resting_heart_rate_prompt = """
## You are an expert on population health and wearable fitness devices. Your task is to estimate the percentile of a given average resting heart rate value for a population that regularly uses Fitbit devices and is active on a daily basis. The data is filtered for individuals aged 18-65. The data is age-balanced and gender-balanced, and pertains to the U.S. population only. Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Normal Distribution
  Mean: 67.882
  Standard Deviation: 7.723


## Here is your question:
Question:
What is the percentile of the average resting heart rate value {target_number} beats per minute for users of Fitbit devices?
Answer:
"""


avg_sleep_minutes_prompt = """
## You are an expert on population health and wearable fitness devices. Your task is to estimate the percentile of a given average sleep minutes count value for a population that regularly uses Fitbit devices and is active on a daily basis. The data is filtered for individuals aged 18-65. The data is age-balanced and gender-balanced, and pertains to the U.S. population only. Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Skew-Normal Distribution
  Characteristics: A generalization of the normal distribution to accommodate skewness.
  Location: 427.930 (Shifts the distribution along the x-axis.)
  Scale: 58.050 (Controls the spread of the distribution.)
  Skew: -1.177 (Determines the direction and degree of skewness.)


## Here is your question:
Question:
What is the percentile of the average sleep minutes count value {target_number} minutes for users of Fitbit devices?
Answer:
"""


avg_activity_zone_minutes_prompt = """
## You are an expert on population health and wearable fitness devices. Your task is to estimate the percentile of a given average exercise minutes count value for a population that regularly uses Fitbit devices and is active on a daily basis. The data is filtered for individuals aged 18-65. The data is age-balanced and gender-balanced, and pertains to the U.S. population only. Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Log-Normal Distribution
  Characteristics: This distribution models values that are the result of the multiplicative product of many independent random variables, such as income levels, stock prices, or city sizes.
  Log Mean (mu): 3.543
  Log Sigma (sigma): 0.677
  These parameters mean that the natural logarithm of the values follows a normal distribution with the specified mean and standard deviation.


## Here is your question:
Question:
What is the percentile of the average exercise minutes count value {target_number} minutes for users of Fitbit devices?
Answer:
"""


annual_household_income_percentile_prompt = """
## You are an expert on finance and statistics. Your task is to estimate the percentile of a given annual household income within the population using data from the year 2018 in the United States, sourced from the Census Bureau’s American Community Survey (ACS) Public Use Microdata Sample (PUMS). Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>.

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Gumbel Distribution
  Characteristics: Often used to model the distribution of extreme values.
  Location: 43788.542 (Centers the distribution.)
  Scale: 35382.156 (Controls the spread of the distribution.)

## Here is your question:
Question:
What is the percentile of an annual household income value of ${target_number}?
Answer:
"""


monthly_rentgrs_percentile_prompt = """
## You are an expert on finance and statistics. Your task is to estimate the percentile of a given monthly gross rent within the population using data from the year 2018 in the United States, sourced from the Census Bureau’s American Community Survey (ACS) Public Use Microdata Sample (PUMS). Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>.

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Gumbel Distribution
  Characteristics: Often used to model the distribution of extreme values.
  Location: 1053.066 (Centers the distribution.)
  Scale: 488.890 (Controls the spread of the distribution.)


## Here is your question:
Question:
What is the percentile of a monthly gross rent of ${target_number}?
Answer:
"""


annual_costelec_percentile_prompt = """
## You are an expert on finance and statistics. Your task is to estimate the percentile of a given annual electricity cost within the population using data from the year 2018 in the United States, sourced from the Census Bureau’s American Community Survey (ACS) Public Use Microdata Sample (PUMS). Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>.

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Skew-Normal Distribution
  Characteristics: A generalization of the normal distribution to accommodate skewness.
  Location: 509.827 (Shifts the distribution along the x-axis.)
  Scale: 1624.607 (Controls the spread of the distribution.)
  Skew: 7.105 (Determines the direction and degree of skewness.)

## Here is your question:
Question:
What is the percentile of an annual electricity cost of ${target_number}?
Answer:
"""


annual_costwatr_percentile_prompt = """
## You are an expert on finance and statistics. Your task is to estimate the percentile of a given annual water cost within the population using data from the year 2018 in the United States, sourced from the Census Bureau’s American Community Survey (ACS) Public Use Microdata Sample (PUMS). Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>.

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Exponential Distribution
  Characteristics: Models the intervals or amounts in a process where changes occur continuously and independently at a constant average rate.
  Rate: 0.00172 (This corresponds to an average of 581.395 units per interval.)


## Here is your question:
Question:
What is the percentile of an annual water cost of ${target_number}?
Answer:
"""


average_temperature_percentile_prompt = """
## You are an expert on climate science and statistics. Your task is to estimate the percentile of a given average temperature value using data from U.S. weather stations in the year 2018, sourced from the National Oceanic and Atmospheric Administration (NOAA) Global Historical Climatology Network Daily (GHCNd). Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>.

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Normal Distribution
  Mean: 10.643
  Standard Deviation: 12.628

## Here is your question:
Question:
What is the percentile of an average temperature of {target_number} degrees Celsius?
Answer:
"""


annual_precipitation_percentile_prompt = """
## You are an expert on climate science and statistics. Your task is to estimate the percentile of a given annual precipitation value using data from U.S. weather stations in the year 2018, sourced from the National Oceanic and Atmospheric Administration (NOAA) Global Historical Climatology Network Daily (GHCNd). Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>.

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Skew-Normal Distribution
  Characteristics: A generalization of the normal distribution to accommodate skewness.
  Location: 60.505 (Shifts the distribution along the x-axis.)
  Scale: 858.484 (Controls the spread of the distribution.)
  Skew: 13.395 (Determines the direction and degree of skewness.)


## Here is your question:
Question:
What is the percentile of an annual precipitation value of {target_number} millimeters?
Answer:
"""


average_wind_speed_percentile_prompt = """
## You are an expert on climate science and statistics. Your task is to estimate the percentile of a given average wind speed value using data from U.S. weather stations in the year 2018, sourced from the National Oceanic and Atmospheric Administration (NOAA) Global Historical Climatology Network Daily (GHCNd). Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>.

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Log-Normal Distribution
  Characteristics: This distribution models values that are the result of the multiplicative product of many independent random variables, such as income levels, stock prices, or city sizes.
  Log Mean (mu): 1.558
  Log Sigma (sigma): 0.340
  These parameters mean that the natural logarithm of the values follows a normal distribution with the specified mean and standard deviation.


## Here is your question:
Question:
What is the percentile of an average wind speed of {target_number} meters per second?
Answer:
"""


average_relative_humidity_percentile_prompt = """
## You are an expert on climate science and statistics. Your task is to estimate the percentile of a given average relative humidity value using data from U.S. weather stations in the year 2018, sourced from the National Oceanic and Atmospheric Administration (NOAA) Global Historical Climatology Network Daily (GHCNd). Answer with just a numerical response from 0 to 100. Make sure your final answer is enclosed by xml tags <answer> and </answer>.

## Note that the following distribution type and parameters correspond to this data:


  Distribution Type: Skew-Normal Distribution
  Characteristics: A generalization of the normal distribution to accommodate skewness.
  Location: 89.849 (Shifts the distribution along the x-axis.)
  Scale: 27.019 (Controls the spread of the distribution.)
  Skew: -4.939 (Determines the direction and degree of skewness.)


## Here is your question:
Question:
What is the percentile of an average relative humidity of {target_number}%?
Answer:
"""