theory question_40_7
imports Main

begin

typedecl entity
typedecl event

consts
  LightBulb :: "entity ⇒ bool"
  Convert :: "entity ⇒ event ⇒ entity ⇒ entity ⇒ bool"
  ElectricalEnergy :: "entity ⇒ bool"
  LightEnergy :: "entity ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"

theorem hypothesis:
  assumes asm: "LightBulb x ∧  OtherEnergy y ∧ Convert x y light_energy heat_energy "
  (* Hypothesis: Some light bulbs convert other energy into light and heat energy. *)
  shows "∃x y. LightBulb x ∧ OtherEnergy y ∧ Convert x y light_energy heat_energy"
proof -
  from asm have "LightBulb x ∧ ElectricalEnergy y ∧ Convert x y light_energy heat_energy"
    using explanation_1 by simp
  moreover
  from asm have "ElectricalEnergy y ⟶ OtherEnergy y"
    using explanation_2 by simp
  ultimately
  show ?thesis using asm by blast
qed

end
