theory question_67_3

imports Main

begin

typedecl entity
typedecl event

consts
  BoatTour :: "event ⇒ bool"
  Participant :: "entity ⇒ event ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Boat :: "entity ⇒ bool"
  Old :: "entity ⇒ bool"
  RiverBoatTour :: "event ⇒ bool"
  Male :: "entity ⇒ bool"
  
(* Explanation: If two entities are participants in a river boat tour, then they are on a boat. *)
axiomatization where
  explanation: "∀x y e. Participant x e ∧ Participant y e ∧ RiverBoatTour e ⟶ On x b ∧ On y b ∧ Boat b"

theorem hypothesis:
  (* Premise: Two older males are sitting together on a river boat tour. *)
  assumes asm: "Old x ∧ Old y ∧ Male x ∧ Male y ∧ Sitting e ∧ Agent e x ∧ Agent e y ∧ RiverBoatTour e ∧ On x b ∧ On y b ∧ Boat b"
  (* Hypothesis: Two males are sitting together on a boat. *)
  shows "∃x y e. Male x ∧ Male y ∧ Sitting e ∧ Agent e x ∧ Agent e y ∧ On x b ∧ On y b"
proof -
  from asm have "Old x ∧ Old y ∧ Male x ∧ Male y ∧ Sitting e ∧ Agent e x ∧ Agent e y ∧ RiverBoatTour e ∧ On x b ∧ On y b ∧ Boat b" by blast
  then have "Participant x e ∧ Participant y e ∧ RiverBoatTour e" by blast
  then have "On x b ∧ On y b ∧ Boat b" using explanation by blast
  then show "∃x y e. Male x ∧ Male y ∧ Sitting e ∧ Agent e x ∧ Agent e y ∧ On x b ∧ On y b" using asm by blast
qed

end
