theory question_1_4
imports Main
begin

typedecl entity
typedecl event

consts
  ScientificGuess :: "entity ⇒ bool"
  CauseAndEffect :: "event ⇒ bool"
  About :: "entity ⇒ event ⇒ bool"
  Named :: "entity ⇒ string ⇒ bool"
  Hypothesis :: "entity ⇒ bool"
  Called :: "entity ⇒ string ⇒ bool"
  SpecificTypeOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A scientific guess about the cause and effect of an event is named a hypothesis. *)
axiomatization where
  explanation_1: "∀x e. ScientificGuess x ∧ CauseAndEffect e ∧ About x e ⟶ (Named x 'hypothesis')"

(* Explanation 2: A hypothesis represents a specific type of scientific guess. *)
axiomatization where
  explanation_2: "∀x. Hypothesis x ⟶ SpecificTypeOf x (ScientificGuess)"

theorem hypothesis:
  assumes asm: "ScientificGuess x ∧ CauseAndEffect e ∧ About x e"
  (* Hypothesis: A scientific guess about the cause and effect of an event is called a hypothesis. *)
  shows "Called x 'hypothesis'"
proof -
  from asm have "ScientificGuess x ∧ CauseAndEffect e ∧ About x e" by simp
  then have "Named x 'hypothesis'" using explanation_1 by blast
  then have "Called x 'hypothesis'" using Named_Called_axiom by blast
  show ?thesis using asm `Named x 'hypothesis'` by blast
qed

end
