theory question_85_0

imports Main

begin

typedecl entity
typedecl event

consts
  PressureReceptors :: "entity ⇒ bool"
  MainlyFoundIn :: "entity ⇒ entity ⇒ bool"
  Skin :: "entity"
  PacinianCorpuscles :: "entity ⇒ bool"

(* Explanation 1: Pressure receptors are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x. PressureReceptors x ⟶ MainlyFoundIn x Skin"

(* Explanation 2: Pacinian corpuscles are pressure receptors. *)
axiomatization where
  explanation_2: "∀x. PacinianCorpuscles x ⟷ PressureReceptors x"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "MainlyFoundIn x Skin"
proof -
  from asm have "PacinianCorpuscles x" by simp
  then have "PressureReceptors x" using explanation_2 by blast
  then have "MainlyFoundIn x Skin" using explanation_1 by blast
  show ?thesis using asm `PressureReceptors x` by blast
qed

end
