theory question_71_0

imports Main

begin

typedecl entity

consts
  Chloroplasts :: "entity ⇒ bool"
  Chlorophyll :: "entity ⇒ bool"
  Animals :: "entity ⇒ bool"

(* Explanation 1: Chloroplasts contain the green pigment chlorophyll. *)
axiomatization where
  explanation_1: "∀y. Chloroplasts y ⟶ Chlorophyll y"

(* Explanation 2: Animals lack chloroplasts. *)
axiomatization where
  explanation_2: "∀x. Animals x ⟶ ¬Chloroplasts x"

theorem hypothesis:
  assumes asm: "Animals x"
  (* Hypothesis: Animals lack chlorophyll. *)
  shows "¬Chlorophyll x"
proof -
  from asm have "Animals x" by simp
  then have "¬Chloroplasts x" using explanation_2 by blast
  then have "¬Chlorophyll x" using explanation_1 by blast
  show ?thesis using asm "¬Chlorophyll x" by blast
qed

end
