theory question_88_1

imports Main

begin
typedecl entity
typedecl event

consts
  Flip :: "entity ⇒ bool"
  Skills :: "entity ⇒ bool"
  Gymnast :: "entity ⇒ bool"
  Display :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Does :: "event ⇒ bool"
  Flooring :: "entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A flip is a skill displayed by a gymnast. *)
axiomatization where
  explanation_1: "∀x y. Flip x ∧ Skills y ∧ Gymnast y ⟶ Skills x"

(* Explanation 2: Displaying skills with a flip is a rephrasing of "does a flip." *)
axiomatization where
  explanation_2: "∀x y e. Display e ∧ Agent e x ∧ Patient e y ∧ Flip y ⟷ Does e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: Gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip y ∧ Flooring z ∧ Blue z ∧ Does e ∧ Agent e x ∧ Patient e y ∧ On e z"
  (* Hypothesis: A gymnast displays their skills with a flip *)
  shows "∃x y e. Gymnast x ∧ Skills y ∧ Flip y ∧ Display e ∧ Agent e x ∧ Patient e y"
proof -
  {
    assume "Gymnast x ∧ Flip y ∧ Flooring z ∧ Blue z ∧ Does e ∧ Agent e x ∧ Patient e y ∧ On e z"
    then have "Gymnast x ∧ Flip y ∧ Skills y" using explanation_1 by blast
    then have "Gymnast x ∧ Skills y ∧ Flip y ∧ Does e ∧ Agent e x ∧ Patient e y" by blast
    then have "Gymnast x ∧ Skills y ∧ Flip y ∧ Display e ∧ Agent e x ∧ Patient e y" using explanation_2 by blast
  }
  then show ?thesis using asm by blast
qed

end
