theory question_41_0
```
imports Main

begin

typedecl entity
typedecl event

consts
  Something :: "entity ⇒ bool"
  MagneticMaterial :: "entity ⇒ bool"
  LargeAmount :: "event ⇒ bool"
  Attract :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Sand :: "entity ⇒ bool"
  Nonmagnetic :: "entity ⇒ bool"
  Magnet :: "entity ⇒ bool"
  NonmagneticMetal :: "entity ⇒ bool"
  NonmagneticMaterials :: "entity ⇒ bool"
  MoveCloser :: "event ⇒ bool"
  TwoObjects :: "entity ⇒ bool"
  MoveApart :: "event ⇒ bool"
  Separate :: "event ⇒ bool"

(* Explanation 1: if something contains a large amount of magnetic material then that something will attract magnets. *)
axiomatization where
  explanation_1: "∀x y e. Something(x) ∧ MagneticMaterial(y) ∧ LargeAmount(e) ∧ Attract(e) ∧ Agent(e, x) ∧ Patient(e, y)"

(* Explanation 2: sand is nonmagnetic. *)
axiomatization where
  explanation_2: "∀x. Sand(x) ∧ Nonmagnetic(x)"

(* Explanation 3: a magnet will not attract nonmagnetic metals; nonmagnetic materials. *)
axiomatization where
  explanation_3: "∀x y e. Magnet(x) ∧ NonmagneticMetal(y) ∧ NonmagneticMaterials(e) ∧ NotAttract(e) ∧ Agent(e, x) ∧ Patient(e, y)"

(* Explanation 4: attract means move closer. *)
axiomatization where
  explanation_4: "∀x y e. Attract(e) ∧ MoveCloser(e) ∧ Agent(e, x) ∧ Patient(e, y)"

(* Explanation 5: if two objects move apart from each other then those two objects separate from each other. *)
axiomatization where
  explanation_5: "∀x y e1 e2. TwoObjects(x) ∧ MoveApart(e1) ∧ Separate(e2) ∧ Agent(e1, x) ∧ Patient(e1, y)"

(* Premise: during science class, students combined 1 kg of iron filings with 1 kg of sand to create a mixture. *)
axiomatization where
  premise_1: "∃x y e. Students(x) ∧ ScienceClass(y) ∧ Combine(e) ∧ Agent(e, x) ∧ Patient(e, y)"

(* Hypothesis: the mixture will attract magnets. *)
axiomatization where
  hypothesis_1: "∀x e. Mixture(x) ∧ Attract(e) ∧ Agent(e, x)"

(* Conclusion: the mixture will separate from the sand. *)
axiomatization where
  conclusion_1: "∀x y e. Mixture(x) ∧ Separate(e) ∧ Agent(e, x) ∧ Patient(e, y)"

proof -
  from premise_1 have "Mixture(x)" by simp
  then obtain e1 where e1: "Attract(e1) ∧ Agent(e1, x)" by (rule attract_def)
  then obtain e2 where e2: "Separate(e2) ∧ Agent(e2, x)" by (rule separate_def)
  from e1, e2 have "MoveCloser(e1)" by (rule move_closer_def)
  from e1, e2 have "NotAttract(e2)" by (rule not_attract_def)
  from premise_1, e1, e2 have "Patient(e1, y)" by (rule patient_def)
  from premise_1, e1, e2 have "Patient(e2, y)" by (rule patient_def)
  from e1, e2 have "MoveApart(e2)" by (rule move_apart_def)
  from e1, e2 have "Separate(e2)" by (rule separate_def)
  then show ?thesis by (rule conclusion_1)
qed

end