/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.morph;

import java.util.ArrayList;
import java.util.List;
import simplenlg.features.Case;
import simplenlg.features.NumberAgr;
import simplenlg.features.WordMorph;
import simplenlg.lexicon.morph.NounInflectionPattern;

public class NounInflectionPattern {
    String[] suffixSg = new String[]{"", "", "", ""};
    String[] suffixPl = new String[]{"", "", "", ""};
    List<WordMorph> features = new ArrayList<WordMorph>();

    public NounInflectionPattern() {
    }

    public NounInflectionPattern(String[] suffixSg, String[] suffixPl) {
        this();
        this.suffixSg = suffixSg;
        this.suffixPl = suffixPl;
    }

    public NounInflectionPattern(String[] suffixSg, String[] suffixPl, WordMorph ... feats) {
        this(suffixSg, suffixPl);
        for (WordMorph f : feats) {
            this.features.add(f);
        }
    }

    public String apply(String stem, Case c, NumberAgr n) {
        String suffix = this.getSuffix(c, n);
        if (this.features.contains(WordMorph.FULL_FORMS)) {
            return suffix;
        }
        if (this.features.contains(WordMorph.STEM_E_ELISION) && !suffix.equals("")) {
            stem = NounInflectionPattern.elideFinalE(stem);
        }
        return stem + suffix;
    }

    private String getSuffix(Case c, NumberAgr n) {
        String[] suffixList = n == NumberAgr.SINGULAR ? this.suffixSg : this.suffixPl;
        switch (1.$SwitchMap$simplenlg$features$Case[c.ordinal()]) {
            default: {
                return suffixList[0];
            }
            case 2: {
                return suffixList[1];
            }
            case 3: {
                return suffixList[2];
            }
            case 4: 
        }
        return suffixList[3];
    }

    private static final String elideFinalE(String base) {
        int i = base.lastIndexOf("e");
        if (i == -1) {
            return base;
        }
        return base.substring(0, i) + base.substring(i + 1);
    }
}

