/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.type;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.Property;

public class Type
extends Property {
    protected static final String NONE = "none";
    protected static final String SRC = "src";
    protected static final String TRG = "trg";
    protected EqType m_type;

    public Type() {
        this.m_type = EqType.NONE;
    }

    public Type(EqType type) {
        this.setType(type);
    }

    public void setType(EqType type) {
        this.m_type = type == null ? EqType.NONE : type;
    }

    public EqType getType() {
        return this.m_type;
    }

    public String toString() {
        return this.persistToString();
    }

    @Override
    public String persistToString() {
        return EqType.NONE.equals((Object)this.m_type) ? NONE : (EqType.SOURCE.equals((Object)this.m_type) ? SRC : TRG);
    }

    @Override
    public void unpersistFromString(EquivalenceClass eq, String str) throws Exception {
        if (SRC.equalsIgnoreCase(str)) {
            this.m_type = EqType.SOURCE;
        } else if (TRG.equalsIgnoreCase(str)) {
            this.m_type = EqType.TARGET;
        } else if (NONE.equalsIgnoreCase(str)) {
            this.m_type = EqType.NONE;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static enum EqType {
        SOURCE,
        TARGET,
        NONE;

    }
}

