/*
 * Decompiled with CFR 0.152.
 */
package tsg.fragStats;

import java.io.File;
import java.io.PrintWriter;
import java.util.Scanner;
import java.util.TreeSet;
import tsg.ComparatorTSNodeLabelFreq;
import tsg.TSNodeLabel;
import util.Duet;
import util.FileUtil;

public class DistributeTreeBankInDepthFiles {
    public static void distribute(File treebankFile) throws Exception {
        File parentDir = treebankFile.getParentFile().getCanonicalFile();
        String newDirPath = parentDir + "/depths/";
        File newDir = new File(newDirPath);
        newDir.mkdir();
        String ouputFilePathPrefix = String.valueOf(newDirPath) + "fragments_depth";
        DistributeTreeBankInDepthFiles.distributeUnsorted(treebankFile, ouputFilePathPrefix);
    }

    public static void distributeUnsorted(File treebankFile, String ouputFilePathPrefix) throws Exception {
        int maxDepth = 100;
        int maxBranching = 100;
        int foundMaxBranching = 0;
        int foundMaxDepth = 0;
        int[] depthTotalTypes = new int[maxDepth];
        int[] depthTotalTokens = new int[maxDepth];
        int[][] branchingTotalTokens = new int[maxDepth][maxBranching];
        int[] depthTypesMoreThanOnce = new int[maxDepth];
        File[] ouputFileArray = new File[maxDepth];
        PrintWriter[] printWriterArray = new PrintWriter[maxDepth];
        int i = 0;
        while (i < maxDepth) {
            File outputFile;
            String depthNumber = i < 10 ? "0" + i : "" + i;
            ouputFileArray[i] = outputFile = new File(String.valueOf(ouputFilePathPrefix) + "_" + depthNumber);
            printWriterArray[i] = FileUtil.getPrintWriter(outputFile);
            ++i;
        }
        Scanner scan = FileUtil.getScanner(treebankFile);
        while (scan.hasNextLine()) {
            int branching;
            String line = scan.nextLine();
            if (line.equals("")) continue;
            String[] lineSplit = line.split("\t");
            TSNodeLabel tree = new TSNodeLabel(lineSplit[0], false);
            int depth = tree.maxDepth();
            if (depth > foundMaxDepth) {
                foundMaxDepth = depth;
            }
            if ((branching = tree.maxBranching()) > foundMaxBranching) {
                foundMaxBranching = branching;
            }
            printWriterArray[depth].println(line);
            int freq = lineSplit.length == 2 ? Integer.parseInt(lineSplit[1]) : 1;
            int n = depth;
            depthTotalTokens[n] = depthTotalTokens[n] + freq;
            int n2 = depth;
            depthTotalTypes[n2] = depthTotalTypes[n2] + 1;
            int[] nArray = branchingTotalTokens[depth];
            int n3 = branching;
            nArray[n3] = nArray[n3] + freq;
            if (freq <= 1) continue;
            int n4 = depth;
            depthTypesMoreThanOnce[n4] = depthTypesMoreThanOnce[n4] + 1;
        }
        scan.close();
        int i2 = 1;
        while (i2 < maxDepth) {
            printWriterArray[i2].close();
            if (i2 > foundMaxDepth) {
                ouputFileArray[i2].delete();
            }
            ++i2;
        }
        File depthReportFile = new File(new File(ouputFilePathPrefix).getParentFile() + "/depthReport.txt");
        File branchingReportFile = new File(new File(ouputFilePathPrefix).getParentFile() + "/branchingReport.txt");
        PrintWriter depthReportPW = FileUtil.getPrintWriter(depthReportFile);
        PrintWriter branchingReportPW = FileUtil.getPrintWriter(branchingReportFile);
        depthReportPW.println("Depth\tTotalTypes\tTotalTokens\tTotalType>1");
        branchingReportPW.println("Depth\tTotalTokens");
        int i3 = 1;
        while (i3 < maxDepth) {
            depthReportPW.println(String.valueOf(i3) + "\t" + depthTotalTypes[i3] + "\t" + depthTotalTokens[i3] + "\t" + depthTypesMoreThanOnce[i3]);
            branchingReportPW.print(i3);
            int b = 1;
            while (b < foundMaxBranching) {
                branchingReportPW.print("\t" + branchingTotalTokens[i3][b]);
                ++b;
            }
            branchingReportPW.println();
            ++i3;
        }
        depthReportPW.close();
        branchingReportPW.close();
    }

    public static void distributeSorted(File treebankFile, String ouputFilePathPrefix) throws Exception {
        int maxDepth = 100;
        int maxBranching = 100;
        int foundMaxBranching = 0;
        TreeSet[] depthCollectors = new TreeSet[maxDepth];
        int[] depthTotalFreq = new int[maxDepth];
        int[][] branchingTotalFreq = new int[maxDepth][maxBranching];
        int[] depthTypesMoreThanOnce = new int[maxDepth];
        ComparatorTSNodeLabelFreq c = new ComparatorTSNodeLabelFreq();
        int i = 0;
        while (i < maxDepth) {
            depthCollectors[i] = new TreeSet(c);
            ++i;
        }
        Scanner scan = FileUtil.getScanner(treebankFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            String[] lineSplit = line.split("\t");
            TSNodeLabel tree = new TSNodeLabel(lineSplit[0], false);
            int depth = tree.maxDepth();
            int branching = tree.maxBranching();
            if (branching > foundMaxBranching) {
                foundMaxBranching = branching;
            }
            int freq = lineSplit.length == 2 ? Integer.parseInt(lineSplit[1]) : 1;
            int[] freqArray = new int[]{freq};
            Duet<TSNodeLabel, int[]> d = new Duet<TSNodeLabel, int[]>(tree, freqArray);
            depthCollectors[depth].add(d);
            int n = depth;
            depthTotalFreq[n] = depthTotalFreq[n] + freq;
            int[] nArray = branchingTotalFreq[depth];
            int n2 = branching;
            nArray[n2] = nArray[n2] + freq;
            if (freq <= 1) continue;
            int n3 = depth;
            depthTypesMoreThanOnce[n3] = depthTypesMoreThanOnce[n3] + 1;
        }
        scan.close();
        File depthReportFile = new File(new File(ouputFilePathPrefix).getParentFile() + "/depthReport.txt");
        File branchingReportFile = new File(new File(ouputFilePathPrefix).getParentFile() + "/branchingReport.txt");
        PrintWriter depthReportPW = FileUtil.getPrintWriter(depthReportFile);
        PrintWriter branchingReportPW = FileUtil.getPrintWriter(branchingReportFile);
        depthReportPW.println("Depth\tTotalTypes\tTotalTokens\tTotalType>1");
        branchingReportPW.println("Depth\tTotalTokens");
        int i2 = 0;
        while (i2 < maxDepth) {
            TreeSet collector = depthCollectors[i2];
            if (!collector.isEmpty()) {
                String depthNumber = i2 < 10 ? "0" + i2 : "" + i2;
                depthReportPW.println(String.valueOf(i2) + "\t" + collector.size() + "\t" + depthTotalFreq[i2] + "\t" + depthTypesMoreThanOnce[i2]);
                branchingReportPW.print(i2);
                int b = 1;
                while (b < foundMaxBranching) {
                    branchingReportPW.print("\t" + branchingTotalFreq[i2][b]);
                    ++b;
                }
                branchingReportPW.println();
                File ouputFile = new File(String.valueOf(ouputFilePathPrefix) + "_" + depthNumber);
                PrintWriter pw = FileUtil.getPrintWriter(ouputFile);
                for (Duet d : collector) {
                    pw.println(String.valueOf(((TSNodeLabel)d.getFirst()).toString(false, true)) + "\t" + ((int[])d.getSecond())[0]);
                }
                pw.close();
            }
            ++i2;
        }
        depthReportPW.close();
        branchingReportPW.close();
    }

    public static void main1(String[] args) throws Exception {
        String workingDir = "/home/fsangati/RESULTS/TSG/TSGkernels/subBranch/20/";
        File treebankFile = new File(String.valueOf(workingDir) + "fragments_subBranch_MUB_20_freq.txt");
        String ouputFilePathPrefix = String.valueOf(workingDir) + "depths/fragments_MUB_freq_depth";
        DistributeTreeBankInDepthFiles.distributeUnsorted(treebankFile, ouputFilePathPrefix);
    }

    public static void main(String[] args) throws Exception {
        File treebankFile = new File(args[0]);
        String ouputFilePathPrefix = String.valueOf(treebankFile.getParent()) + "/depths/";
        new File(ouputFilePathPrefix).mkdir();
        ouputFilePathPrefix = String.valueOf(ouputFilePathPrefix) + "fragments_depth";
        DistributeTreeBankInDepthFiles.distributeUnsorted(treebankFile, ouputFilePathPrefix);
    }
}

