/*
 * Decompiled with CFR 0.152.
 */
package tsg.evalHeads;

import java.util.ListIterator;
import tsg.TSNode;
import tsg.corpora.ConstCorpus;
import util.PrintProgressStatic;

public class EvalDependency {
    public static int[] evalHeads(ConstCorpus Eval, ConstCorpus Gold, int limit) {
        ListIterator<TSNode> i = Eval.treeBank.listIterator();
        ListIterator<TSNode> j = Gold.treeBank.listIterator();
        int[] score = new int[2];
        while (i.hasNext() && j.hasNext() && i.previousIndex() != limit) {
            TSNode EvalTree = i.next();
            TSNode GoldTree = j.next();
            EvalDependency.updateScore(EvalTree, GoldTree, score);
        }
        return score;
    }

    public static int[] evalDependencyWorseScores(ConstCorpus Eval, ConstCorpus Gold, int limit) {
        ListIterator<TSNode> i = Eval.treeBank.listIterator();
        ListIterator<TSNode> j = Gold.treeBank.listIterator();
        int[] score = new int[2];
        float worse_ratio = 1.0f;
        int worse_ratio_index = -1;
        int worse_ratio_tot = 0;
        int worse_ratio_rec = 0;
        PrintProgressStatic.start("Evaluating heads on sentence: ");
        while (i.hasNext() && j.hasNext() && i.previousIndex() != limit) {
            float ratio;
            TSNode EvalTree = i.next();
            TSNode GoldTree = j.next();
            int temp_tot = score[0];
            int temp_rec = score[1];
            EvalDependency.updateScore(EvalTree, GoldTree, score);
            PrintProgressStatic.next();
            int delta_tot = score[0] - temp_tot;
            int delta_rec = score[1] - temp_rec;
            if (delta_tot <= 0 || !((double)(ratio = (float)delta_rec / (float)delta_tot) < 0.7)) continue;
            System.out.println("Worse ratio index: " + i.previousIndex() + " (" + delta_rec + "/" + delta_tot + " --> " + ratio + " %)");
        }
        PrintProgressStatic.end();
        System.out.println("Worse ratio index: " + worse_ratio_index + " (" + worse_ratio_rec + "/" + worse_ratio_tot + " --> " + worse_ratio + " %)");
        return score;
    }

    private static void updateScore(TSNode EvalTree, TSNode GoldTree, int[] score) {
        if (EvalTree.daughters == null) {
            return;
        }
        int indexHeadEval = -1;
        int indexHeadGold = -1;
        int headNumberEval = 0;
        int headNumberGold = 0;
        int i = 0;
        while (i < EvalTree.daughters.length) {
            TSNode Evaldaughter = EvalTree.daughters[i];
            TSNode Golddaughter = GoldTree.daughters[i];
            if (Evaldaughter.isHeadMarked()) {
                indexHeadEval = i;
                ++headNumberEval;
            }
            if (Golddaughter.isHeadMarked()) {
                indexHeadGold = i;
                ++headNumberGold;
            }
            EvalDependency.updateScore(Evaldaughter, Golddaughter, score);
            ++i;
        }
        if (headNumberGold == 1 && EvalTree.daughters.length > 1 && headNumberEval != 0) {
            score[0] = score[0] + 1;
            if (indexHeadGold == indexHeadEval) {
                score[1] = score[1] + 1;
            }
        }
    }
}

