/*
 * Decompiled with CFR 0.152.
 */
package kernels;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import kernels.NodeSetCollector;
import util.Utility;

public class NodeSetCollectorStandard
extends NodeSetCollector {
    HashSet<BitSet> bitSetSet;
    public ArrayList<BitSet> bitSetArray = new ArrayList();

    public NodeSetCollectorStandard() {
        this.bitSetSet = new HashSet();
    }

    @Override
    public Object clone() {
        NodeSetCollectorStandard clone = new NodeSetCollectorStandard();
        clone.bitSetSet = (HashSet)this.bitSetSet.clone();
        clone.bitSetArray = (ArrayList)this.bitSetArray.clone();
        return clone;
    }

    @Override
    public void makeEmpty() {
        this.bitSetSet.clear();
        this.bitSetArray.clear();
    }

    @Override
    public boolean add(BitSet newBs) {
        if (this.bitSetSet.add(newBs)) {
            this.bitSetArray.add(newBs);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(NodeSetCollector collector) {
        boolean result = false;
        NodeSetCollectorStandard coll = (NodeSetCollectorStandard)collector;
        for (BitSet bs : coll.bitSetArray) {
            boolean bl = result = this.add(bs) || result;
        }
        return result;
    }

    @Override
    public boolean addAllCombinations(NodeSetCollector[] collectors, int[] collectorsSizes, int defaultBitSet) {
        int[][] combinations;
        boolean result = false;
        int[][] nArray = combinations = Utility.combinations(collectorsSizes);
        int n = combinations.length;
        int n2 = 0;
        while (n2 < n) {
            int[] comb = nArray[n2];
            BitSet ks = this.getDefaultBitSet(defaultBitSet);
            int i = 0;
            while (i < collectors.length) {
                int comb_i = comb[i];
                BitSet choosenBitSet = ((NodeSetCollectorStandard)collectors[i]).bitSetArray.get(comb_i);
                ks.or(choosenBitSet);
                ++i;
            }
            result = this.add(ks) || result;
            ++n2;
        }
        return result;
    }

    @Override
    public boolean removeSingleton(int index) {
        if (this.bitSetArray.isEmpty()) {
            return false;
        }
        Iterator<BitSet> iter = this.bitSetArray.iterator();
        while (iter.hasNext()) {
            BitSet bs = iter.next();
            if (bs.cardinality() != 1 || !bs.get(index)) continue;
            iter.remove();
            this.bitSetSet.remove(bs);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeUniqueSingleton() {
        if (this.bitSetArray.isEmpty()) {
            return false;
        }
        Iterator<BitSet> iter = this.bitSetArray.iterator();
        while (iter.hasNext()) {
            BitSet bs = iter.next();
            if (bs.cardinality() != 1) continue;
            iter.remove();
            this.bitSetSet.remove(bs);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.bitSetArray.size();
    }

    @Override
    public BitSet uniteSubGraphs() {
        BitSet unionBS = new BitSet();
        for (BitSet bs : this.bitSetArray) {
            unionBS.or(bs);
        }
        return unionBS;
    }

    @Override
    public BitSet[] getBitSetsAsArray() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.bitSetArray.toArray(new BitSet[size]);
    }

    @Override
    public int maxCardinality() {
        if (this.isEmpty()) {
            return 0;
        }
        int maxCardinality = -1;
        for (BitSet bs : this.bitSetArray) {
            int bsCard = bs.cardinality();
            if (bsCard <= maxCardinality) continue;
            maxCardinality = bsCard;
        }
        return maxCardinality;
    }

    @Override
    public String toString() {
        String result = "";
        for (BitSet bs : this.bitSetArray) {
            result = String.valueOf(result) + bs.toString() + "\n";
        }
        return result.trim();
    }
}

