/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.metrics.MetricOptimizerArray;
import tsg.parsingExp.TSGparsingBitPar;
import util.FileUtil;

public class TSGparsingBitParNoThreads
extends TSGparsingBitPar {
    MetricOptimizerArray metricOptimizer = new MetricOptimizerArray();

    public TSGparsingBitParNoThreads(File trainingFile, File testFile, File fragmentFile, File outputDir) {
        super(trainingFile, testFile, fragmentFile, outputDir);
    }

    @Override
    public String getClassName() {
        return "TSGparsingBitParNoThreads";
    }

    @Override
    protected void parseWithBitPar() throws Exception {
        Parameters.reportLineFlush("Parsing with BitPar");
        String bitParBuildingFilesPath = String.valueOf(this.outputPath) + "BitParWorkingDir/";
        File bitParBuildingFilesDir = new File(bitParBuildingFilesPath);
        bitParBuildingFilesDir.mkdir();
        File ouputBitParFile = new File(String.valueOf(bitParBuildingFilesPath) + "outputBitPar_" + nBest + "best.txt");
        File flatFileForBitPar = new File(String.valueOf(bitParBuildingFilesPath) + "flatFileForBitPar.txt");
        ArrayList<String[]> testSentencesWords = TSGparsingBitParNoThreads.getSentencesWords(this.testTreebank);
        TSGparsingBitParNoThreads.printBitParFlatSentence(testSentencesWords, flatFileForBitPar);
        ArrayList<String[]> originalSentencesWords = TSGparsingBitParNoThreads.getSentencesWords(this.originalTestTreebank);
        try {
            String line;
            Process p = Runtime.getRuntime().exec(String.valueOf(bitparCommandAndArgs) + " " + flatFileForBitPar + " " + ouputBitParFile);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                Parameters.reportLineFlush("BitParStdOut:" + line);
            }
            input = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = input.readLine()) != null) {
                Parameters.reportLineFlush("BitParStdErr:" + line);
            }
            input.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.postProcessNbest(ouputBitParFile, originalSentencesWords);
        this.parsedOutputFiles = this.metricOptimizer.makeFileOutputList(String.valueOf(this.outputPath) + "BITPAR_", ".mrg");
        this.parsedOutputFilesIdentifiers = this.metricOptimizer.getIdentifiers();
        this.metricOptimizer.appendResult(this.parsedOutputFiles);
        Parameters.reportLineFlush("Finished Parsing.");
    }

    private void postProcessNbest(File ouputBitParFile, ArrayList<String[]> originalSentencesWords) throws Exception {
        Scanner scan = FileUtil.getScanner(ouputBitParFile);
        if (!scan.hasNextLine()) {
            Parameters.reportLineFlush("EMPTY FILE!!!!");
            scan.close();
            return;
        }
        Iterator<String[]> originalTestIterator = null;
        String[] originalTestSentenceWords = null;
        originalTestIterator = originalSentencesWords.iterator();
        originalTestSentenceWords = originalTestIterator.next();
        double lastReadProb = -1.0;
        TSNodeLabel tree = null;
        this.metricOptimizer.prepareNextSentence(originalTestSentenceWords);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) {
                this.metricOptimizer.storeCurrentBestParseTrees();
                if (!originalTestIterator.hasNext()) continue;
                originalTestSentenceWords = originalTestIterator.next();
                this.metricOptimizer.prepareNextSentence(originalTestSentenceWords);
                continue;
            }
            if (line.charAt(0) == '(') {
                line = line.replaceAll("\\\\", "");
                try {
                    tree = new TSNodeLabel(line);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tree = this.postProcessParseTree(tree);
                this.metricOptimizer.addNewDerivation(tree, lastReadProb);
                continue;
            }
            if (line.startsWith("vitprob=")) {
                lastReadProb = Double.parseDouble(line.substring(viterbProbPrefixLength));
                continue;
            }
            if (line.startsWith("No parse for: ")) {
                tree = this.dealWithNOParsedSentences(originalTestSentenceWords);
                this.metricOptimizer.addNewDerivation(tree, lastReadProb);
                continue;
            }
            System.out.println("Unknown line in bitpar output: " + line);
        }
        scan.close();
    }
}

