# Project Repository Structure

```plaintext
├───Datasets
│   ├───Ablation Study
│   ├───Hypothesis
│   ├───NQ
│   ├───TriviaQA
│   └───WebQ
└───Results
    ├───Ablation Study
    │   ├───Few-Shot
    │   │   ├───LLaMA-7b
    │   │   └───T5-3b
    │   └───Zero-Shot
    │       ├───LLaMA-7b
    │       └───T5-3b
    ├───Baselines
    │   ├───Few-Shot
    │   │   ├───LLaMA-7b
    │   │   └───T5-3b
    │   └───Zero-Shot
    │       ├───LLaMA-7b
    │       └───T5-3b
    ├───HiGenQA
    │   ├───Few-Shot
    │   │   ├───LLaMA-7b
    │   │   └───T5-3b
    │   └───Zero-Shot
    │       ├───LLaMA-7b
    │       └───T5-3b
    └───Hypothesis
```

This repository is organized into two main directories: `Datasets` and `Results`. Below is a detailed explanation of their contents and structure.

## Datasets

This directory includes several components:

- **TriviaQA, NQ, and WebQ**:
  - Datasets for which hints were generated using the Hint-Generation system, utilizing both the vanilla LLaMA-70b and LLaMA-70b fine-tuned on [TriviaHG](https://github.com/DataScienceUIBK/TriviaHG).

- **Hypothesis**:
  - Contains three files, each with 200 questions. These files include the generated context by generation-based methods, the retrieved passage by retrieval-based methods, and the hints produced by hint-generation methods.

- **Ablation Study**:
  - Contains eleven files, each with hints generated by various LLMs for 100 questions, exploring different configurations and settings in the hint-generation process.

## Results

This directory stores the results of QA systems, divided by methodological approaches and learning strategies:

- **Ablation Study**:
  - Contains results for experiments conducted on 100 questions, testing various LLMs in the hint-generation process.

- **Hypothesis**:
  - Contains results for 200 questions, evaluating the effectiveness of different hypothesis generation approaches.

- **Baselines**:
  - Results from traditional methods such as retrieval-based and generation-based approaches. Includes both few-shot and zero-shot learning strategies, with results using T5-3b and LLaMA-7b as readers.

- **HiGenQA**:
  - Represents the results of our specific approach, using both few-shot and zero-shot learning strategies. Also utilizes T5-3b and LLaMA-7b as readers.