#!/bin/bash
set -x
dir=$1
port=$3
#/mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/training/step1_supervised_finetuning/actor-models/bloom7bmt_10sents_en2de_2048/
#/mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/output/actor-models/bloom7bmt_10sents_en2de/
#/mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/output/actor-models/bloomz7b_10sents_en2de

#/mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/output/actor-models/bloom7bmt_10sents_en2de_2048
#/mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/output/actor-models/bloomz7bmt_doc_lora_zh2en_10sents/
#dir=/mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/output/actor-models/bloomz7b_doc_lora_and_bloom_zh2en_10sents_2
ref=/mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/de-en/iwslt16.de
pretrain_model=$2
#ref = "/mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/zh-en/wmt22.en1 /mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/zh-en/wmt22.en2"
testset=/mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/iwslt17_en2de/en-de/test.split.jsonl
#testset=/mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/zh-en/wmt22.zh.split.jsonl
models=`ls -d -t -r  $dir/step*`
#models="$dir/epoch0 $dir/epoch1 $dir/epoch2 $dir/epoch3 $dir/epoch4 $dir/epoch5 $dir/epoch6 $dir/epoch7 $dir/epoch8 $dir/epoch9 $dir/epoch10"
evals=$dir/evals
mkdir -p $evals

#export CUDA_VISIBLE_DEVICES=0
for model in $models
do
    epoch=${model##*\/}
    echo $epoch
    if [ -s $evals/trans.$epoch.trans.bleu ];
    then
        continue
        echo "continue"
    fi 
    if [ ! -s $model/convert/pytorch_model.bin ];
    then 
        mkdir -p $model/convert
        python /mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/training/step1_supervised_finetuning/evaluation_scripts/convert_lora_model.py \
        --model_path $model/pytorch_model.bin --save_dir $model/convert --lora_dim 128
        cp $model/config.json $model/convert/
    fi 
    torchrun --nproc_per_node 1  --master_port $port \
        /mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/training/step1_supervised_finetuning/prompt_eval_test.py \
        --deepspeed  --model_name_or_path_baseline  $pretrain_model \
        --model_name_or_path_finetune $model/convert \
        --input $testset --language English --zero_stage 1 \
        --output $evals/trans.$epoch
    python  /mnt/user/E-xiaoyi.zp-102098/tools/get_prediction.py $evals/trans.$epoch >   $evals/trans.$epoch.trans
 
    cat  $evals/trans.$epoch.trans |  sacrebleu -l en-de  $ref -lc > $evals/trans.$epoch.trans.bleu_lc
    cat  $evals/trans.$epoch.trans |   sacrebleu -l en-de  $ref  > $evals/trans.$epoch.trans.bleu
done

