export REPO_ROOT=

export CARLA_ROOT=${REPO_ROOT}/carla/CARLA_0.9.10.1
export CARLA_SERVER=${CARLA_ROOT}/CarlaUE4.sh
export LEADERBOARD_ROOT=${REPO_ROOT}/leaderboard
export SCENARIO_RUNNER_ROOT=${REPO_ROOT}/scenario_runner

export PYTHONPATH=${PYTHONPATH}:${CARLA_ROOT}/PythonAPI
export PYTHONPATH=${PYTHONPATH}:${CARLA_ROOT}/PythonAPI/carla
export PYTHONPATH=${PYTHONPATH}:${CARLA_ROOT}/PythonAPI/carla/dist/carla-0.9.10-py3.7-linux-x86_64.egg
export PYTHONPATH=${PYTHONPATH}:${LEADERBOARD_ROOT}
export PYTHONPATH=${PYTHONPATH}:${SCENARIO_RUNNER_ROOT}

export SCENARIOS=${LEADERBOARD_ROOT}/data/all_towns_traffic_scenarios_public.json
export ROUTES=${LEADERBOARD_ROOT}/data/routes_devtest.xml
export REPETITIONS=1
export DEBUG_CHALLENGE=1
export TEAM_AGENT=${LEADERBOARD_ROOT}/leaderboard/autoagents/human_agent.py
export CHECKPOINT_ENDPOINT=${LEADERBOARD_ROOT}/results.json
export CHALLENGE_TRACK_CODENAME=SENSORS

python3 ${LEADERBOARD_ROOT}/leaderboard/leaderboard_evaluator.py \
  --scenarios=${SCENARIOS} \
  --routes=${ROUTES} \
  --repetitions=${REPETITIONS} \
  --routes-subset=${ROUTES_SUBSET} \
  --track=${CHALLENGE_TRACK_CODENAME} \
  --checkpoint=${CHECKPOINT_ENDPOINT} \
  --agent=${TEAM_AGENT} \
  --agent-config=${TEAM_CONFIG} \
  --debug=${DEBUG_CHALLENGE} \
  --record=${RECORD_PATH} \
  --resume=${RESUME}
