theory question_15_9

imports Main

begin

typedecl entity

consts
  HormonalImbalance :: "entity ⇒ bool"
  ChemicalMessengerImbalance :: "entity ⇒ bool"
  CanCause :: "entity ⇒ entity ⇒ bool"
  Depression :: "entity"
  Affecting :: "entity ⇒ entity ⇒ bool"
  BodyFunctions :: "entity ⇒ bool"
  ControlledBy :: "entity ⇒ entity ⇒ bool"
  Hormones :: "entity ⇒ bool"

theorem hypothesis:
  assumes asm: "ChemicalMessengerImbalance x"
  (* Hypothesis: Chemical messengers for them to cause depression are imbalanced. *)
  shows "Imbalanced x"
proof -
  from asm have "ChemicalMessengerImbalance x" by simp
  then have "HormonalImbalance x" by (rule explanation_1)
  then have "Affecting Depression (Hormones x)" by (rule explanation_3)
  then have "BodyFunctions (Hormones x)" by (rule explanation_2)
  then have "Imbalanced x" by (rule explanation_2)
  then show ?thesis by simp
qed

end
