theory question_61_8

imports Main

begin

typedecl entity

consts
  Sun :: "entity ⇒ bool"
  LargestBodyInSolarSystem :: "entity ⇒ bool"
  CelestialBody :: "entity ⇒ bool"

(* Explanation 1: The Sun is the unique entity that is the largest celestial body in the solar system. *)
axiomatization where
  explanation_1: "∃x. Sun x ∧ (∀y. LargestBodyInSolarSystem y ⟷ y = x) ∧ CelestialBody x"

(* Explanation 2: Every largest body in the solar system is a celestial body and is the Sun. *)
axiomatization where
  explanation_2: "∀x. LargestBodyInSolarSystem x ⟷ (CelestialBody x ∧ Sun x)"

theorem hypothesis:
  assumes asm: "CelestialBody x"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "∃x. LargestBodyInSolarSystem x ∧ Sun x"
proof -
  from explanation_1
  obtain x where "Sun x ∧ (∀y. LargestBodyInSolarSystem y ⟷ y = x) ∧ CelestialBody x" by blast
  then have "Sun x ∧ LargestBodyInSolarSystem x" by blast
  then show ?thesis by blast
qed

end
