theory question_100_1

imports Main

begin
typedecl entity
typedecl event

consts
  YoungBoy :: "entity ⇒ bool"
  Child :: "entity ⇒ bool"
  Sprinklers :: "entity ⇒ bool"
  Swimsuit :: "entity ⇒ bool"
  InvolvesWater :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  InSprinklers :: "entity ⇒ entity ⇒ bool"
  InWater :: "entity ⇒ bool"
  Plays :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A young boy is a child. *)
axiomatization where
  explanation_1: "∀x. YoungBoy x ⟶ Child x"

(* Explanation 2: Sprinklers are entities that involve water. *)
axiomatization where
  explanation_2: "∀x. Sprinklers x ⟶ InvolvesWater x"

(* Explanation 3: Sprinklers are entities that are outside. *)
axiomatization where
  explanation_3: "∀x. Sprinklers x ⟶ Outside x"

(* Explanation 4: When an entity is in sprinklers, it is in water. *)
axiomatization where
  explanation_4: "∀x y. InSprinklers x y ⟶ InWater x"

theorem hypothesis:
  (* Premise: Young boy in swimsuit plays in sprinklers outside *)
  assumes asm: "YoungBoy x ∧ Swimsuit y ∧ Plays e ∧ Agent e x ∧ InSprinklers x y ∧ Outside x"
  (* Hypothesis: A child outside in water. *)
  shows "∃x. Child x ∧ Outside x ∧ InWater x"
proof -
  from asm have "YoungBoy x" by blast
  from this have "Child x" using explanation_1 by blast
  from asm have "Outside x" by blast
  from asm have "InSprinklers x _" by blast
  from this have "InWater x" using explanation_4 by blast
  show ?thesis using `Child x` `Outside x` `InWater x` by blast
qed

end
