theory question_81_0

imports Main


begin
typedecl entity
typedecl event

consts
  Bike :: "entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  ShortWordFor :: "entity ⇒ entity ⇒ bool"
  Person :: "entity ⇒ bool"
  SoaringOverTheGround :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Jumps :: "event ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Bike is the short word for bicycle. *)
axiomatization where
  explanation_1: "∀x y. Bike x ∧ Bicycle y ⟶ ShortWordFor x y"

(* Explanation 2: The person is outside if the person is soaring over the ground. *)
axiomatization where
  explanation_2: "∀x. Person x ∧ SoaringOverTheGround x ⟶ Outside x"


theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Jumps e1 ∧ Soaring e2 ∧ Agent e1 x ∧ Agent e2 x ∧ Patient e1 z ∧ Patient e2 y ∧ InFrontOf x Skyline ∧ InFrontOf x Lake"
  (* Hypothesis: A person outside with a bike. *)
  shows "∃x y. Person x ∧ Bike y ∧ Outside x"
proof -
  from asm have "Person x ∧ Bicycle y" by blast
  then have "SoaringOverTheGround x" using asm explanation_2 by blast
  then have "Outside x" using asm explanation_2 by blast
  then have "Bike y" using asm explanation_1 by blast
  then show ?thesis using `Person x` `Bike y` `Outside x` by blast
qed

end
