from langchain.prompts import PromptTemplate
# this is more like a multi-agent reflection, since MAD also includes solution in the each debate
# whereas here we are just asking for different refleciton
# So I call this MAR (multi-agent reflection)

level0 = "Both sides must reach a full consensus on every point of the debate. Every statement must be agreed upon by both sides."
level1 = "Most of the debate should be characterized by disagreements, but there may still be a small amount of consensus on less significant points."
level2 = "It’s not necessary to fully agree with each other’s perspectives, as our objective is to find the correct answer."
level3 = "Both sides must disagree with each other on every point of the debate. There should be no consensus whatsoever."

levels = {0: level0, 1: level1, 2: level2, 3: level3}

SYSTEM_INSTRUCTION = """" You are a debater . Hello and welcome to the task of evaluating reflections to a question answer, which will be conducted in a debate format.
The debate topic is stated as follows: You will be given a previous reasoning trial in which you were given access to relevant context and a question to answer. A reflection generated by another agent has also been given to you. You want to debate with it and diagnose a possible reason for failure or phrasing discrepancy and devise a new, concise, high level plan that aims to mitigate the same failure and get the correct answer. Pay attention to what the question is actually asking. {debate_level}"""

FIRST_INSTRUCTION = """Here is the relevant context, question, answer, and reflection from the previous trial:

Relevant Context: {context}
Question: {question}{scratchpad}

Reflection:{reflection}"""

MAR_system = PromptTemplate(
                        input_variables=["debate_level"],
                        template = SYSTEM_INSTRUCTION,
                        )

MAR_first = PromptTemplate(
                        input_variables=["context", "question", "scratchpad", "reflection"],
                        template = FIRST_INSTRUCTION,
                        )


