from django.db import models

# Create your models here.


class ExpectationItem(models.Model):

    item_id = models.SmallIntegerField(primary_key=True)

    
    # metric
    task_string = models.TextField() 
    expression = models.TextField()
    min_val = models.FloatField()
    max_val = models.FloatField()
    physical_unit = models.CharField(max_length=12)
    
    # imperial
    task_string_us = models.TextField()
    expression_us = models.TextField()
    min_val_us = models.FloatField()
    max_val_us = models.FloatField()
    physical_unit_us = models.CharField(max_length=12)

    # stepsize
    stepsize = models.FloatField()

    # defaults
    lower_def = models.FloatField()
    upper_def = models.FloatField()

    source_feature = models.TextField()
    target_feature = models.TextField()

    def __str__(self):
        stringrep = str(self.item_id) + "_unit_" + str(self.physical_unit) + "_source=" + self.source_feature + "_target=" + self.target_feature + "_" + self.expression[:8]
        return stringrep
    

class SessionItem(models.Model):
    # no overriden primary key since each session
    # shall be registered individually and thread-safe

    item_id = models.ForeignKey(ExpectationItem, on_delete=models.PROTECT)
    prolific_id = models.TextField(default=None, blank=True, null=True)
    session_id = models.SmallIntegerField() #(primary_key=True)
    unit_type = models.CharField(max_length=15)
    lower_limes = models.FloatField()
    upper_limes = models.FloatField()
    participant_id = models.CharField(max_length=64)
    date_time_stamp = models.DateTimeField(auto_now_add=True)
    #order_pos = models.SmallIntegerField()

    def __str__(self):
        stringrep = self.participant_id + "_" + str(self.session_id) + "_" + str(self.item_id.item_id)
        return stringrep


class DistractorItem(models.Model):
    question_id = models.SmallIntegerField(primary_key=True)
    
    
    # metric
    task_string = models.TextField()
    question_text = models.TextField()
    option_1 = models.TextField()
    option_2 = models.TextField()
    option_3 = models.TextField()


    # imperial
    task_string_us = models.TextField()
    question_text_us = models.TextField()
    option_1_us = models.TextField()
    option_2_us = models.TextField()
    option_3_us = models.TextField()


    def __str__(self):
        stringrep = str(self.question_id)
        return stringrep


    
class AnswerItem(models.Model):
    question_id = models.ForeignKey(DistractorItem, on_delete=models.PROTECT)
    prolific_id = models.TextField(default=None, blank=True, null=True)
    unit_type = models.CharField(max_length=15)
    answer_string = models.TextField()
    participant_id = models.CharField(max_length=64)




class CombinedSessionItem(models.Model):

    #item_id = models.SmallIntegerField(primary_key=True)
    prolific_id = models.TextField(default=None, blank=True, null=True)
    unit_type = models.CharField(max_length=15)

    lower_limes_1 = models.FloatField()
    upper_limes_1 = models.FloatField()
    
    lower_limes_2 = models.FloatField()
    upper_limes_2 = models.FloatField()
    
    lower_limes_3 = models.FloatField()
    upper_limes_3 = models.FloatField()
    
    participant_id = models.CharField(max_length=64)
    date_time_stamp = models.DateTimeField(auto_now_add=True)