## Guided Attention Multimodal Multitask Financial Forecasting with Inter-Company Relationships and Global and Local News

This repository contains a Pytorch implementation of the GAME model proposed in the paper Guided Attention Multimodal Multitask Financial Forecasting with Inter-Company Relationships and Global and Local News

### Overview:
The results in the paper were obtained by training on a Nvidia GeForce RTX 3090 GPU on a AMD Ryzen 7 Windows machine with 64GB of RAM. 
- Training time should be around 2 hours for the GAME model on the dataset (NY-IN) provided, depending on your system. 

### Requirements:

The key libraries required are Pytorch, Pytorch Lightning, Numpy, Pandas, Scipy

### Datasets

Data required (~250MB) should be downloaded, unzipped and the individual files placed in ``data`` folder. Data can be downloaded from this link anonymously - https://doi.org/10.5281/zenodo.5687052


### Repository Organization
- ``data/`` this should contain the pre-processed input datasets downloaded from the link - https://doi.org/10.5281/zenodo.5687052
- ``models.py`` contains the modules and model
- ``utils.py`` contains the dataset loading, metric and optimization functions
- ``train.ipynb`` is the notebook that can be used to run the model

### Running the code
- For ``train.iypnb``, you will simply need to step through the code in the notebook. Relevant details are provided in the notebook.

Please contact the authors should there be any issues.
