/*
 * Decompiled with CFR 0.152.
 */
package annotation_scorers;

import annotation_scorers.Judgement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import utils_bk.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Score
implements Cloneable {
    private String keyfile;
    private String annotfile;
    private HashMap<String, Integer> corr;
    private HashMap<String, Integer> inco;
    private HashMap<String, Integer> spur;
    private HashMap<String, Integer> miss;
    private HashMap<String, Integer> tp;
    private HashMap<String, Integer> tn;
    private HashMap<String, Integer> fp;
    private HashMap<String, Integer> fn;
    private HashMap<String, ArrayList<Judgement>> elem_judgements;
    private HashMap<String, Set<String>> elem_attribs;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Cloning not allowed.");
            return this;
        }
    }

    public Score(String k, String a) {
        this.keyfile = k;
        this.annotfile = a;
        this.corr = new HashMap();
        this.inco = new HashMap();
        this.spur = new HashMap();
        this.miss = new HashMap();
        this.elem_judgements = new HashMap();
        this.tp = new HashMap();
        this.tn = new HashMap();
        this.tn.put("default", 0);
        this.fp = new HashMap();
        this.fn = new HashMap();
    }

    public HashMap<String, ArrayList<Judgement>> getJudgements() {
        return this.elem_judgements;
    }

    public void add(Judgement judgement) {
        block9: {
            try {
                String element = judgement.getElement();
                if (!this.elem_judgements.containsKey(element)) {
                    this.elem_judgements.put(element, new ArrayList());
                    this.corr.put(element, 0);
                    this.inco.put(element, 0);
                    this.spur.put(element, 0);
                    this.miss.put(element, 0);
                }
                this.elem_judgements.get(element).add(judgement);
                switch (Judgement.judgements.valueOf(judgement.getJudgement_str())) {
                    case corr: {
                        this.corr.put(element, this.corr.get(element) + 1);
                        break;
                    }
                    case inco: {
                        this.inco.put(element, this.inco.get(element) + 1);
                        break;
                    }
                    case spur: {
                        this.spur.put(element, this.spur.get(element) + 1);
                        break;
                    }
                    case miss: {
                        this.miss.put(element, this.miss.get(element) + 1);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block9;
                e.printStackTrace(System.err);
            }
        }
    }

    public void merge(Score s) {
        block11: {
            try {
                this.keyfile = "Set of files";
                this.annotfile = "Set of files";
                HashMap<String, ArrayList<Judgement>> juds = s.getJudgements();
                for (String e : juds.keySet()) {
                    for (Judgement judgement : s.getElement(e)) {
                        String element = judgement.getElement();
                        if (!this.elem_judgements.containsKey(element)) {
                            ArrayList elemjudg = new ArrayList();
                            this.elem_judgements.put(element, elemjudg);
                            this.corr.put(element, 0);
                            this.inco.put(element, 0);
                            this.spur.put(element, 0);
                            this.miss.put(element, 0);
                        }
                        this.elem_judgements.get(element).add(judgement);
                        switch (Judgement.judgements.valueOf(judgement.getJudgement_str())) {
                            case corr: {
                                this.corr.put(element, this.corr.get(element) + 1);
                                break;
                            }
                            case inco: {
                                this.inco.put(element, this.inco.get(element) + 1);
                                break;
                            }
                            case spur: {
                                this.spur.put(element, this.spur.get(element) + 1);
                                break;
                            }
                            case miss: {
                                this.miss.put(element, this.miss.get(element) + 1);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block11;
                e.printStackTrace(System.err);
            }
        }
    }

    public ArrayList<Judgement> getElement(String element) {
        return this.elem_judgements.get(element);
    }

    public String getElementAttribsScore(String element) throws Exception {
        String ret = "";
        ArrayList<Judgement> judgs = this.elem_judgements.get(element);
        HashMap<String, Integer> at_corr = new HashMap<String, Integer>();
        HashMap<String, Integer> at_inco = new HashMap<String, Integer>();
        HashMap<String, Integer> class_value_corr = new HashMap<String, Integer>();
        HashMap<String, Integer> class_value_inco = new HashMap<String, Integer>();
        HashMap<String, Integer> class_value_miss = new HashMap<String, Integer>();
        for (Judgement judg : judgs) {
            if (judg.isAligned().booleanValue()) {
                for (String at_key : judg.get_alt_attribs_scores().keySet()) {
                    if (!at_corr.containsKey(at_key)) {
                        at_corr.put(at_key, 0);
                        at_inco.put(at_key, 0);
                    }
                    if (!class_value_corr.containsKey(judg.getAttrib(at_key))) {
                        class_value_corr.put(judg.getAttrib(at_key), 0);
                        class_value_inco.put(judg.getAttrib(at_key), 0);
                        class_value_miss.put(judg.getAttrib(at_key), 0);
                    }
                    switch (Judgement.judgements.values()[judg.get_alt_attrib_score(at_key)]) {
                        case corr: {
                            at_corr.put(at_key, (Integer)at_corr.get(at_key) + 1);
                            class_value_corr.put(judg.getAttrib(at_key), (Integer)class_value_corr.get(judg.getAttrib(at_key)) + 1);
                            break;
                        }
                        case inco: {
                            at_inco.put(at_key, (Integer)at_inco.get(at_key) + 1);
                            class_value_inco.put(judg.getAttrib(at_key), (Integer)class_value_inco.get(judg.getAttrib(at_key)) + 1);
                            ret = ret + "\t\t\t " + at_key + ": " + judg.getAttrib(at_key) + " classified as " + judg.get_alt_attrib(at_key) + " -- (line " + judg.getNumline() + ")\n";
                            break;
                        }
                        case spur: {
                            throw new Exception("Unexpected Spurious: " + judg.getKeylines());
                        }
                        case miss: {
                            throw new Exception("Unexpected Missing: " + judg.getKeylines());
                        }
                    }
                }
                continue;
            }
            if (!judg.getJudgement_str().equalsIgnoreCase("miss") || !judg.containsAttrib("class")) continue;
            if (!class_value_miss.containsKey(judg.getAttrib("class"))) {
                class_value_miss.put(judg.getAttrib("class"), 0);
            }
            class_value_miss.put(judg.getAttrib("class"), (Integer)class_value_miss.get(judg.getAttrib("class")) + 1);
        }
        for (String at_key : at_corr.keySet()) {
            double s = Score.doubleDivision(((Integer)at_corr.get(at_key)).intValue(), (Integer)at_corr.get(at_key) + (Integer)at_inco.get(at_key));
            ret = ret + "\n\t\t" + at_key + " s=" + Score.twoDecPos(s) + "    --    corr=" + at_corr.get(at_key) + " inco=" + at_inco.get(at_key) + "\n";
        }
        for (String class_value_key : class_value_inco.keySet()) {
            double s = Score.doubleDivision(((Integer)class_value_corr.get(class_value_key)).intValue(), (Integer)class_value_corr.get(class_value_key) + (Integer)class_value_inco.get(class_value_key));
            String nomval = class_value_key;
            if (nomval.length() > 4) {
                nomval = nomval.substring(0, 4);
            }
            ret = ret + "\t\t\t" + nomval + " s=" + Score.twoDecPos(s) + "    --    corr=" + class_value_corr.get(class_value_key) + " inco=" + class_value_inco.get(class_value_key) + " miss=" + class_value_miss.get(class_value_key) + "\n";
        }
        return ret;
    }

    public static double Precision(double corr, double act) {
        return Score.doubleDivision(corr, act) * 100.0;
    }

    public static double Recall(double corr, double pos) {
        return Score.doubleDivision(corr, pos) * 100.0;
    }

    public static double F1(double p, double r) {
        return Score.doubleDivision(2.0 * p * r, p + r);
    }

    public int getPOS() {
        int pos = 0;
        for (String e : this.corr.keySet()) {
            pos += this.getPOS(e);
        }
        return pos;
    }

    public int getPOS(String e) {
        return this.corr.get(e) + this.inco.get(e) + this.miss.get(e);
    }

    public int getACT() {
        int act = 0;
        for (String e : this.corr.keySet()) {
            act += this.getACT(e);
        }
        return act;
    }

    public int getACT(String e) {
        return this.corr.get(e) + this.inco.get(e) + this.spur.get(e);
    }

    public double getPrecision(String e) {
        return Score.Precision(this.corr.get(e).doubleValue(), this.getACT(e));
    }

    public double getRecall(String e) {
        return Score.Recall(this.corr.get(e).doubleValue(), this.getPOS(e));
    }

    public double getF1(String e) {
        double p = this.getPrecision(e);
        double r = this.getRecall(e);
        return Score.F1(p, r);
    }

    public double getPrecisionTokenLevel(String e) {
        return (double)this.tp.get(e).intValue() / (double)(this.tp.get(e) + this.fp.get(e));
    }

    public double getRecallTokenLevel(String e) {
        return (double)this.tp.get(e).intValue() / (double)(this.tp.get(e) + this.fn.get(e));
    }

    public double getF1TokenLevel(String e) {
        double p = this.getPrecisionTokenLevel(e);
        double r = this.getRecallTokenLevel(e);
        return Score.F1(p, r);
    }

    public double getAccuracyTokenLevel(String e) {
        return (double)(this.tp.get(e) + this.tn.get(e)) / (double)(this.tp.get(e) + this.tn.get(e) + this.fp.get(e) + this.fn.get(e));
    }

    public double getPrecisionRelaxed(String e) {
        return Score.Precision(this.corr.get(e).doubleValue() + this.inco.get(e).doubleValue(), this.getACT(e));
    }

    public double getRecallRelaxed(String e) {
        return Score.Recall(this.corr.get(e).doubleValue() + this.inco.get(e).doubleValue(), this.getPOS(e));
    }

    public double getF1Relaxed(String e) {
        double p = this.getPrecisionRelaxed(e);
        double r = this.getRecallRelaxed(e);
        return Score.F1(p, r);
    }

    public void print() throws Exception {
        this.print("simple");
    }

    public void print(String option) throws Exception {
        for (String e : this.elem_judgements.keySet()) {
            System.out.println("\t>" + e.toUpperCase() + "<  (POS=" + this.getPOS(e) + ",ACT=" + this.getACT(e) + "):\tPrecision=" + Score.oneDecPos(this.getPrecision(e)) + "%\tRecall=" + Score.oneDecPos(this.getRecall(e)) + "%\tF1=" + Score.oneDecPos(this.getF1(e)) + "%\t- corr=" + this.corr.get(e) + ";inco=" + this.inco.get(e) + ";spur=" + this.spur.get(e) + ";miss=" + this.miss.get(e) + ";");
            System.out.println("\t  TempEval2(token level score)\tPrecision=" + StringUtils.twoDecPosS((double)this.getPrecisionTokenLevel(e)) + "\tRecall=" + StringUtils.twoDecPosS((double)this.getRecallTokenLevel(e)) + "\tF1=" + StringUtils.twoDecPosS((double)this.getF1TokenLevel(e)) + "  \t- accuracy=" + Score.twoDecPos(this.getAccuracyTokenLevel(e)));
            if (option.contains("attribs")) {
                System.out.println(this.getElementAttribsScore(e));
            }
            if (!option.contains("detail")) continue;
            for (Judgement judgement : this.elem_judgements.get(e)) {
                if (judgement.getJudgement_str().equalsIgnoreCase("corr")) continue;
                System.out.println("\t\t" + judgement.getJudgement_str() + " numline:" + judgement.getNumline());
                if (judgement.getAttribs() != null && judgement.getAttribs().size() > 0) {
                    if (judgement.isAligned().booleanValue()) {
                        System.out.println("\t\t  keyattribs: " + judgement.getXMLattribs() + "   --   annotattribs: " + judgement.getXMLalt_attribs());
                    } else {
                        System.out.println("\t\t  attribs: " + judgement.getXMLattribs());
                    }
                }
                for (String line : judgement.getKeylines().split("\n")) {
                    System.out.println("\t\t\t KEY: " + line);
                }
                System.out.println("\t\t\t-");
                for (String line : judgement.getAnnotlines().split("\n")) {
                    System.out.println("\t\t\t ANNOT: " + line);
                }
                System.out.println();
                System.out.println();
            }
        }
    }

    public static double oneDecPos(double d) {
        return (double)((int)Math.round(d * 10.0)) / 10.0;
    }

    public static double twoDecPos(double d) {
        return (double)((int)Math.round(d * 100.0)) / 100.0;
    }

    public static double doubleDivision(double a, double b) {
        if (b == 0.0) {
            return 0.0;
        }
        return a / b;
    }

    public void addtn() {
        for (String e : this.tn.keySet()) {
            this.tn.put(e, this.tn.get(e) + 1);
        }
    }

    public void addtnrest(String ne) {
        for (String e : this.tn.keySet()) {
            if (ne.equals(e)) continue;
            this.tn.put(e, this.tn.get(e) + 1);
        }
    }

    public void addtp(String e) {
        if (!this.tn.containsKey(e)) {
            this.initialize_tokenlevel(e);
        }
        this.tp.put(e, this.tp.get(e) + 1);
    }

    public void addfp(String e) {
        if (!this.tn.containsKey(e)) {
            this.initialize_tokenlevel(e);
        }
        this.fp.put(e, this.fp.get(e) + 1);
    }

    public void addfn(String e) {
        if (!this.tn.containsKey(e)) {
            this.initialize_tokenlevel(e);
        }
        this.fn.put(e, this.fn.get(e) + 1);
    }

    public void initialize_tokenlevel(String e) {
        this.tn.put(e, this.tn.get("default"));
        this.tp.put(e, 0);
        this.fn.put(e, 0);
        this.fp.put(e, 0);
    }

    public void sort_judgements_by_numline() {
        for (String e : this.getJudgements().keySet()) {
            Collections.sort((List)this.getJudgements().get(e));
        }
    }
}

