if __name__ == "__main__":

	nickname = "cxg2"
	language = "eng"
	model = "eng.Grammar.v2.p"
	
	import os
	from c2xg.c2xg import c2xg
	from scipy.sparse import csr_matrix

	in_directory = os.path.join(".", "IN", language)
	out_directory = os.path.join(".")
	
	CxG = c2xg.C2xG(out_directory, language = "eng", model = model)

	for filename in os.listdir(in_directory):
		
		print("\tStarting " + str(filename))
		
		vectors = CxG.parse_return(filename, workers = 8)
		vectors = csr_matrix(vectors)
		CxG.Load.save_file(vectors, filename.replace(".txt", "") + "." + nickname + ".p")
	
	