/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.tregex.Macros;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.trees.tregex.tsurgeon.ParseException;
import edu.stanford.nlp.trees.tregex.tsurgeon.TokenMgrError;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonParseException;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonParser;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tsurgeon {
    private static final boolean DEBUG = false;
    static boolean verbose;
    private static final Pattern emptyLinePattern;
    private static final String commentIntroducingCharacter = "%";
    private static final Pattern commentPattern;
    private static final Pattern escapedCommentCharacterPattern;
    private static boolean matchedOnTree;

    private Tsurgeon() {
    }

    public static void main(String[] args) throws Exception {
        TregexPatternCompiler compiler;
        TreeReaderFactory trf;
        String headFinderClassName = null;
        String headFinderOption = "-hf";
        String[] headFinderArgs = null;
        String headFinderArgOption = "-hfArg";
        String encoding = "UTF-8";
        String encodingOption = "-encoding";
        if (args.length == 0) {
            System.err.println("Usage: java edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon [-s] -treeFile <file-with-trees> [-po <matching-pattern> <operation>] <operation-file-1> <operation-file-2> ... <operation-file-n>");
            System.exit(0);
        }
        String singleLineOption = "-s";
        String verboseOption = "-v";
        String matchedOption = "-m";
        String patternOperationOption = "-po";
        String treeFileOption = "-treeFile";
        String trfOption = "-trf";
        String macroOption = "-macros";
        String macroFilename = "";
        Map<String, Integer> flagMap = Generics.newHashMap();
        flagMap.put(patternOperationOption, 2);
        flagMap.put(treeFileOption, 1);
        flagMap.put(trfOption, 1);
        flagMap.put(singleLineOption, 0);
        flagMap.put(encodingOption, 1);
        flagMap.put(headFinderOption, 1);
        flagMap.put(macroOption, 1);
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, flagMap);
        args = argsMap.get(null);
        if (argsMap.containsKey(headFinderOption)) {
            headFinderClassName = argsMap.get(headFinderOption)[0];
        }
        if (argsMap.containsKey(headFinderArgOption)) {
            headFinderArgs = argsMap.get(headFinderArgOption);
        }
        if (argsMap.containsKey(verboseOption)) {
            verbose = true;
        }
        String treePrintFormats = argsMap.containsKey(singleLineOption) ? "oneline," : "penn,";
        if (argsMap.containsKey(encodingOption)) {
            encoding = argsMap.get(encodingOption)[0];
        }
        if (argsMap.containsKey(macroOption)) {
            macroFilename = argsMap.get(macroOption)[0];
        }
        TreePrint tp = new TreePrint(treePrintFormats, new PennTreebankLanguagePack());
        PrintWriter pwOut = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, encoding), true);
        if (argsMap.containsKey(trfOption)) {
            String trfClass = argsMap.get(trfOption)[0];
            trf = (TreeReaderFactory)ReflectionLoading.loadByReflection(trfClass, new Object[0]);
        } else {
            trf = new TregexPattern.TRegexTreeReaderFactory();
        }
        DiskTreebank trees = new DiskTreebank(trf, encoding);
        if (argsMap.containsKey(treeFileOption)) {
            trees.loadPath(argsMap.get(treeFileOption)[0]);
        }
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> ops = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
        if (headFinderClassName == null) {
            compiler = new TregexPatternCompiler();
        } else {
            HeadFinder hf = headFinderArgs == null ? (HeadFinder)ReflectionLoading.loadByReflection(headFinderClassName, new Object[0]) : (HeadFinder)ReflectionLoading.loadByReflection(headFinderClassName, headFinderArgs);
            compiler = new TregexPatternCompiler(hf);
        }
        Macros.addAllMacros(compiler, macroFilename, encoding);
        if (argsMap.containsKey(patternOperationOption)) {
            TregexPattern matchPattern = compiler.compile(argsMap.get(patternOperationOption)[0]);
            TsurgeonPattern p = Tsurgeon.parseOperation(argsMap.get(patternOperationOption)[1]);
            ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern, p));
        } else {
            for (String arg : args) {
                List<Pair<TregexPattern, TsurgeonPattern>> pairs = Tsurgeon.getOperationsFromFile(arg, encoding, compiler);
                for (Pair<TregexPattern, TsurgeonPattern> pair : pairs) {
                    if (verbose) {
                        System.err.println(pair.second());
                    }
                    ops.add(pair);
                }
            }
        }
        for (Tree t : trees) {
            Tree original = t.deepCopy();
            Tree result = Tsurgeon.processPatternsOnTree(ops, t);
            if (argsMap.containsKey(matchedOption) && matchedOnTree) {
                pwOut.println("Operated on: ");
                Tsurgeon.displayTree(original, tp, pwOut);
                pwOut.println("Result: ");
            }
            Tsurgeon.displayTree(result, tp, pwOut);
        }
    }

    private static void displayTree(Tree t, TreePrint tp, PrintWriter pw) {
        if (t == null) {
            pw.println("null");
        } else {
            tp.printTree(t, pw);
        }
    }

    public static Pair<TregexPattern, TsurgeonPattern> getOperationFromReader(BufferedReader reader, TregexPatternCompiler compiler) throws IOException {
        String patternString = Tsurgeon.getTregexPatternFromReader(reader);
        if ("".equals(patternString)) {
            return null;
        }
        TregexPattern matchPattern = compiler.compile(patternString);
        TsurgeonPattern collectedPattern = Tsurgeon.getTsurgeonOperationsFromReader(reader);
        return new Pair<TregexPattern, TsurgeonPattern>(matchPattern, collectedPattern);
    }

    public static String getTregexPatternFromReader(BufferedReader reader) throws IOException {
        String thisLine;
        StringBuilder matchString = new StringBuilder();
        while (!((thisLine = reader.readLine()) == null || matchString.length() > 0 && emptyLinePattern.matcher(thisLine).matches())) {
            Matcher m = commentPattern.matcher(thisLine);
            if (m.matches()) {
                thisLine = m.replaceFirst("");
            }
            if (emptyLinePattern.matcher(thisLine).matches()) continue;
            matchString.append(thisLine);
        }
        return matchString.toString();
    }

    public static TsurgeonPattern getTsurgeonOperationsFromReader(BufferedReader reader) throws IOException {
        String thisLine;
        ArrayList<TsurgeonPattern> operations = new ArrayList<TsurgeonPattern>();
        while ((thisLine = reader.readLine()) != null && !emptyLinePattern.matcher(thisLine).matches()) {
            if (emptyLinePattern.matcher(thisLine = Tsurgeon.removeComments(thisLine)).matches()) continue;
            operations.add(Tsurgeon.parseOperation(thisLine));
        }
        return Tsurgeon.collectOperations(operations);
    }

    private static String removeComments(String line) {
        Matcher m = commentPattern.matcher(line);
        line = m.replaceFirst("");
        Matcher m1 = escapedCommentCharacterPattern.matcher(line);
        line = m1.replaceAll(commentIntroducingCharacter);
        return line;
    }

    public static String getTsurgeonTextFromReader(BufferedReader reader) throws IOException {
        String thisLine;
        StringBuilder sb = new StringBuilder();
        while ((thisLine = reader.readLine()) != null) {
            if (emptyLinePattern.matcher(thisLine = Tsurgeon.removeComments(thisLine)).matches()) continue;
            sb.append(thisLine);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static List<Pair<TregexPattern, TsurgeonPattern>> getOperationsFromFile(String filename, String encoding, TregexPatternCompiler compiler) throws IOException {
        Pair<TregexPattern, TsurgeonPattern> operation;
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> operations = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
        while ((operation = Tsurgeon.getOperationFromReader(reader, compiler)) != null) {
            operations.add(operation);
        }
        reader.close();
        return operations;
    }

    public static List<Tree> processPatternOnTrees(TregexPattern matchPattern, TsurgeonPattern p, Collection<Tree> inputTrees) {
        ArrayList<Tree> result = new ArrayList<Tree>();
        for (Tree tree : inputTrees) {
            result.add(Tsurgeon.processPattern(matchPattern, p, tree));
        }
        return result;
    }

    public static Tree processPattern(TregexPattern matchPattern, TsurgeonPattern p, Tree t) {
        TregexMatcher m = matchPattern.matcher(t);
        while (m.find() && (t = p.evaluate(t, m)) != null) {
            m = matchPattern.matcher(t);
        }
        return t;
    }

    public static Tree processPatternsOnTree(List<Pair<TregexPattern, TsurgeonPattern>> ops, Tree t) {
        matchedOnTree = false;
        for (Pair<TregexPattern, TsurgeonPattern> op : ops) {
            try {
                TregexMatcher m = op.first().matcher(t);
                while (m.find()) {
                    matchedOnTree = true;
                    t = op.second().evaluate(t, m);
                    if (t == null) {
                        return null;
                    }
                    m = op.first().matcher(t);
                }
            }
            catch (NullPointerException npe) {
                throw new RuntimeException("Tsurgeon.processPatternsOnTree failed to match label for pattern: " + op.first() + ", " + op.second(), npe);
            }
        }
        return t;
    }

    public static TsurgeonPattern parseOperation(String operationString) {
        try {
            TsurgeonParser parser = new TsurgeonParser(new StringReader(operationString + "\n"));
            return new TsurgeonPatternRoot(new TsurgeonPattern[]{parser.Root()});
        }
        catch (ParseException e) {
            throw new TsurgeonParseException("Error parsing Tsurgeon expression: " + operationString, e);
        }
        catch (TokenMgrError e) {
            throw new TsurgeonParseException("Error parsing Tsurgeon expression: " + operationString, e);
        }
    }

    public static TsurgeonPattern collectOperations(List<TsurgeonPattern> patterns) {
        return new TsurgeonPatternRoot(patterns.toArray(new TsurgeonPattern[patterns.size()]));
    }

    static {
        emptyLinePattern = Pattern.compile("^\\s*$");
        commentPattern = Pattern.compile("(?<!\\\\)%.*$");
        escapedCommentCharacterPattern = Pattern.compile("\\\\%");
    }
}

