/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.ardverk.collection.AbstractTrie;
import org.ardverk.collection.Cursor;
import org.ardverk.collection.KeyAnalyzer;
import org.ardverk.collection.Tries;

abstract class AbstractPatriciaTrie<K, V>
extends AbstractTrie<K, V> {
    private static final long serialVersionUID = -2303909182832019043L;
    final TrieEntry<K, V> root = new TrieEntry<Object, Object>(null, null, -1);
    private volatile transient Set<K> keySet;
    private volatile transient Collection<V> values;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private int size = 0;
    transient int modCount = 0;

    public AbstractPatriciaTrie() {
    }

    public AbstractPatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer) {
        super(keyAnalyzer);
    }

    public AbstractPatriciaTrie(Map<? extends K, ? extends V> map) {
        this.putAll(map);
    }

    public AbstractPatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer, Map<? extends K, ? extends V> map) {
        super(keyAnalyzer);
        this.putAll(map);
    }

    @Override
    public void clear() {
        this.root.key = null;
        this.root.bitIndex = -1;
        this.root.value = null;
        this.root.parent = null;
        this.root.left = this.root;
        this.root.right = null;
        this.root.predecessor = this.root;
        this.size = 0;
        this.incrementModCount();
    }

    @Override
    public int size() {
        return this.size;
    }

    void incrementSize() {
        ++this.size;
        this.incrementModCount();
    }

    void decrementSize() {
        --this.size;
        this.incrementModCount();
    }

    private void incrementModCount() {
        ++this.modCount;
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            throw new NullPointerException("Key cannot be null");
        }
        int n = this.lengthInBits(k);
        if (n == 0) {
            if (this.root.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return this.root.setKeyValue(k, v);
        }
        TrieEntry<K, V> trieEntry = this.getNearestEntryForKey(k);
        if (this.compareKeys(k, trieEntry.key)) {
            if (trieEntry.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return trieEntry.setKeyValue(k, v);
        }
        int n2 = this.bitIndex(k, trieEntry.key);
        if (!Tries.isOutOfBoundsIndex(n2)) {
            if (Tries.isValidBitIndex(n2)) {
                TrieEntry<K, V> trieEntry2 = new TrieEntry<K, V>(k, v, n2);
                this.addEntry(trieEntry2);
                this.incrementSize();
                return null;
            }
            if (Tries.isNullBitKey(n2)) {
                if (this.root.isEmpty()) {
                    this.incrementSize();
                } else {
                    this.incrementModCount();
                }
                return this.root.setKeyValue(k, v);
            }
            if (Tries.isEqualBitKey(n2) && trieEntry != this.root) {
                this.incrementModCount();
                return trieEntry.setKeyValue(k, v);
            }
        }
        throw new IndexOutOfBoundsException("Failed to put: " + k + " -> " + v + ", " + n2);
    }

    TrieEntry<K, V> addEntry(TrieEntry<K, V> trieEntry) {
        TrieEntry trieEntry2 = this.root.left;
        TrieEntry<K, V> trieEntry3 = this.root;
        while (true) {
            if (trieEntry2.bitIndex >= trieEntry.bitIndex || trieEntry2.bitIndex <= trieEntry3.bitIndex) {
                trieEntry.predecessor = trieEntry;
                if (!this.isBitSet(trieEntry.key, trieEntry.bitIndex)) {
                    trieEntry.left = trieEntry;
                    trieEntry.right = trieEntry2;
                } else {
                    trieEntry.left = trieEntry2;
                    trieEntry.right = trieEntry;
                }
                trieEntry.parent = trieEntry3;
                if (trieEntry2.bitIndex >= trieEntry.bitIndex) {
                    trieEntry2.parent = trieEntry;
                }
                if (trieEntry2.bitIndex <= trieEntry3.bitIndex) {
                    trieEntry2.predecessor = trieEntry;
                }
                if (trieEntry3 == this.root || !this.isBitSet(trieEntry.key, trieEntry3.bitIndex)) {
                    trieEntry3.left = trieEntry;
                } else {
                    trieEntry3.right = trieEntry;
                }
                return trieEntry;
            }
            trieEntry3 = trieEntry2;
            if (!this.isBitSet(trieEntry.key, trieEntry2.bitIndex)) {
                trieEntry2 = trieEntry2.left;
                continue;
            }
            trieEntry2 = trieEntry2.right;
        }
    }

    @Override
    public V get(Object object) {
        TrieEntry<K, V> trieEntry = this.getEntry(object);
        return trieEntry != null ? (V)trieEntry.getValue() : null;
    }

    TrieEntry<K, V> getEntry(Object object) {
        Object k = Tries.cast(object);
        if (k == null) {
            return null;
        }
        TrieEntry trieEntry = this.getNearestEntryForKey(k);
        return !trieEntry.isEmpty() && this.compareKeys(k, trieEntry.key) ? trieEntry : null;
    }

    @Override
    public Map.Entry<K, V> select(K k) {
        Reference<Map.Entry<K, V>> reference = new Reference<Map.Entry<K, V>>();
        if (!this.selectR(this.root.left, -1, k, reference)) {
            return reference.get();
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> select(K k, Cursor<? super K, ? super V> cursor) {
        Reference<Map.Entry<K, V>> reference = new Reference<Map.Entry<K, V>>();
        this.selectR(this.root.left, -1, k, cursor, reference);
        return reference.get();
    }

    private boolean selectR(TrieEntry<K, V> trieEntry, int n, K k, Reference<Map.Entry<K, V>> reference) {
        if (trieEntry.bitIndex <= n) {
            if (!trieEntry.isEmpty()) {
                reference.set(trieEntry);
                return false;
            }
            return true;
        }
        if (!this.isBitSet(k, trieEntry.bitIndex)) {
            if (this.selectR(trieEntry.left, trieEntry.bitIndex, k, reference)) {
                return this.selectR(trieEntry.right, trieEntry.bitIndex, k, reference);
            }
        } else if (this.selectR(trieEntry.right, trieEntry.bitIndex, k, reference)) {
            return this.selectR(trieEntry.left, trieEntry.bitIndex, k, reference);
        }
        return false;
    }

    private boolean selectR(TrieEntry<K, V> trieEntry, int n, K k, Cursor<? super K, ? super V> cursor, Reference<Map.Entry<K, V>> reference) {
        if (trieEntry.bitIndex <= n) {
            if (!trieEntry.isEmpty()) {
                Cursor.Decision decision = cursor.select(trieEntry);
                switch (decision) {
                    case REMOVE: {
                        throw new UnsupportedOperationException("Cannot remove during select");
                    }
                    case EXIT: {
                        reference.set(trieEntry);
                        return false;
                    }
                    case REMOVE_AND_EXIT: {
                        TrieEntry trieEntry2 = new TrieEntry(trieEntry.getKey(), trieEntry.getValue(), -1);
                        reference.set(trieEntry2);
                        this.removeEntry(trieEntry);
                        return false;
                    }
                }
            }
            return true;
        }
        if (!this.isBitSet(k, trieEntry.bitIndex)) {
            if (this.selectR(trieEntry.left, trieEntry.bitIndex, k, cursor, reference)) {
                return this.selectR(trieEntry.right, trieEntry.bitIndex, k, cursor, reference);
            }
        } else if (this.selectR(trieEntry.right, trieEntry.bitIndex, k, cursor, reference)) {
            return this.selectR(trieEntry.left, trieEntry.bitIndex, k, cursor, reference);
        }
        return false;
    }

    @Override
    public Map.Entry<K, V> traverse(Cursor<? super K, ? super V> cursor) {
        TrieEntry<K, V> trieEntry = this.nextEntry(null);
        while (trieEntry != null) {
            TrieEntry<K, V> trieEntry2 = trieEntry;
            Cursor.Decision decision = cursor.select(trieEntry2);
            trieEntry = this.nextEntry(trieEntry2);
            switch (decision) {
                case EXIT: {
                    return trieEntry2;
                }
                case REMOVE: {
                    this.removeEntry(trieEntry2);
                    break;
                }
                case REMOVE_AND_EXIT: {
                    TrieEntry trieEntry3 = new TrieEntry(trieEntry2.getKey(), trieEntry2.getValue(), -1);
                    this.removeEntry(trieEntry2);
                    return trieEntry3;
                }
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        Object k = Tries.cast(object);
        TrieEntry trieEntry = this.getNearestEntryForKey(k);
        return !trieEntry.isEmpty() && this.compareKeys(k, trieEntry.key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        Object k = Tries.cast(object);
        TrieEntry trieEntry = this.root.left;
        TrieEntry<K, V> trieEntry2 = this.root;
        while (true) {
            if (trieEntry.bitIndex <= trieEntry2.bitIndex) {
                if (!trieEntry.isEmpty() && this.compareKeys(k, trieEntry.key)) {
                    return this.removeEntry(trieEntry);
                }
                return null;
            }
            trieEntry2 = trieEntry;
            if (!this.isBitSet(k, trieEntry.bitIndex)) {
                trieEntry = trieEntry.left;
                continue;
            }
            trieEntry = trieEntry.right;
        }
    }

    TrieEntry<K, V> getNearestEntryForKey(K k) {
        TrieEntry trieEntry = this.root.left;
        TrieEntry<K, V> trieEntry2 = this.root;
        while (trieEntry.bitIndex > trieEntry2.bitIndex) {
            trieEntry2 = trieEntry;
            if (!this.isBitSet(k, trieEntry.bitIndex)) {
                trieEntry = trieEntry.left;
                continue;
            }
            trieEntry = trieEntry.right;
        }
        return trieEntry;
    }

    V removeEntry(TrieEntry<K, V> trieEntry) {
        if (trieEntry != this.root) {
            if (trieEntry.isInternalNode()) {
                this.removeInternalEntry(trieEntry);
            } else {
                this.removeExternalEntry(trieEntry);
            }
        }
        this.decrementSize();
        return trieEntry.setKeyValue(null, null);
    }

    private void removeExternalEntry(TrieEntry<K, V> trieEntry) {
        TrieEntry trieEntry2;
        if (trieEntry == this.root) {
            throw new IllegalArgumentException("Cannot delete root Entry!");
        }
        if (!trieEntry.isExternalNode()) {
            throw new IllegalArgumentException(trieEntry + " is not an external Entry!");
        }
        TrieEntry trieEntry3 = trieEntry.parent;
        TrieEntry trieEntry4 = trieEntry2 = trieEntry.left == trieEntry ? trieEntry.right : trieEntry.left;
        if (trieEntry3.left == trieEntry) {
            trieEntry3.left = trieEntry2;
        } else {
            trieEntry3.right = trieEntry2;
        }
        if (trieEntry2.bitIndex > trieEntry3.bitIndex) {
            trieEntry2.parent = trieEntry3;
        } else {
            trieEntry2.predecessor = trieEntry3;
        }
    }

    private void removeInternalEntry(TrieEntry<K, V> trieEntry) {
        TrieEntry trieEntry2;
        if (trieEntry == this.root) {
            throw new IllegalArgumentException("Cannot delete root Entry!");
        }
        if (!trieEntry.isInternalNode()) {
            throw new IllegalArgumentException(trieEntry + " is not an internal Entry!");
        }
        TrieEntry trieEntry3 = trieEntry.predecessor;
        trieEntry3.bitIndex = trieEntry.bitIndex;
        TrieEntry trieEntry4 = trieEntry3.parent;
        TrieEntry trieEntry5 = trieEntry2 = trieEntry3.left == trieEntry ? trieEntry3.right : trieEntry3.left;
        if (trieEntry3.predecessor == trieEntry3 && trieEntry3.parent != trieEntry) {
            trieEntry3.predecessor = trieEntry3.parent;
        }
        if (trieEntry4.left == trieEntry3) {
            trieEntry4.left = trieEntry2;
        } else {
            trieEntry4.right = trieEntry2;
        }
        if (trieEntry2.bitIndex > trieEntry4.bitIndex) {
            trieEntry2.parent = trieEntry4;
        }
        if (trieEntry.left.parent == trieEntry) {
            trieEntry.left.parent = trieEntry3;
        }
        if (trieEntry.right.parent == trieEntry) {
            trieEntry.right.parent = trieEntry3;
        }
        if (trieEntry.parent.left == trieEntry) {
            trieEntry.parent.left = trieEntry3;
        } else {
            trieEntry.parent.right = trieEntry3;
        }
        trieEntry3.parent = trieEntry.parent;
        trieEntry3.left = trieEntry.left;
        trieEntry3.right = trieEntry.right;
        if (AbstractPatriciaTrie.isValidUplink(trieEntry3.left, trieEntry3)) {
            trieEntry3.left.predecessor = trieEntry3;
        }
        if (AbstractPatriciaTrie.isValidUplink(trieEntry3.right, trieEntry3)) {
            trieEntry3.right.predecessor = trieEntry3;
        }
    }

    TrieEntry<K, V> nextEntry(TrieEntry<K, V> trieEntry) {
        if (trieEntry == null) {
            return this.firstEntry();
        }
        return this.nextEntryImpl(trieEntry.predecessor, trieEntry, null);
    }

    TrieEntry<K, V> nextEntryImpl(TrieEntry<K, V> trieEntry, TrieEntry<K, V> trieEntry2, TrieEntry<K, V> trieEntry3) {
        TrieEntry<K, V> trieEntry4 = trieEntry;
        if (trieEntry2 == null || trieEntry != trieEntry2.predecessor) {
            while (!trieEntry4.left.isEmpty() && trieEntry2 != trieEntry4.left) {
                if (AbstractPatriciaTrie.isValidUplink(trieEntry4.left, trieEntry4)) {
                    return trieEntry4.left;
                }
                trieEntry4 = trieEntry4.left;
            }
        }
        if (trieEntry4.isEmpty()) {
            return null;
        }
        if (trieEntry4.right == null) {
            return null;
        }
        if (trieEntry2 != trieEntry4.right) {
            if (AbstractPatriciaTrie.isValidUplink(trieEntry4.right, trieEntry4)) {
                return trieEntry4.right;
            }
            return this.nextEntryImpl(trieEntry4.right, trieEntry2, trieEntry3);
        }
        while (trieEntry4 == trieEntry4.parent.right) {
            if (trieEntry4 == trieEntry3) {
                return null;
            }
            trieEntry4 = trieEntry4.parent;
        }
        if (trieEntry4 == trieEntry3) {
            return null;
        }
        if (trieEntry4.parent.right == null) {
            return null;
        }
        if (trieEntry2 != trieEntry4.parent.right && AbstractPatriciaTrie.isValidUplink(trieEntry4.parent.right, trieEntry4.parent)) {
            return trieEntry4.parent.right;
        }
        if (trieEntry4.parent.right == trieEntry4.parent) {
            return null;
        }
        return this.nextEntryImpl(trieEntry4.parent.right, trieEntry2, trieEntry3);
    }

    @Override
    TrieEntry<K, V> firstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.followLeft(this.root);
    }

    TrieEntry<K, V> followLeft(TrieEntry<K, V> trieEntry) {
        while (true) {
            TrieEntry trieEntry2;
            if ((trieEntry2 = trieEntry.left).isEmpty()) {
                trieEntry2 = trieEntry.right;
            }
            if (trieEntry2.bitIndex <= trieEntry.bitIndex) {
                return trieEntry2;
            }
            trieEntry = trieEntry2;
        }
    }

    static boolean isValidUplink(TrieEntry<?, ?> trieEntry, TrieEntry<?, ?> trieEntry2) {
        return trieEntry != null && trieEntry.bitIndex <= trieEntry2.bitIndex && !trieEntry.isEmpty();
    }

    abstract class TrieIterator<E>
    implements Iterator<E> {
        protected int expectedModCount;
        protected TrieEntry<K, V> next;
        protected TrieEntry<K, V> current;

        protected TrieIterator() {
            this.expectedModCount = AbstractPatriciaTrie.this.modCount;
            this.next = AbstractPatriciaTrie.this.nextEntry(null);
        }

        protected TrieIterator(TrieEntry<K, V> trieEntry) {
            this.expectedModCount = AbstractPatriciaTrie.this.modCount;
            this.next = trieEntry;
        }

        protected TrieEntry<K, V> nextEntry() {
            if (this.expectedModCount != AbstractPatriciaTrie.this.modCount) {
                throw new ConcurrentModificationException();
            }
            TrieEntry trieEntry = this.next;
            if (trieEntry == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext(trieEntry);
            this.current = trieEntry;
            return trieEntry;
        }

        protected TrieEntry<K, V> findNext(TrieEntry<K, V> trieEntry) {
            return AbstractPatriciaTrie.this.nextEntry(trieEntry);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (this.expectedModCount != AbstractPatriciaTrie.this.modCount) {
                throw new ConcurrentModificationException();
            }
            TrieEntry trieEntry = this.current;
            this.current = null;
            AbstractPatriciaTrie.this.removeEntry(trieEntry);
            this.expectedModCount = AbstractPatriciaTrie.this.modCount;
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return AbstractPatriciaTrie.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return AbstractPatriciaTrie.this.containsValue(object);
        }

        @Override
        public void clear() {
            AbstractPatriciaTrie.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (!Tries.areEqual(v, object)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        private class ValueIterator
        extends TrieIterator<V> {
            private ValueIterator() {
            }

            @Override
            public V next() {
                return this.nextEntry().getValue();
            }
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return AbstractPatriciaTrie.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return AbstractPatriciaTrie.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            int n = this.size();
            AbstractPatriciaTrie.this.remove(object);
            return n != this.size();
        }

        @Override
        public void clear() {
            AbstractPatriciaTrie.this.clear();
        }

        private class KeyIterator
        extends TrieIterator<K> {
            private KeyIterator() {
            }

            @Override
            public K next() {
                return this.nextEntry().getKey();
            }
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            TrieEntry trieEntry = AbstractPatriciaTrie.this.getEntry(((Map.Entry)object).getKey());
            return trieEntry != null && trieEntry.equals(object);
        }

        @Override
        public boolean remove(Object object) {
            int n = this.size();
            AbstractPatriciaTrie.this.remove(object);
            return n != this.size();
        }

        @Override
        public int size() {
            return AbstractPatriciaTrie.this.size();
        }

        @Override
        public void clear() {
            AbstractPatriciaTrie.this.clear();
        }

        private class EntryIterator
        extends TrieIterator<Map.Entry<K, V>> {
            private EntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }
        }
    }

    static class TrieEntry<K, V>
    extends AbstractTrie.BasicEntry<K, V> {
        private static final long serialVersionUID = 4596023148184140013L;
        protected int bitIndex;
        protected TrieEntry<K, V> parent;
        protected TrieEntry<K, V> left;
        protected TrieEntry<K, V> right;
        protected TrieEntry<K, V> predecessor;

        public TrieEntry(K k, V v, int n) {
            super(k, v);
            this.bitIndex = n;
            this.parent = null;
            this.left = this;
            this.right = null;
            this.predecessor = this;
        }

        public boolean isEmpty() {
            return this.key == null;
        }

        public boolean isInternalNode() {
            return this.left != this && this.right != this;
        }

        public boolean isExternalNode() {
            return !this.isInternalNode();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.bitIndex == -1) {
                stringBuilder.append("RootEntry(");
            } else {
                stringBuilder.append("Entry(");
            }
            stringBuilder.append("key=").append(this.getKey()).append(" [").append(this.bitIndex).append("], ");
            stringBuilder.append("value=").append(this.getValue()).append(", ");
            if (this.parent != null) {
                if (this.parent.bitIndex == -1) {
                    stringBuilder.append("parent=").append("ROOT");
                } else {
                    stringBuilder.append("parent=").append(this.parent.getKey()).append(" [").append(this.parent.bitIndex).append("]");
                }
            } else {
                stringBuilder.append("parent=").append("null");
            }
            stringBuilder.append(", ");
            if (this.left != null) {
                if (this.left.bitIndex == -1) {
                    stringBuilder.append("left=").append("ROOT");
                } else {
                    stringBuilder.append("left=").append(this.left.getKey()).append(" [").append(this.left.bitIndex).append("]");
                }
            } else {
                stringBuilder.append("left=").append("null");
            }
            stringBuilder.append(", ");
            if (this.right != null) {
                if (this.right.bitIndex == -1) {
                    stringBuilder.append("right=").append("ROOT");
                } else {
                    stringBuilder.append("right=").append(this.right.getKey()).append(" [").append(this.right.bitIndex).append("]");
                }
            } else {
                stringBuilder.append("right=").append("null");
            }
            stringBuilder.append(", ");
            if (this.predecessor != null) {
                if (this.predecessor.bitIndex == -1) {
                    stringBuilder.append("predecessor=").append("ROOT");
                } else {
                    stringBuilder.append("predecessor=").append(this.predecessor.getKey()).append(" [").append(this.predecessor.bitIndex).append("]");
                }
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class Reference<E> {
        private E item;

        private Reference() {
        }

        public void set(E e) {
            this.item = e;
        }

        public E get() {
            return this.item;
        }
    }
}

