#include "w2v.ih"

void w2v::loadTxt(string const &path)
{
    ifstream ifs(path);
    if (!ifs.good())
    {
        cerr << "Could not read w2v model: " << path << '\n';
        exit(1);
    }

    ifs >> d_numCands;
    ifs >> d_numWords; 
    
    d_cands = vector<uint32_t>(d_numCands * d_numWords);
    d_vals = vector<double>(d_numCands * d_numWords);
    
    vector<string> idToWord = vector<string>(d_numWords);
    string word;
    uint32_t id;
    double dist;
    for (size_t beg = 0; beg != d_numWords; ++beg)
    {
        ifs >> id >> word;
        idToWord[id] = word;
        d_vocab.addWord(word);
    }
    d_vocab.optimize();
    for (size_t beg = 0; beg != d_numWords; ++beg)
    {
        if (beg % 10000 == 0)
            cout << beg << "\\" << d_numWords << '\n';
        ifs >> id;
        size_t newId = d_vocab.getId(idToWord[id]);
        for (size_t candIdx = 0; candIdx != d_numCands; ++candIdx)
        {
            ifs >> id >> dist;
            d_cands[newId * d_numCands + candIdx] = d_vocab.getId(idToWord[id]);
            d_vals[newId * d_numCands + candIdx] = dist;
        }
    } 
}
