/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.syntax.Index;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class TSNodeLabel {
    public String label;
    public String[] la;
    public TSNodeLabel parent;
    public boolean isLexical = false;
    public TSNodeLabel[] daughters;

    public TSNodeLabel(String PennTree) {
        PennTree = PennTree.replaceAll("[\n\t\\ ]+", " ");
        PennTree = PennTree.trim();
        if (PennTree.matches("^\\( *\\)$") || PennTree.equals("")) {
            this.label = null;
            this.parent = null;
            this.daughters = null;
            return;
        }
        PennTree = PennTree.substring(PennTree.indexOf(40) + 1, PennTree.lastIndexOf(41)).trim();
        String tag = PennTree.substring(PennTree.indexOf(40) + 1, PennTree.indexOf(32));
        String[] tags = tag.split("__");
        this.label = tags[0];
        if (tags.length > 1) {
            this.la = new String[tags.length - 1];
            int i = 1;
            while (i < tags.length) {
                this.la[i - 1] = tags[i];
                ++i;
            }
        }
        this.parent = null;
        this.isLexical = false;
        ArrayList<TSNodeLabel> L = new ArrayList<TSNodeLabel>();
        Index currentPos = new Index(this.findNearestNonSpace(PennTree, PennTree.indexOf(32)));
        while (currentPos.value < PennTree.length()) {
            if (PennTree.charAt(currentPos.value) == ')') break;
            if (PennTree.charAt(currentPos.value) != ' ') {
                TSNodeLabel temp = new TSNodeLabel(PennTree, currentPos);
                temp.parent = this;
                L.add(temp);
                continue;
            }
            ++currentPos.value;
        }
        if (L.isEmpty()) {
            this.daughters = null;
        } else {
            int len = L.size();
            this.daughters = new TSNodeLabel[len];
            L.toArray(this.daughters);
        }
    }

    public TSNodeLabel(String PennTree, Index currentPos) {
        int i;
        int startpt = 0;
        int endpt = 0;
        currentPos.value = this.findNearestNonSpace(PennTree, currentPos.value);
        if (PennTree.charAt(currentPos.value) == '(') {
            startpt = currentPos.value + 1;
            i = currentPos.value;
            while (i < PennTree.length()) {
                if (PennTree.charAt(i) == ' ' && i > startpt) {
                    endpt = i;
                    break;
                }
                ++i;
            }
        } else {
            this.isLexical = true;
            startpt = currentPos.value;
            i = currentPos.value;
            while (i < PennTree.length()) {
                if ((PennTree.charAt(i) == '(' || PennTree.charAt(i) == ')') && i > startpt) {
                    endpt = i;
                    break;
                }
                ++i;
            }
        }
        String tag = PennTree.substring(startpt, endpt);
        String[] tags = tag.split("__");
        this.label = tags[0];
        if (tags.length > 1) {
            this.la = new String[tags.length - 1];
            int i2 = 1;
            while (i2 < tags.length) {
                this.la[i2 - 1] = tags[i2];
                ++i2;
            }
        }
        ArrayList<TSNodeLabel> L = new ArrayList<TSNodeLabel>();
        currentPos.value = this.findNearestNonSpace(PennTree, endpt);
        while (currentPos.value < PennTree.length() && !this.isLexical) {
            TSNodeLabel temp;
            if (PennTree.charAt(currentPos.value) == '(') {
                this.isLexical = false;
                temp = new TSNodeLabel(PennTree, currentPos);
                temp.parent = this;
                L.add(temp);
                continue;
            }
            if (PennTree.charAt(currentPos.value) == ')') {
                if (this.isLexical) break;
                ++currentPos.value;
                currentPos.value = this.findNearestNonSpace(PennTree, currentPos.value);
                break;
            }
            this.isLexical = false;
            temp = new TSNodeLabel(PennTree, currentPos);
            temp.parent = this;
            L.add(temp);
        }
        if (L.isEmpty()) {
            this.daughters = null;
        } else {
            int len = L.size();
            this.daughters = new TSNodeLabel[len];
            L.toArray(this.daughters);
        }
    }

    private int findNearestNonSpace(String PennTree, int pos) {
        while (PennTree.charAt(pos) == ' ' && pos < PennTree.length()) {
            ++pos;
        }
        return pos;
    }

    public int countAllNodes() {
        int result = 1;
        if (this.isTerminal()) {
            return result;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            result += TN.countAllNodes();
            ++n2;
        }
        return result;
    }

    public int countLexicalNodes() {
        if (this.isLexical) {
            return 1;
        }
        if (this.isTerminal()) {
            return 0;
        }
        int result = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            result += TN.countLexicalNodes();
            ++n2;
        }
        return result;
    }

    public boolean isTerminal() {
        return this.daughters == null;
    }

    public ArrayList<TSNodeLabel> collectLexicalItems() {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        this.collectLexicalItems(result);
        return result;
    }

    private void collectLexicalItems(List<TSNodeLabel> lexItems) {
        if (this.isTerminal()) {
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            if (TN.isLexical) {
                lexItems.add(TN);
            } else {
                TN.collectLexicalItems(lexItems);
            }
            ++n2;
        }
    }

    public ArrayList<TSNodeLabel> collectAllNodes() {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        this.collectAllNodes(result);
        return result;
    }

    private void collectAllNodes(List<TSNodeLabel> allNodes) {
        allNodes.add(this);
        if (this.isTerminal()) {
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            TN.collectAllNodes(allNodes);
            ++n2;
        }
    }

    public int maxDepth() {
        if (this.isTerminal()) {
            return 0;
        }
        int maxDepth = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel t = tSNodeLabelArray[n2];
            int tDepth = t.maxDepth();
            if (tDepth > maxDepth) {
                maxDepth = tDepth;
            }
            ++n2;
        }
        return maxDepth + 1;
    }

    public String label() {
        return this.label;
    }

    public int prole() {
        if (this.daughters == null) {
            return 0;
        }
        return this.daughters.length;
    }

    public int level() {
        int height = 0;
        TSNodeLabel TN = this;
        while (TN.parent != null) {
            TN = TN.parent;
            ++height;
        }
        return height;
    }

    public boolean isUniqueDaughter() {
        TSNodeLabel parent = this.parent;
        if (parent == null) {
            return false;
        }
        return this.parent.daughters.length == 1;
    }

    public static void main(String[] args) {
        String tStr = "( (S (NP-SBJ (NP (NNP Pierre) (NNP Vinken) ) (, ,) (ADJP (NP (CD 61) (NNS years) ) (JJ old) ) (, ,) ) (VP (MD will) (VP (VB join) (NP (DT the) (NN board) ) (PP-CLR (IN as) (NP (DT a) (JJ nonexecutive) (NN director) )) (NP-TMP (NNP Nov.) (CD 29) ))) (. .) ))";
        TSNodeLabel t = new TSNodeLabel(tStr);
    }
}

