/*
 	APS - Affinity Propagation for Segmentation, a linear text segmenter.
 
    Copyright (C) 2011, Anna Kazantseva

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */


package commandln;

public class IfGroup extends ParamGroup
{
	boolean mActivated = false;
	protected IParam mConditionParam;
	
	public IfGroup(String conditionParamName, IParam [] params)
	{
		super(params);
		mConditionParam = new NoValueParam(conditionParamName);
	}

	@Override
	public boolean CompareName(String name)
	{
		if (mConditionParam.CompareName(name))
		{
			mActivated = true;
			mCurrentParam = mConditionParam;
			return true;
		}

		if (!mActivated)
			return false;
		else
			return super.CompareName(name);
	}

	@Override
	public void MarkAsFound() throws Exception
	{
		if (mCurrentParam != null)
			mCurrentParam.MarkAsFound();
		else
			throw new Exception();
	}
	
	@Override
	public boolean ValueRequired() throws Exception
	{
		if (mCurrentParam != null)
			return mCurrentParam.ValueRequired();
		else
			throw new Exception();
	}
	
	@Override
	public boolean IsMandatory()
	{
		if (!mActivated)
			return mConditionParam.IsMandatory();
		else
			return super.IsMandatory();
	}
	
	@Override
	public boolean IsFound()
	{
		if (!mConditionParam.IsFound())
			return mConditionParam.IsMandatory();
		else
			return super.IsFound();
	}
}