/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.ConditionalClassification;
import com.aliasi.classify.ConditionalClassifier;
import com.aliasi.classify.ScoredClassifierEvaluator;
import com.aliasi.classify.ScoredPrecisionRecallEvaluation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalClassifierEvaluator<E>
extends ScoredClassifierEvaluator<E> {
    private final List<ScoredClassifierEvaluator.ScoreOutcome>[] mConditionalOutcomeLists;
    boolean mDefectiveConditioning = false;

    public ConditionalClassifierEvaluator(ConditionalClassifier<E> classifier, String[] categories, boolean storeInputs) {
        super(classifier, categories, storeInputs);
        ArrayList[] conditionalOutcomeLists = new ArrayList[this.numCategories()];
        this.mConditionalOutcomeLists = conditionalOutcomeLists;
        for (int i = 0; i < this.mConditionalOutcomeLists.length; ++i) {
            this.mConditionalOutcomeLists[i] = new ArrayList<ScoredClassifierEvaluator.ScoreOutcome>();
        }
    }

    @Override
    public void setClassifier(ConditionalClassifier<E> classifier) {
        this.setClassifier(classifier, ConditionalClassifierEvaluator.class);
    }

    @Override
    public ConditionalClassifier<E> classifier() {
        ConditionalClassifier result = (ConditionalClassifier)super.classifier();
        return result;
    }

    @Override
    public void handle(Classified<E> classified) {
        E input = classified.getObject();
        Classification refClassification = classified.getClassification();
        String refCategory = refClassification.bestCategory();
        this.validateCategory(refCategory);
        ConditionalClassification classification = this.classifier().classify(input);
        this.addClassification(refCategory, classification, input);
        this.addRanking(refCategory, classification);
        this.addScoring(refCategory, classification);
        this.addConditioning(refCategory, classification);
    }

    public double averageConditionalProbability(String refCategory, String responseCategory) {
        this.validateCategory(refCategory);
        this.validateCategory(responseCategory);
        double sum = 0.0;
        int count = 0;
        block0: for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            if (!((String)this.mReferenceCategories.get(i)).equals(refCategory)) continue;
            ConditionalClassification c = (ConditionalClassification)this.mClassifications.get(i);
            for (int rank = 0; rank < c.size(); ++rank) {
                if (!c.category(rank).equals(responseCategory)) continue;
                sum += c.conditionalProbability(rank);
                ++count;
                continue block0;
            }
        }
        return sum / (double)count;
    }

    public double averageConditionalProbabilityReference() {
        double sum = 0.0;
        block0: for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            String refCategory = ((String)this.mReferenceCategories.get(i)).toString();
            ConditionalClassification c = (ConditionalClassification)this.mClassifications.get(i);
            for (int rank = 0; rank < c.size(); ++rank) {
                if (!c.category(rank).equals(refCategory)) continue;
                sum += c.conditionalProbability(rank);
                continue block0;
            }
        }
        return sum / (double)this.mReferenceCategories.size();
    }

    public ScoredPrecisionRecallEvaluation conditionalOneVersusAll(String refCategory) {
        this.validateCategory(refCategory);
        return this.scoredOneVersusAll(this.mConditionalOutcomeLists, this.categoryToIndex(refCategory));
    }

    void addConditioning(String refCategory, ConditionalClassification scoring) {
        if (scoring.size() < this.numCategories()) {
            this.mDefectiveConditioning = true;
        }
        for (int rank = 0; rank < this.numCategories() && rank < scoring.size(); ++rank) {
            double score = scoring.conditionalProbability(rank);
            String category = scoring.category(rank);
            int categoryIndex = this.categoryToIndex(category);
            boolean match = category.equals(refCategory);
            ScoredClassifierEvaluator.ScoreOutcome outcome = new ScoredClassifierEvaluator.ScoreOutcome(score, match, rank == 0);
            this.mConditionalOutcomeLists[categoryIndex].add(outcome);
        }
    }

    @Override
    void baseToString(StringBuilder sb) {
        super.baseToString(sb);
        sb.append("Average Conditional Probability Reference=" + this.averageConditionalProbabilityReference() + "\n");
    }

    @Override
    void oneVsAllToString(StringBuilder sb, String category, int i) {
        super.oneVsAllToString(sb, category, i);
        sb.append("Conditional One Versus All\n");
        sb.append(this.conditionalOneVersusAll(category).toString() + "\n");
        sb.append("Average Conditional Probability Histogram=\n");
        this.appendCategoryLine(sb);
        for (int j = 0; j < this.numCategories(); ++j) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append(this.averageConditionalProbability(category, this.categories()[j]));
        }
        sb.append("\n");
    }
}

