/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.NGramTokenizer;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class NGramTokenizerFactory
implements TokenizerFactory,
Serializable,
Compilable {
    static final long serialVersionUID = -3208689473309929010L;
    private final int mMinNGram;
    private final int mMaxNGram;

    public NGramTokenizerFactory(int minNGram, int maxNGram) {
        if (maxNGram < 1) {
            String msg = "Require max >= 1. Found maxNGram=" + maxNGram;
            throw new IllegalArgumentException(msg);
        }
        if (minNGram > maxNGram) {
            String msg = "Require min <= max. Found min=" + minNGram + " max=" + maxNGram;
            throw new IllegalArgumentException(msg);
        }
        this.mMinNGram = minNGram;
        this.mMaxNGram = maxNGram;
    }

    @Deprecated
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    public int minNGram() {
        return this.mMinNGram;
    }

    public int maxNGram() {
        return this.mMaxNGram;
    }

    public Tokenizer tokenizer(char[] cs, int start, int length) {
        return new NGramTokenizer(cs, start, length, this.mMinNGram, this.mMaxNGram);
    }

    public String toString() {
        return "com.aliasi.tokenizer.NGramTokenizerFactory( min=" + this.mMinNGram + ", max=" + this.mMaxNGram + ")";
    }

    Object writeReplace() {
        return new Externalizer(this);
    }

    private static class Externalizer
    extends AbstractExternalizable {
        static final long serialVersionUID = 7342984199917470310L;
        final NGramTokenizerFactory mFactory;

        public Externalizer() {
            this(null);
        }

        public Externalizer(NGramTokenizerFactory factory) {
            this.mFactory = factory;
        }

        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeInt(this.mFactory.mMinNGram);
            objOut.writeInt(this.mFactory.mMaxNGram);
        }

        public Object read(ObjectInput objIn) throws IOException {
            int minNGram = objIn.readInt();
            int maxNGram = objIn.readInt();
            return new NGramTokenizerFactory(minNGram, maxNGram);
        }
    }
}

