/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.io;

import com.aliasi.io.LogLevel;
import com.aliasi.io.Reporter;
import com.aliasi.util.Strings;
import java.io.PrintWriter;
import java.util.IllegalFormatException;

class PrintWriterReporter
extends Reporter {
    private long mStartTime;
    private final PrintWriter mWriter;
    private LogLevel mLevel;

    public PrintWriterReporter(PrintWriter writer) {
        this.mWriter = writer;
        this.mStartTime = System.nanoTime();
    }

    public synchronized void report(LogLevel level, String msg) {
        if (!this.isEnabled(level)) {
            return;
        }
        if (this.mWriter == null) {
            return;
        }
        this.printTimeStamp();
        this.mWriter.println(msg);
        this.mWriter.flush();
    }

    public synchronized void reportf(LogLevel level, String format, Object ... args) {
        if (!this.isEnabled(level)) {
            return;
        }
        if (this.mWriter == null) {
            return;
        }
        this.printTimeStamp();
        try {
            this.mWriter.printf(format, args);
        }
        catch (IllegalFormatException e) {
            this.report(LogLevel.WARN, "Illegal format in printf");
            if (format != null) {
                this.mWriter.print("format=" + format);
            }
            for (int i = 0; i < args.length; ++i) {
                this.mWriter.print("; arg[" + i + "]=" + args[i]);
            }
            this.mWriter.println();
        }
        this.mWriter.flush();
    }

    public synchronized void close() {
        if (this.mWriter != null) {
            this.mWriter.close();
        }
    }

    void printTimeStamp() {
        this.mWriter.printf("%9s ", this.elapsedTime());
    }

    long elapsedTimeNano() {
        return System.nanoTime() - this.mStartTime;
    }

    String elapsedTime() {
        return Strings.nsToString(this.elapsedTimeNano());
    }
}

