from tqdm import tqdm
from datetime import datetime
import openai
from time import sleep
from utils import extract_answer,extract_code
import json
import argparse
import func_timeout
parser = argparse.ArgumentParser()
parser.add_argument("--start", default=0, type=int)
parser.add_argument("--end", default=-1, type=int)
parser.add_argument("--answered", default=None, type=str)
parser.add_argument("--dry_run", default=False, action='store_true')

args = parser.parse_args()

def create_reader_request(question):
    prompt_pot=f'''
Q: Olivia has $23. She bought five bagels for $3 each. How much money does she have left?

# solution in Python:


def solution():
    """Olivia has $23. She bought five bagels for $3 each. How much money does she have left?"""
    money_initial = 23
    bagels = 5
    bagel_cost = 3
    money_spent = bagels * bagel_cost
    money_left = money_initial - money_spent
    result = money_left
    return result





Q: Michael had 58 golf balls. On tuesday, he lost 23 golf balls. On wednesday, he lost 2 more. How many golf balls did he have at the end of wednesday?

# solution in Python:


def solution():
    """Michael had 58 golf balls. On tuesday, he lost 23 golf balls. On wednesday, he lost 2 more. How many golf balls did he have at the end of wednesday?"""
    golf_balls_initial = 58
    golf_balls_lost_tuesday = 23
    golf_balls_lost_wednesday = 2
    golf_balls_left = golf_balls_initial - golf_balls_lost_tuesday - golf_balls_lost_wednesday
    result = golf_balls_left
    return result





Q: There were nine computers in the server room. Five more computers were installed each day, from monday to thursday. How many computers are now in the server room?

# solution in Python:


def solution():
    """There were nine computers in the server room. Five more computers were installed each day, from monday to thursday. How many computers are now in the server room?"""
    computers_initial = 9
    computers_per_day = 5
    num_days = 4  # 4 days between monday and thursday
    computers_added = computers_per_day * num_days
    computers_total = computers_initial + computers_added
    result = computers_total
    return result





Q: Shawn has five toys. For Christmas, he got two toys each from his mom and dad. How many toys does he have now?

# solution in Python:


def solution():
    """Shawn has five toys. For Christmas, he got two toys each from his mom and dad. How many toys does he have now?"""
    toys_initial = 5
    mom_toys = 2
    dad_toys = 2
    total_received = mom_toys + dad_toys
    total_toys = toys_initial + total_received
    result = total_toys
    return result





Q: Jason had 20 lollipops. He gave Denny some lollipops. Now Jason has 12 lollipops. How many lollipops did Jason give to Denny?

# solution in Python:


def solution():
    """Jason had 20 lollipops. He gave Denny some lollipops. Now Jason has 12 lollipops. How many lollipops did Jason give to Denny?"""
    jason_lollipops_initial = 20
    jason_lollipops_after = 12
    denny_lollipops = jason_lollipops_initial - jason_lollipops_after
    result = denny_lollipops
    return result





Q: Leah had 32 chocolates and her sister had 42. If they ate 35, how many pieces do they have left in total?

# solution in Python:


def solution():
    """Leah had 32 chocolates and her sister had 42. If they ate 35, how many pieces do they have left in total?"""
    leah_chocolates = 32
    sister_chocolates = 42
    total_chocolates = leah_chocolates + sister_chocolates
    chocolates_eaten = 35
    chocolates_left = total_chocolates - chocolates_eaten
    result = chocolates_left
    return result





Q: If there are 3 cars in the parking lot and 2 more cars arrive, how many cars are in the parking lot?

# solution in Python:


def solution():
    """If there are 3 cars in the parking lot and 2 more cars arrive, how many cars are in the parking lot?"""
    cars_initial = 3
    cars_arrived = 2
    total_cars = cars_initial + cars_arrived
    result = total_cars
    return result





Q: There are 15 trees in the grove. Grove workers will plant trees in the grove today. After they are done, there will be 21 trees. How many trees did the grove workers plant today?

# solution in Python:


def solution():
    """There are 15 trees in the grove. Grove workers will plant trees in the grove today. After they are done, there will be 21 trees. How many trees did the grove workers plant today?"""
    trees_initial = 15
    trees_after = 21
    trees_added = trees_after - trees_initial
    result = trees_added
    return result

    



Q: Tom's mother is twice as old as him. And the sum of their ages was 43 ten years ago. How old is Tom now?

# solution in Python:


def solution():
    """Tom's mother is twice as old as him. And the sum of their ages was 43 ten years ago. How old is Tom now?"""
    sum_of_ages_ten_years_ago = 43
    increase_of_sum_of_ages = 10 * 2
    sum_of_ages_now = sum_of_ages_ten_years_ago + increase_of_sum_of_ages
    age_of_tom = sum_of_ages_now / (2 + 1)
    result = age_of_tom
    return result




  
Q: {question}

# solution in Python:
'''.strip() + '\n\n\n'
    string = prompt_pot
    return string

def run_pot_prompt(full_prompt: str):

    SYSTEMQ="""You will write python program to solve math problems. You will only write code blocks.Some examples will be provided for reference."""
    # greedy decoding
    got_result = False
    while not got_result:
        try:
            result = openai.ChatCompletion.create(
                engine='gpt-35-turbo',
                messages=[{"role": "system", "content": SYSTEMQ},
                          {"role": "user", "content": full_prompt}],
                max_tokens=1028,
                temperature=0.7,
                top_p=1,
                n=10,
            )
            got_result = True
        except Exception as e:
            sleep(20)
            print(e)
    result = result['choices']
    return result

if __name__ == "__main__":
    openai.api_version = "2023-05-15"
    datas=[]
    data=[]
    input_filename="../datas/svamp_thought_chains_test.json"
    output_filename = "../datas/svamp_pot_cot_chains_test.json"
    with open(input_filename) as f:
        test_set=json.load(f)
    answered_set = dict()
    now = datetime.now()
    dt_string = now.strftime("%m_%d_%H_%M")
    correct, wrong = 0, 0
    print(f'length of dataset: {len(test_set)}')
    print(output_filename)
    for idx, example in enumerate(test_set):
        print(idx)
        full_prompt = create_reader_request(example['input'].replace('\n',' '))
        if args.dry_run:
            print(full_prompt)
            print('=======================')
            continue
        try:
            results = run_pot_prompt(full_prompt)
        except:
            print('error occur')
            continue
        for i, result in enumerate(results):
            result = extract_code(result=result['message']['content'])
            example[f"pot{i + 1}"] = result
            prediction=None
            try:
                exec(result)
                try:
                    prediction = func_timeout.func_timeout(10, solution, args=())
                except func_timeout.FunctionTimedOut:
                    prediction = None
            except Exception as e:
                print(e)
                prediction = None
            example[f"pot{i + 1}_ans"]=prediction
            
           # print(result)
           # print(prediction, ' $$$$$$$$$ ')#, example['Answer'])
        print()
        datas.append(example)
        # writer.write(json.dumps(tmp) + '\n')
    with open(output_filename,'w') as f:
        json.dump(datas,f,indent=4)
    print()


