import argparse


def finetune_args():
    parser = argparse.ArgumentParser(description='Finetune parameters')

    parser.add_argument('--gpu', default=2, type=int, help='Number of GPU used')
    parser.add_argument('--src_max_len', default=1024, type=int, help='Max source length')
    parser.add_argument('--tgt_max_len', default=1024, type=int, help='Max target length')
    parser.add_argument('--save_dir', default='trained', type=str, help='Where to save model checkpoints')
    parser.add_argument('--checkpoint', default='facebook/bart-large-cnn', type=str,
                        help='Which checkpoint to load from')
    parser.add_argument('--n_epochs', default=3, type=int, help='How many epochs to train')
    parser.add_argument('--lr', default=5e-5, type=float, help='learning rage')
    parser.add_argument('--weight_decay', default=0.0, type=float, help='weight decay')
    parser.add_argument('--warmup_steps', default=0, type=int, help='Number of warmup steps')
    parser.add_argument('--adam_epsilon', default=1e-8, type=float, help='AdamW epsilon')
    parser.add_argument('--batch_size', default=20, type=int, help='Training batch size')

    args = parser.parse_args()

    return args


def generate_args():
    parser = argparse.ArgumentParser(description='Generation parameters')
    args = parser.parse_args()
    return args
