## IM-BERT: Enhancing Robustness of BERT through the Implicit Euler Method
This code is based on the Huggingface(https://github.com/huggingface/transformers.git) and pytorch bert-fine-tuning(https://github.com/calofmijuck/pytorch-bert-fine-tuning.git) 
## Requirements and Installation
- You can check requirements in ode.yaml

### Prepare Data

#### 1. (GLUE)For preprocess GLUE, please run Preprocessing/preprocessing_GLUE.ipynb 

#### 2. (GLUE)For preprocess AdvGLUE, please run Preprocessing/preprocessing_GLUE.ipynb 
    - If you want to access AdvGLUE, download the dataset directly from official github(https://github.com/AI-secure/adversarial-glue.git)
#### 3. (IMDB and attacked IMDB by textfooler)
    - For preprocess IMDB and attacked data, please run preprocessing/preprocessing_imdb.ipynb and preprocessing_imdb_textfooler.ipynb
    - If you want to access imdb attacked from textfoller, download the dataset directly from the git(https://github.com/jind11/TextFooler.git)

### Run experiments
#### For running BERT in our settings
1. For running BERT in you setting

        bash run_bert.sh
	- You can change parameters(task_name, local rank for cuda_num, samples..) in run_bert.sh
	- If you would like to run with full dataset, please delete '--num_samples'.

2. For running IM-BERT in you setting,

        bash run_im_bert.sh

	- You can change parameters(task_name, local rank for cuda_num, samples..) in run_bert.sh
    - If you would like to run with full dataset, please delete '--num_samples'.

    - Further, you can change the hyperparameters of IM-connection in the file model/imbert.py . Go to the class IMBERTconfig and change the parameter T(iteration) and wd(step size)
        If you set the T=0, The model becomes EXBERT.

## Results
### main results

| Model                            | SST-2 | QQP | QNLI | MNLI | MNLI_mm | RTE | Avg |
| -------------------------------- | ----- | ----- | ----- | ----- | ----- | ----- | ----- |
| BERT   | 31.1 | 47.4/- | 36.5 | 33.1 | 27.8 | 34.6 | 32.62 |
| EX-BERT| 33.78 | 42.3 | 40.5 | 36.3 | 33.3 | 28.4 | 34.46 |
| IM-BERT   | **39.28** | **48.8** | **41.2** | **38.1** | **35.2** | **44.4** | **39.62** |


