import copy

basic_classification = {
    "name": None,
    "method": None,
    "ds_name": None,
    "seed": 1234,
    "num_try": 100,
    "num_authors": 10,
    "num_shots": 1,
    "num_test_rows": 1,
    "use_cache": True,
}

from .algorithms import logprob
default_logprob_classification = {
    **basic_classification,
    "method": "logprob_classification",
    "prompt_composer": lambda x: (
        "\n\n".join(x["text"].to_list())
        + "\n\nHere is the text from the same author:\n\n"
    ),
    "completion_kwargs": {"model": None},
}

from .algorithms import qa

default_qa_classification = {
    **basic_classification,
    "method": "qa",
    "prompt_composer": qa.default_prompt_composer,
    "response_parser": qa.default_response_parser,
    "completion_kwargs": {"model": None},
}

debug_exp1 = {
    **default_logprob_classification,
    "name": "debug_exp1",
    "ds_name": "imdb",
    "completion_kwargs": {"model": "NousResearch/Meta-Llama-3-70B"},
}


debug_exp2 = {
    **default_qa_classification,
    "name": "debug_exp2",
    "ds_name": "imdb",
    "completion_kwargs": {"model": "Llama-3-70B-Instruct"},
}

debug_exp3 = {
    **default_qa_classification,
    "name": "debug_exp3",
    "ds_name": "imdb",
    "completion_kwargs": {"model": "gpt-4-turbo"},
}


debug_exp4 = {
    **default_logprob_classification,
    "name": "debug_exp4",
    "ds_name": "blog",
    "completion_kwargs": {"model": "NousResearch/Meta-Llama-3-70B"},
}


# acc vs number of authors
ablation_exp1 = [
    {
        **default_logprob_classification,
        "name": f"ablation_exp1_{na}",
        "ds_name": "imdb",
        "num_authors": na,
        "completion_kwargs": {"model": "NousResearch/Meta-Llama-3-70B"},
    }
    for na in [2, 5, 10, 20, 50]
]


# acc vs gender
ablation_exp2 = [
    {
        **default_logprob_classification,
        "name": f"ablation_exp2_{gender}",
        "ds_name": "blog",
        "filter_config": {"gender": gender},
        "completion_kwargs": {"model": "NousResearch/Meta-Llama-3-70B"},
    }
    for gender in ["female", "male"]

]

# acc vs. age 
ablation_exp3 = [
    {
        **default_logprob_classification,
        "name": f"ablation_exp3_age_{min_age}_{max_age}",
        "ds_name": "blog",
        "filter_config": {
            "min_age": min_age,
            "max_age": max_age,
        },
        "completion_kwargs": {"model": "NousResearch/Meta-Llama-3-70B"},
    }
    for min_age, max_age in [(13, 17), (21, 28), (29, 36), (37, 44), (45, 52)]
]
ablation_exp4 = [
    {
        **default_logprob_classification,
        "name": f"ablation_exp4_age_{min_age}_{max_age}",
        "ds_name": "blog",
        "filter_config": {
            "min_age": min_age,
            "max_age": max_age,
        },
        "completion_kwargs": {"model": "NousResearch/Meta-Llama-3-70B"},
    }
    for min_age, max_age in [(13, 17), (18, 34), (35, 44), (45, 52)]
]

# different prompt
ablation_exp5 = [
    {
        **default_logprob_classification,
        "name": f"ablation_exp5_{i}",
        "ds_name": "imdb",
        "prompt_composer": prompt_composer,
        "completion_kwargs": {"model": "NousResearch/Meta-Llama-3-70B"},
    }
    for i, prompt_composer in enumerate(
        [
            lambda x: ("\n\n".join(x["text"].to_list()) + ""),
            lambda x: (
                "\n\n".join(x["text"].to_list())
                + "\n\nThis text is from the same author:\n\n"
            ),
            lambda x: (
                "\n\n".join(x["text"].to_list())
                + "\n\nAnalyze the writing styles of the input texts, disregarding the differences in topic and content. Here is the text from the same author:\n\n"
            ),
            lambda x: (
                "\n\n".join(x["text"].to_list())
                + "\n\nFocus on grammaticalstyles indicative of authorship. Here is the text from the same author:\n\n"
            ),
            lambda x: (
                "\n\n".join(x["text"].to_list())
                + "\n\nAnalyze the writing styles of the input texts, disregarding the differences in topic and content. Reasoning based on linguistic features such as phrasal verbs, modal verbs, punctuation, rare words, affixes, quantities, humor, sarcasm, typographical errors, and misspellings.Here is the text from the same author:\n\n"
            ),
            lambda x: (
                "Here are the texts from the same author:\n\n"
                "\n---\n".join(x["text"].to_list()) + "\n---\n"
            ),
        ]
    )
]

# different rating range
ablation_exp6 = [
    {
        **default_logprob_classification,
        "name": f"ablation_exp6_{rating_range[0]}_{rating_range[1]}",
        "ds_name": "imdb",
        "filter_config": {
            "min_rating": rating_range[0],
            "max_rating": rating_range[1],
        },
        "completion_kwargs": {"model": "NousResearch/Meta-Llama-3-70B"},
    }
    for rating_range in [(1, 2), (3, 4), (5, 6), (7, 8), (9, 10)]
]

# logprob on different models
compare_exp1 = [
    {
        **default_logprob_classification,
        "name": f"compare_exp1_{ds}_{model.split('/')[-1].replace('-', '_')}",
        "ds_name": ds,
        "completion_kwargs": {"model": model},
    }
    for model in [
        #  "text-davinci-003",  # deprecated model
        "NousResearch/Meta-Llama-3-70B",
        "NousResearch/Meta-Llama-3-70B-Instruct",
        "NousResearch/Meta-Llama-3-8B",
        "NousResearch/Meta-Llama-3-8B-Instruct",
        "NousResearch/Llama-2-70b-hf",
        #  "Llama2-70B",  # available on azure, but has content filter
        "NousResearch/Llama-2-70B-chat-hf",
        "NousResearch/Llama-2-13b-hf",
        "NousResearch/Llama-2-7b-chat-hf",
        "NousResearch/Llama-2-7b-hf",
        "NousResearch/Llama-2-7b-chat-hf",
        "NousResearch/CodeLlama-34b-hf",
        "NousResearch/CodeLlama-13b-hf",
        "NousResearch/CodeLlama-7b-hf",
        #  "huggyllama/llama-65b",  # only 2048 context window
        #  "huggyllama/llama-30b",
        #  "huggyllama/llama-13b",
        #  "huggyllama/llama-7b",
    ]
    for ds in ["imdb", "blog"]
]

# qa on different models
compare_exp2 = [
    {
        **default_qa_classification,
        "name": f"compare_exp2_{ds}_{model.split('/')[-1].replace('-', '_')}",
        "ds_name": ds,
        "completion_kwargs": {"model": model},
    }
    for ds in ["imdb", "blog"]
    for model in [
        "gpt-4-turbo-2024-04-09",
        "gpt-3.5-turbo-0125",
        "Llama-3-70B-Instruct",
    ]
]

# speed
compare_exp3 = [
    {
        **default_logprob_classification,
        "name": f"compare_exp3_logprob",
        "ds_name": "imdb",
        "completion_kwargs": {"model": "NousResearch/Meta-Llama-3-70B"},
        "use_cache": False,
    },
    {
        **default_qa_classification,
        "name": f"compare_exp3_qa_1",
        "ds_name": "imdb",
        "completion_kwargs": {"model": "Llama-3-70B-Instruct"},
        "use_cache": False,
    },
    {
        **default_qa_classification,
        "name": f"compare_exp3_qa_2",
        "ds_name": "imdb",
        "completion_kwargs": {"model": "gpt-4-turbo-2024-04-09"},
        "use_cache": False,
    },
]

large_exp1 = [
    {
        **default_logprob_classification,
        "name": f"large_exp1_{db}",
        "ds_name": db,
        "num_try": 500,
        "completion_kwargs": {"model": "NousResearch/Meta-Llama-3-70B"},
    }
    for db in ["imdb", "blog"]
]
