# Online CSLR Framework
Code for our proposed online continuous sign language recognition framework


## Data Preparation
For datasets and keypoint inputs, please check ../README.md

### Segment Isolated Signs
We use a pre-trained CSLR model, TwoStream-SLR, to segment continuous sign videos into a set of isolated sign clips.
The pre-trained model checkpoints can be downloaded from: https://github.com/FangyunWei/SLRT/blob/main/TwoStreamNetwork/docs/TwoStream-SLR.md
After downloading, put them into the folder ../CTC_based/results
Then run
```
python gen_segment.py
```

### Sign Augmentation
Since the segmented signs are pseudo ground-truths and their boundaries may not be accurate, we further augment these segmented signs by running
```
python sign_augment.py
```


## Training
```
config_file='configs/phoenix-2014t_ISLR.yaml'
python -m torch.distributed.launch --nproc_per_node 8 --master_port 29999 --use_env training.py --config=${config_file} 
```


## Testing (online inference)
```
config_file='configs/slide_phoenix-2014t.yaml'
python -m torch.distributed.launch --nproc_per_node 1 --master_port 29999 --use_env prediction_slide.py --config=${config_file}  --save_fea 1
```
The flag "--save_fea" is optional, which aims to extract features for boosting an offline model with the well-optimized online model.