import json
import pandas as pd
from wikidata.client import Client
import requests
import wptools
import os
url = 'https://query.wikidata.org/sparql'

# get unique feature B set
# for each feature in the set, get all men with that feature, and all women with that feature
# if it times out or has length zero, discard it
# features =  {"P101": ['Q521', 'Q413', 'Q1071', 'Q333', 'Q8087', 'Q7094', 'Q21201', 'Q514', 'Q395', 'Q34178', 'Q18362', 'Q188444', 'Q841090', 'Q41217', 'Q461659', 'Q467606', 'Q8134', 'Q11190', 'Q889', 'Q169470', 'Q170790', 'Q7754', 'Q40821', 'Q11059', 'Q132151', 'Q865811', 'Q474200', 'Q36963', 'Q4964182', 'Q42989', 'Q159943', 'Q38112', 'Q8078', 'Q23404', 'Q5891', 'Q1860', 'Q9288', 'Q8162', 'Q9730', 'Q8434', 'Q184274', 'Q2329', 'Q7205', 'Q11661', 'Q7162', 'Q9465', 'Q3764113', 'Q5862903', 'Q640280', 'Q37547', 'Q192239', 'Q116854526', 'Q8242', 'Q11629', 'Q208505', 'Q482', 'Q182357', 'Q118924950', 'Q8341', 'Q11448', 'Q7252', 'Q25447176', 'Q699', 'Q309', 'Q46221', 'Q177409', 'Q201486', 'Q35760', 'Q338', 'Q12479', 'Q3968', 'Q183216', 'Q156495', 'Q1428943', 'Q131683', 'Q1144457', 'Q2225', 'Q161272', 'Q81197', 'Q11023', 'Q25261', 'Q874709', 'Q123637', 'Q720362', 'Q44325', 'Q43455', 'Q28575007', 'Q1620918', 'Q18335', 'Q14620', 'Q42515', 'Q4530851', 'Q7163', 'Q42002', 'Q9418', 'Q8789', 'Q7168', 'Q9129', 'Q1344', 'Q111077083', 'Q75', 'Q12831143', 'Q373065', 'Q1953188', 'Q190549', 'Q126842', 'Q41425', 'Q33521', 'Q1066186', 'Q812535', 'Q9134', 'Q11063', 'Q20665028', 'Q11163999', 'Q186579', 'Q676', 'Q115160290', 'Q11206', 'Q11030', 'Q11408', 'Q876215', 'Q268194', 'Q149999', 'Q21198', 'Q3754567', 'Q664495', 'Q59115', 'Q34362', 'Q3194786', 'Q184207', 'Q131015', 'Q1229559', 'Q232207', 'Q134787', 'Q1503766', 'Q160398', 'Q1418771', 'Q473750', 'Q44432', 'Q9268', 'Q27172', 'Q131089', 'Q40634', 'Q6989196', 'Q1063', 'Q43035', 'Q1129353', 'Q11639', 'Q578874', 'Q7922', 'Q1071239', 'Q837795', 'Q115144015', 'Q1075827', 'Q25372', 'Q268416', 'Q27841', 'Q1166618', 'Q159810', 'Q43514', 'Q216861', 'Q104193508', 'Q19924411', 'Q36192', 'Q101333', 'Q180592', 'Q742963', 'Q64968842', 'Q319913', 'Q34651', 'Q11468', 'Q180856', 'Q12016129', 'Q180969', 'Q177625', 'Q115156516', 'Q83042', 'Q459381', 'Q271977', 'Q10843274', 'Q874429', 'Q18366', 'Q944', 'Q7991', 'Q8084', 'Q4027615', 'Q846742', 'Q6593690', 'Q179805', 'Q38157', 'Q212803', 'Q234881', 'Q12725', 'Q12483', 'Q113785253', 'Q15416', 'Q29051', 'Q8424', 'Q3294789', 'Q11828784', 'Q464794', 'Q11412', 'Q233858', 'Q173853', 'Q9339103', 'Q166509', 'Q113785224', 'Q209306', 'Q184631', 'Q9174', 'Q200286', 'Q115154805', 'Q628455', 'Q113785226', 'Q41273', 'Q12827256', 'Q193544', 'Q81741', 'Q131476'], 
			# "P27": ['Q145', 'Q30', 'Q174193', 'Q13426199', 'Q142', 'Q183', 'Q28', 'Q34266', 'Q29999', 'Q40', 'Q27306', 'Q170072', 'Q21', 'Q4734309', 'Q408', 'Q589662', 'Q15180', 'Q39', 'Q1747689', 'Q38', 'Q43287', 'Q34', 'Q16', 'Q153529', 'Q12548', 'Q179876', 'Q172107', 'Q230791', 'Q155570', 'Q435583', 'Q131964', 'Q172579', 'Q4420718', 'Q664', 'Q17', 'Q20', 'N/A', 'Q12536', 'Q1206012', 'Q756617', 'Q151624', 'Q20135', 'Q1028', 'Q161885', 'Q36', 'Q154195', 'Q221457', 'Q158445', 'Q844930', 'Q2305208', 'Q154741', 'Q164079', 'Q529605', 'Q154849', 'Q10957559', 'Q668', 'Q35', 'Q2252973', 'Q31', 'Q33', 'Q41', 'Q148540', 'Q533534', 'Q28513', 'Q1233672', 'Q70972', 'Q884', 'Q29', 'Q223050', 'Q45670', 'Q159', 'Q27', 'Q62633', 'Q7318', 'Q114', 'Q62651', 'Q713750', 'Q2577303', 'Q203493', 'Q133356', 'Q207272', 'Q46315', 'Q25395037', 'Q1792', 'Q41304', 'Q801', 'Q1031430', 'Q12544', 'Q150981', 'Q171150', 'Q237'],
			# "P172": ['Q7325', 'Q170217', 'Q49085', 'Q44806', 'Q79797', 'Q42884', 'Q49542', 'Q42406', 'Q726673', 'Q539051', 'Q1026', 'Q121842', 'Q161652', 'Q50001', 'Q167420', 'Q18973', 'Q15916203', 'Q237534', 'Q171336', 'Q846570', 'Q181634', 'Q165192', 'Q842438', 'Q42740', 'Q1146100', 'Q518188', 'Q34069', 'Q678551', 'Q105405', 'Q216151', 'Q482942', 'Q1280677', 'Q1467740', 'Q157139', 'Q235155', 'Q170284', 'Q188779', 'Q35323', 'Q201190', 'Q4775051', 'Q173491', 'Q1267987', 'Q190168', 'Q2325516', 'Q817393', 'Q668', 'Q15863', 'Q170826', 'Q5374230', 'Q1282294', 'Q7361505', 'Q58843', 'Q7223451', 'Q644137', 'Q1208167', 'Q140472', 'Q1242155', 'Q318806', 'Q701676', 'Q1200528', 'Q110223', 'Q571942', 'Q1196649', 'Q690869', 'Q133032', 'Q7416717', 'Q118281', 'Q200569', 'Q1075293', 'Q28', 'Q117458', 'Q5501667', 'Q857880', 'Q145665', 'Q7023212', 'Q160894', 'Q2025325', 'Q24014808', 'Q2997267', 'Q1760969', 'Q35565', 'Q203319', 'Q108266', 'Q51705', 'Q49297', 'Q4855428', 'Q622728', 'Q1436196', 'Q415054', 'Q1074730', 'Q262457', 'Q164714', 'Q1196645', 'Q485150', 'Q7994501', 'Q63075063', 'Q3476361', 'Q862086', 'Q49540', 'Q186192', 'Q1815623', 'Q147540', 'Q17280097', 'Q255872', 'Q4938422', 'Q547748', 'Q102090', 'Q1156766', 'Q189975', 'Q679524', 'Q837881', 'Q12223', 'Q1189552', 'Q756716', 'Q4115170', 'Q200263', 'Q7032863', 'Q32360797', 'Q135863', 'Q1956640', 'Q750947', 'Q1307911', 'Q133255', 'Q974693', 'Q276879', 'Q1672477', 'Q84072', 'Q581921', 'Q1378555', 'Q483569', 'Q2254415', 'Q1752440', 'Q1673765', 'Q704608', 'Q2995285', 'Q12960308', 'Q6127469', 'Q1369944', 'Q28172443', 'Q43103', 'Q2050339', 'Q49078', 'Q423803', 'Q23445', 'Q484464', 'Q1060050', 'Q365539', 'Q4882454', 'Q2935829', 'Q115842165', 'Q2302939', 'Q1187403', 'Q707133', 'Q1209676', 'Q1799968', 'Q478289', 'Q520663', 'Q28153962', 'Q4690175', 'Q484206', 'Q487796', 'Q484472', 'Q2593852', 'Q7125804', 'Q178630', 'Q321090'],
			# "P19": ['Q3776576', 'Q1415', 'Q18125', 'Q11736', 'Q13362', 'Q287148', 'Q2861', 'Q1741', 'Q3834', 'Q90', 'Q374745', 'Q1297', 'Q54163', 'Q2598', 'Q1720', 'Q649', 'Q727', 'Q1735', 'Q1781', 'Q84', 'Q1022', 'Q60', 'Q863832', 'Q123709', 'Q1003286', 'Q16568', 'Q4083', 'Q36600', 'Q2640897', 'Q4734309', 'Q823531', 'Q80484', 'Q47554', 'Q734064', 'Q446314', 'Q517311', 'Q198190', 'Q3138', 'Q105048', 'Q18986', 'Q102621', 'Q5838', 'Q184163', 'Q1794', 'Q835831', 'Q1754', 'Q490', 'Q1799', 'Q749', 'Q3316008', 'Q22905', 'Q1792', 'Q1921452', 'Q891', 'Q630668', 'Q3150', 'Q745594', 'Q275731', 'Q1327770', 'Q1055', 'Q78', 'Q106274', 'Q72', 'Q1779185', 'Q507117', 'Q157725', 'Q269476', 'Q173695', 'Q564827', 'Q40898', 'Q1085', 'Q584458', 'Q1228829', 'Q1761', 'Q194420', 'Q1159513', 'Q42308', 'Q845623', 'Q13210107', 'Q482657', 'Q477987', 'Q1773', 'Q4420718', 'Q206687', 'Q1490', 'Q21711493', 'Q67778', 'Q572595', 'Q265332', 'Q49111', 'Q617407', 'Q186234', 'Q627653', 'Q3619316', 'Q467617', 'Q1711', 'Q16553', 'Q5839', 'Q648432', 'Q22741', 'Q656', 'Q269980', 'Q59670', 'Q966192', 'Q1781710', 'Q551378', 'Q123559', 'Q375314', 'Q33959', 'Q142', 'Q270', 'Q104731', 'Q156743', 'Q62460', 'Q64589', 'Q4093', 'Q610238', 'Q197691', 'Q140342', 'Q153494', 'Q43631', 'Q1709', 'Q4518353', 'Q2593038', 'Q2453742', 'Q6837', 'Q176410', 'Q1715', 'Q1890931', 'Q3626259', 'Q1618770', 'Q11025', 'Q7027', 'Q6346', 'Q1828035', 'Q2865', 'Q7473516', 'Q23154', 'Q13375', 'Q192265', 'Q484552', 'Q64', 'Q725261', 'Q500939', 'Q797437', 'Q319397', 'Q54140', 'Q4418120', 'Q87', 'Q41252', 'Q1748', 'Q3846', 'Q13373', 'Q655874', 'Q1296', 'Q30096', 'Q40623', 'Q985461', 'Q1524', 'Q3923', 'Q34615', 'Q2722267', 'Q7042', 'Q161994', 'Q13666', 'Q2746', 'Q1537', 'Q181704', 'Q52098', 'Q18424', 'Q433701', 'Q23360', 'Q1345', 'Q288082', 'Q1490411', 'Q24826', 'Q181725', 'Q220', 'Q1679681', 'Q18426', 'Q1780', 'Q23436', 'Q2711986', 'Q1013549', 'Q25286', 'Q536598', 'Q576671', 'Q31487', 'Q26339', 'Q43509', 'Q18655', 'Q492538', 'Q2880', 'Q1729', 'Q2749', 'Q939529', 'Q963309', 'Q2683', 'Q1005862', 'Q1247384', 'Q1144835', 'Q2145988', 'Q1492', 'Q487977', 'Q320233', 'Q462177', 'Q6602', 'Q1807458', 'Q339182', 'Q42168', 'Q2256', 'Q212856', 'Q135572', 'Q42088', 'Q203040', 'Q3915', 'Q504875', 'Q81621', 'Q42807', 'Q2061870', 'Q206988', 'Q38511', 'Q36433', 'Q36036', 'Q6366688', 'Q853324', 'Q19272', 'Q7880', 'Q209126', 'Q997335', 'Q25331', 'Q10549787', 'Q145', 'Q33180', 'Q4115712', 'Q12037664', 'Q1231883', 'Q936641', 'Q65430768', 'Q7802072', 'Q4881598', 'Q288781', 'Q9275212', 'Q18419', 'Q10710237', 'Q552692', 'Q163', 'Q111362759', 'Q783205', 'Q18094', 'Q664599', 'Q915930', 'Q85166591', 'Q2975160']}
features = {"P101": [], "P103": [], "P19_P21": [], 
			"P19_P101": [], "P21_P101": [], "P27_P19": [],
			"P27_P101": [], "P101_P21": [], "P101_P27": []}
for p in features.keys():
	with open(f"../data/seesaw_cf_{p}.json") as o:
		full = json.load(o)
		features[p] = list(set([rr["requested_rewrite"]["target_true"]["id"] for rr in full] + [rr["requested_rewrite"]["target_new"]["id"] for rr in full]))
genders = ["Q6581072", "Q6581097"]
# good_features = {"P101": [], "P27": [], "P172": [], "P19": []}

for key in features:
	print(len(features[key]), key)
	for i, cue in enumerate(features[key]):
		print(i)
		for gender in genders:
			if "_" in key:
				key = key.split("_")[0]
			if os.path.exists(f"../data/wiki/{gender}_{key}_{cue}.json"):
				continue
			data = {}
			query = f'''SELECT DISTINCT ?item ?itemLabel WHERE {{
						  SERVICE wikibase:label {{ bd:serviceParam wikibase:language '[AUTO_LANGUAGE]'. }}
						  {{
						    SELECT DISTINCT ?item WHERE {{
						      ?item p:P21 ?statement0.
						      ?statement0 (ps:P21) wd:{gender}.
						      ?item p:{key} ?statement1.
						      ?statement1 (ps:{key}) wd:{cue}.
						    }}
						  }}
						}}
				'''
			try:
				r = requests.get(url, params = {'format': 'json', 'query': query})
				binds = r.json()["results"]["bindings"]
				for bind in binds[:min(200, len(binds))]:
					q = bind['itemLabel']['value']
					try:
						page = wptools.page(wikibase = q, silent = True)
						wikidata = page.get_wikidata(show = False).data
						data[q] = {"name": wikidata["label"], "properties": wikidata["claims"]}
					except:
						data[q] = {}
			except Exception as e:
				print(e)
				data[q] = {}			
			with open(f"../data/wiki/{gender}_{key}_{cue}.json", "w") as o:
				json.dump(data, o)
		# if len(data[0]) > 0 and len(data[1]) > 0:
		# 	good_features[key].append(cue)
		# 	for i in range(len(data)):
		# 		with open(f"../data/{genders[i]}_{key}_{cue}.json", "w") as o:
		# 			json.dump(data[i], o)


