theory question_50_1

imports Main

begin

typedecl entity
typedecl event

consts
  ManRiding :: "entity ⇒ entity ⇒ event ⇒ bool"
  Riding :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Man :: "entity ⇒ bool"
  DirtBike :: "entity ⇒ bool"
  Vehicle :: "entity ⇒ bool"
  Rideable :: "entity ⇒ bool"
  RidingEventOn :: "event ⇒ entity ⇒ bool"
  Racetrack :: "entity ⇒ bool"

(* Explanation 1: ∃x y e. ManRiding(x, y, e) ⟶ ∃e. Riding(e) ∧ Agent(e, x) ∧ Patient(e, y) *)
axiomatization where
  explanation_1: "∀x y e. ManRiding x y e ⟶ (∃e'. Riding e' ∧ Agent e' x ∧ Patient e' y)"

(* Explanation 2: ∀x. DirtBike(x) ⟶ Vehicle(x) ∧ Rideable(x) *)
axiomatization where
  explanation_2: "∀x. DirtBike x ⟶ (Vehicle x ∧ Rideable x)"

(* Explanation 3: ∀x. Man(x) ⟶ ∃e. Agent(e, x) ∧ Riding(e) *)
axiomatization where
  explanation_3: "∀x. Man x ⟶ (∃e. Agent e x ∧ Riding e)"

theorem hypothesis:
  (* Premise: ∃x y s e. Man(x) ∧ DirtBike(y) ∧ Racetrack(s) ∧ Riding(e) ∧ Agent(e, x) ∧ Patient(e, y) ∧ RidingEventOn(e, s) *)
  assumes asm: "Man x ∧ DirtBike y ∧ Racetrack s ∧ Riding e ∧ Agent e x ∧ Patient e y ∧ RidingEventOn e s"
  (* Hypothesis: ∃x y e. Man(x) ∧ DirtBike(y) ∧ Riding(e) ∧ Agent(e, x) ∧ Patient(e, y) *)
  shows "∃x y e. Man x ∧ DirtBike y ∧ Riding e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "∃e. Riding e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis by blast
qed

end
