theory question_81_4
imports Main

begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"
  TypicallyPartOf :: "entity ⇒ entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Forest :: "entity ⇒ bool"

(* Explanation 1: Soil is a nonliving entity that is typically part of certain types of environments. *)
axiomatization where
  explanation_1: "∀x. Soil x ⟶ (Nonliving x ∧ ∃y. TypicallyPartOf x y)"

(* Explanation 2: If an entity is typically part of environments of a certain type, then it is part of that type of environment. *)
axiomatization where
  explanation_2: "∀x y. TypicallyPartOf x y ⟶ PartOf x y"

theorem hypothesis:
  assumes asm: "Soil x"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "Nonliving x ∧  ∃y. Forest y ∧ PartOf x y "
proof -
  {
    assume asm: "Soil x"
    from asm have "Nonliving x" using explanation_1 by blast
    then obtain y where y: "TypicallyPartOf x y" using explanation_1 by blast
    from y have "PartOf x y" using explanation_2 by blast
    with y have "∃y. Forest y ∧ PartOf x y" using asm by blast
  }
  then show ?thesis using asm by blast
qed

end
