theory question_83_9

definition ElectricalCircuit_WorkProperly_Computer_Run (x y e) =
let
  ElectricalCircuit(y), WorkProperly(e), Computer(x), Run(e)
in
  Agent(e, x) ∧ Patient(e, y)
end

definition ElectricalCircuit_WorkProperly_Computer_RequiredElectricalCurrent (x y e) =
let
  ElectricalCircuit(y), WorkProperly(e), Computer(x), RequiredElectricalCurrent(e)
in
  Agent(e, x) ∧ Patient(e, y)
end

definition ElectricalCircuit_WorkProperly_Computer_NecessaryElectricalCurrent (x y e) =
let
  ElectricalCircuit(y), WorkProperly(e), Computer(x), NecessaryElectricalCurrent(e)
in
  Agent(e, x) ∧ Patient(e, y)
end

definition ElectricalCircuit_WorkProperly_Computer_ElectricalCurrent (x y e) =
let
  ElectricalCircuit(y), WorkProperly(e), Computer(x), ElectricalCurrent(e)
in
  Agent(e, x) ∧ Patient(e, y)
end

axiomatization where
  explanation_1: "∀x y z. ElectricalCircuit(y) ∧ WorkProperly(z) ∧ Computer(x) ∧ Run(z) ⟶ (∃e. Agent(e, x) ∧ Patient(e, y))"

proof -
  from asm have "ElectricalCircuit(y) ∧ WorkProperly(e) ∧ Computer(x) ∧ Run(z)" by simp
  then obtain e1 where e1: "Agent(e1, x) ∧ Patient(e1, y)" using explanation_1 by blast
  then have "ElectricalCurrent(e1)" using explanation_2 by blast
  have conclusion: "Agent(e1, x) ∧ Patient(e1, y) ∧ ElectricalCurrent(e1)"
  then have "Computer(x) ∧ Run(z)" using explanation_3 by blast
  then have "ElectricalCircuit(y) ∧ WorkProperly(e) ∧ Computer(x) ∧ Run(z)" using conclusion by blast
  qed

end
