theory question_12_6
imports Main
begin

typedecl entity

consts
  Sun :: "entity ⇒ bool"
  EarthSurface :: "entity ⇒ bool"
  SourceOfEnergy :: "entity ⇒ entity ⇒ bool"
  Heat :: "entity ⇒ bool"
  MainSourceOfHeat :: "entity ⇒ entity ⇒ bool"
  Called :: "entity ⇒ entity ⇒ bool"
  Sunlight :: "entity"

(* Explanation 1: The Sun is the source of energy for the Earth's surface. *)
axiomatization where
  explanation_1: "∀x y. Sun x ∧ EarthSurface y ⟶ SourceOfEnergy x y"

(* Explanation 2: The Sun is the main source of heat for the Earth's surface, this heat is called sunlight. *)
axiomatization where
  explanation_2: "∀x y z. Sun x ∧ EarthSurface y ∧ Heat z ⟶ MainSourceOfHeat x y ∧ Called z Sunlight"  

theorem hypothesis:
  assumes asm: "Sun x ∧ EarthSurface y"
  (* Hypothesis: The Sun is the main source of heat for Earth's surface. *)
  shows "MainSourceOfHeat x y"
proof -
  from asm have "Sun x ∧ EarthSurface y" by simp
  then obtain z where z: "Heat z ∧ MainSourceOfHeat x y ∧ Called z Sunlight" using explanation_2 by blast
  have conclusion: "MainSourceOfHeat x y" using z by simp
  show ?thesis using asm conclusion by blast
qed

end
