theory question_14_0

imports Main

begin

typedecl entity
typedecl event

consts
  Animal :: "entity ⇒ bool"
  Fission :: "event ⇒ bool"
  TakesPlace :: "event ⇒ bool"
  Divides :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Isotope :: "entity ⇒ bool"
  Capable :: "entity ⇒ bool"
  Undergoing :: "event ⇒ bool"
  FissileIsotope :: "entity ⇒ bool"
  Dividing :: "event ⇒ bool"

(* Explanation 1: Fission takes place when an animal divides into two parts. *)
axiomatization where
  explanation_1: "∀x e1 e2. Animal x ∧ Fission e1 ⟶ (TakesPlace e1 ∧ Divides e2 ∧ Agent e2 x)"

(* Explanation 2: An isotope capable of undergoing fission is called a fissile isotope. *)
axiomatization where
  explanation_2: "∀x e. Isotope x ∧ Capable x ∧ Undergoing e ∧ Fission e ⟶ FissileIsotope x"  

theorem hypothesis:
  assumes asm: "FissileIsotope x ∧ Capable x"
  (* Hypothesis: Fissile isotopes are capable of dividing into two parts. *)
  shows "∃x e. FissileIsotope x ∧ Capable x ∧  Dividing e ∧ Agent e x "
proof -
  from asm have "FissileIsotope x ∧ Capable x" by simp
  then obtain e where e: "Undergoing e ∧ Fission e" using explanation_2 by blast
  then have "Dividing e ∧ Agent e x" using explanation_1 by blast
  have conclusion: "FissileIsotope x ∧ Capable x ∧ Dividing e ∧ Agent e x" using asm `Dividing e ∧ Agent e x` by simp
  show ?thesis using conclusion by blast
qed

end
