theory question_88_6

imports Main

begin
typedecl entity
typedecl event

consts
  Gymnast :: "entity ⇒ bool"
  Flip :: "entity ⇒ bool"
  Does :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Displays :: "event ⇒ bool"
  Skills :: "entity ⇒ bool"
  Flooring :: "entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: When a gymnast does a flip, they are displaying their skills. *)
axiomatization where
  explanation_1: "∀x y e1 e2. Gymnast x ∧ Flip y ∧ Does e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ Displays e2 ∧ Agent e2 x ∧ Patient e2 y"

theorem hypothesis:
  (* Premise: Gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip y ∧ Flooring z ∧ Blue z ∧ Does e ∧ Agent e x ∧ Patient e y ∧ On e z"
  (* Hypothesis: A gymnast displays their skills with a flip *)
  shows "∃x y e. Gymnast x ∧ Skills y ∧ Flip y ∧ Displays e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Gymnast x ∧ Flip y ∧ Does e ∧ Agent e x ∧ Patient e y" by blast
  then have "Displays e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
