;; From mbv@linus.mitre.org Fri Oct 30 10:53:08 1992

;; # Names of women from lots of languages
;; #
;; # From Bob Baldwin's collection from MIT
;; # Augmented by Matt Bishop and Daniel Klein
;; #
;; # SIGNIFICANTLY REDUCED by LKS, June 18/01, to eliminate names that
;; # are (1) usually male names, (2) much more common as nouns than names,
;; # (3) more common as names of other entities (e.g., "April"), (4)
;; # judged to be virtually non-occurring (lots more might be added to
;; # that category, but the saving in storage does not seem worth the
;; # effort it would take). There are twice as many female as male names
;; # in the abbreviated lists, apparently because of the many capricious
;; # spelling variants common for female names (e.g., Diane, Diann, Dianne,
;; # Dyann, Dyanne). The point of the reduction is to make this name list
;; # as useful as possible for guessing that a named entity names a female
;; # individual.
;;
(defparameter *female-names*
'(

 ABBEY ABBIE ABBY ABBYE ABIGAIL ADA ADALINE ADEL ADELA ADELAIDE ADELE
 ADELHEID ADELICE ADELINA ADELIND ADELINE ADELLA ADELLE ADENA ADEY ADI
 ADREA ADRIA ADRIANA ADRIANE ADRIANNA ADRIANNE ADRIENA ADRIENNE AG
 AGACE AGATA AGATHA AGATHE AGGI AGGIE AGGY AGNES AIDA AIDAN AILA AILE
 AILEE AILEEN AILENE AILEY AILI AILINA AILIS AILSUN AILYN AIMEE AINSLEY
 AINSLIE ALAINE ALAMEDA ALANA ALANAH ALANNA ALAYNE ALBINA ALECIA ALEDA
 ALEEN ALENA ALENE ALESSANDRA ALETA ALETHEA ALEXA ALEXANDRA ALFREDA
 ALFY ALI ALIA ALICA ALICE ALICEA ALICIA ALIDA ALIDIA ALIE ALIKA ALIKEE
 ALINA ALINE ALIS ALISA ALISHA ALISON ALISSA ALIZA ALLA ALLEEN ALLEGRA
 ALLENE ALLI ALLIE ALLINA ALLIS ALLISON ALLISSA ALLY ALLYCE ALLYN ALLYS
 ALLYSON ALMA ALMEDA ALMIRA ALOISE ALTA ALTHEA ALVERA ALVERTA ALVINA
 ALVINIA ALVIRA ALYCE ALYDA ALYS ALYSE ALYSON ALYSS ALYSSA AMALEA
 AMALEE AMALETA AMALIA AMALIE AMALITA AMANDA AMANDI AMANDIE AMANDY
 AMARA AMATA AMBER AMBERLY AMELIA AMELIE AMELINA AMELINE AMELITA AMI
 AMIE AMY ANA ANABAL ANABEL ANABELLA ANABELLE ANALIESE ANALISE
 ANASTASIA ANASTASIE ANASTASSIA ANDEE ANDEREA ANDI ANDIE ANDRA ANDREA
 ANDREANA ANDRIA ANDRIANA ANDRIETTE ANETT ANETTA ANETTE ANGE ANGEL
 ANGELA ANGELE ANGELIA ANGELICA ANGELIKA ANGELINA ANGELINE ANGELIQUE
 ANGELITA ANGELLE ANGIE ANGY ANIA ANICA ANISSA ANITA ANITRA ANJELA ANN
 ANN-MARIE ANNA ANNA-DIANA ANNA-DIANE ANNA-MARIA ANNABAL ANNABEL
 ANNABELA ANNABELL ANNABELLA ANNABELLE ANNALEE ANNALIESE ANNALISE
 ANNAMARIA ANNAMARIE ANNE ANNELIESE ANNELISE ANNEMARIE ANNETTA ANNETTE
 ANNI ANNICE ANNIE ANNIS ANNISSA ANNMARIA ANNMARIE ANTHEA ANTHIA
 ANTOINETTE ANTONELLA ANTONETTA ANTONIA ANTONIE ANTONIETTA ANTONINA
 ANYA APPOLONIA ARA ARABEL ARABELA ARABELE ARABELLA ARABELLE ARDELIS
 ARDELLA ARDELLE ARDEN ARDENE ARDENIA ARDINE ARDIS ARDYCE ARDYS ARDYTH
 ARETHA ARIADNE ARIANA ARIELA ARIELLA ARIELLE ARLANA ARLEE ARLEEN
 ARLENA ARLENE ARLETA ARLETTE ARLINA ARLINDA ARLINE ARLYNE ASHELY ASHIA
 ASHIEN ASHIL ASHLEE ASHLEIGH ASHLEY ASHLI ASHLIE ASHLY ASTRA ASTRID
 ASTRIX ATHENA ATHENE AUBREE AUBREY AUBRIE AUBRY AUDIE AUDREY AUDRIE
 AUDRY AUGUSTA AUGUSTE AURA AUREA AUREL AURELEA AURELIA AURELIE AURIA
 AURIE AVA AVELINE AVERIL AVERYL AVIE AVIS AVIVA AVIVAH AVRIL AYN BAB
 BABARA BABBETTE BABBIE BABETTE BAMBI BAMBIE BARB BARBARA BARBARA-ANNE
 BARBE BARBEE BARBETTE BARBI BARBIE BARBRA BARBY BASIA BATHSHEBA
 BATSHEVA BEA BEATRICE BEATRISA BEATRIX BECCA BECKI BECKIE BECKY BEE
 BEL BELIA BELICIA BELINDA BELITA BELL BELLA BELLE BELLINA BENEDETTA
 BENITA BENNI BENNIE BERGET BERNADENE BERNADETTE BERNADINA ;; BENNY (male)
 BERNADINE BERNARDINA BERNARDINE BERNI BERNICE BERRI ;; BERNIE BERNY (male)
 BERRIE BERTA BERTE BERTHA BERTHE BERTI BERTIE BERTINA BERTINE BERTY
 BERYL BERYLE BESS BESSIE BESSY BETH BETHANNE BETSEY BETSY BETTA BETTE
 BETTE-ANN BETTEANN BETTEANNE BETTI BETTINA BETTINE BETTY BETTYE BEULAH
 BEV BEVERLEE BEVERLEY BEVERLIE BEVERLY BEVVY BIANCA BIANKA BIBI BIDDIE
 BIDDY BIDGET BILLI BILLIE BIRGIT BIRGITTA BLAIRE ;; BLAIR BLAKE (male)
 BLAKELEE BLAKELEY BLANCA BLANCHE BLISS BLITHE BLONDIE BLONDY BLYTHE
 BOBBEE BOBBETTE BOBBI BOBBIE BOBETTE BOBINA BOBINE BOBINETTE BONITA
 BONNEE BONNI BONNIBELLE BONNIE BONNY BRANA BRANDAIS BRANDE BRANDEA
 BRANDI BRANDICE BRANDIE BRANDISE BRANDY BREANNE BREENA BRENDA BRENN
 BRENNA BRIA BRIANA BRIANNA BRIANNE BRIDGET BRIDGETTE BRIDIE BRIER
 BRIETTA BRIGID BRIGIDA BRIGIT BRIGITTA BRIGITTE BRINA BRITA BRITNEY
 BRITNI BRITT BRITTA BRITTAN BRITTANEY BRITTANI BRITTANY BRITTE
 BRITTENY BRITTNE BRITTNEY BRITTNI BROOKE BRUNHILDA BRUNHILDE BRYANA
 BRYN BRYNA BRYNN BRYNNA BRYNNE BUFFY BUNNI BUNNIE BUNNY CACILIA
 CACILIE CAITLIN CAM CAMELLIA CAMI CAMILA CAMILE CAMILLA CAMILLE CAMMI
 CAMMIE CAMMY CANDACE CANDI CANDICE CANDIDA CANDIDE CANDIE CANDIS
 CANDRA CANDY CARA CARALIE CAREN CARENA CARESA CARESSA CARESSE CAREY
 CARI CARIA CARIE CARIL CARILYN CARIN CARINA CARINE CARIOTTA CARISSA
 CARITA CARITTA CARLA CARLEE CARLEEN CARLEN CARLENE CARLEY CARLIE
 CARLIN CARLINA CARLINE CARLITA CARLOTA CARLOTTA CARLY CARLYE CARLYN
 CARLYNN CARLYNNE CARMA CARMEL CARMELA CARMELIA CARMELINA CARMELITA
 CARMELLA CARMELLE CARMEN CARMENCITA CARMINA CARMINE CARMITA CAROL
 CAROL-JEAN CAROLA CAROLAN CAROLANN CAROLE CAROLEE CAROLIN CAROLINA
 CAROLINE CAROLJEAN CAROLYN CAROLYNE CAROLYNN CARON CARREE CARRI CARRIE
 CARRISSA CARROLL CASANDRA CASEY CASIE CASS CASSANDRA CASSIE CASSY
 CATARINA CATE CATERINA CATHA CATHARINA CATHARINE CATHE CATHEE CATHERIN
 CATHERINA CATHERINE CATHI CATHIE CATHLEEN CATHLENE CATHRIN CATHRINE
 CATHRYN CATHY CATHYLEEN CATI CATIE CATINA CATLAINA CATLEE CATLIN
 CATRINA CATRIONA CATY CAYE CAYLA CECELIA CECILE CECILEY CECILIA
 CECILLA CECILY CEIL CELE CELENE CELESTA CELESTE CELESTIA CELESTINA
 CELESTINE CELESTYN CELESTYNA CELIA CELIE CELINA CELINDA CELINE CELINKA
 CELISSE CHANTAL CHANTALLE CHARIL CHARIN CHARIS CHARISSA CHARISSE
 CHARITA CHARLA CHARLEAN CHARLEEN CHARLENA CHARLENE CHARLINE CHARLOT
 CHARLOTTA CHARLOTTE CHARMAIN CHARMAINE CHARMINE CHARYL CHELSEA CHELSEY
 CHELSIE CHELSY CHER CHERE CHEREY CHERI CHERIANNE CHERICE CHERIDA
 CHERIE CHERILYN CHERILYNN CHERIN CHERISE CHERISH CHERLYN CHERRI
 CHERRITA CHERY CHERYE CHERYL CHESLIE CHIARRA CHICKIE CHICKY CHIQUIA
 CHIQUITA CHLO CHLOE CHLOETTE CHLORIS CHO-MAN CHRIS CHRISSIE CHRISSY
 CHRISTA CHRISTABEL CHRISTABELLA CHRISTAL CHRISTALLE CHRISTEL CHRISTEN
 CHRISTI CHRISTIANA CHRISTIANE CHRISTIE CHRISTIN CHRISTINA CHRISTINE
 CHRISTY CHRISTYE CHRISTYNA CHRYSA CHRYSTAL CHRYSTE CHRYSTEL CHUNG-HEE
 CICELY CICILY CINDA CINDEE CINDELYN CINDERELLA CINDI CINDIE CINDRA
 CINDY CISSY CLAIR CLAIRE CLARA CLARABELLE CLARE CLARESTA CLARETA
 CLARETTA CLARETTE CLAREY CLARI CLARIBEL CLARICE CLARIE CLARINDA
 CLARINE CLARISSA CLARISSE CLARITA CLARY CLAUDE CLAUDELLE CLAUDETTA
 CLAUDETTE CLAUDIA CLAUDIE CLAUDINA CLAUDINE CLEA CLEM CLEMENCE
 CLEMENTIA CLEMENTINA CLEMENTINE CLEMMIE CLEMMY CLEO CLEOPATRA CLERISSA
 CLIO CLO CLOE CLORIS CLOTILDA CLOVIS CODEE CODI CODIE COLEEN COLENE
 COLETTA COLETTE COLLEEN COLLEN COLLETE COLLETTE COLLIE COLLINE COLLY
 CONCETTINA CONCHITA CONNI CONNIE CONNY CONSOLATA CONSTANCE CONSTANCIA
 CONSTANCY CONSTANTA CONSTANTIA CONSTANTINA CONSTANTINE CONSUELA
 CONSUELO CORA CORABEL CORABELLA CORABELLE CORALIE CORALINE CORALYN
 CORDELIA CORDELIE CORDEY CORDI CORDIE CORDULA CORDY COREEN CORELLA
 CORENA CORENDA CORENE CORETTA CORETTE COREY CORI CORIE CORINA CORINE
 CORINNA CORINNE CORISS CORISSA CORLISS CORLY CORNELA CORNELIA CORNELLE
 CORNIE CORRENA CORREY CORRI CORRIANNE CORRIE CORRINA CORRINE CORRINNE
 CORRY CORTNEY CORY COSETTA COSETTE COSTANZA COURTENAY COURTNAY
 COURTNEY CRIS CRISSIE CRISSY CRISTA CRISTABEL CRISTAL CRISTEN CRISTI
 CRISTIE CRISTIN CRISTINA CRISTINE CRISTY CRYSTA CRYSTAL CRYSTIE CYB
 CYBIL CYBILL CYMBRE CYNDE CYNDI CYNDIA CYNDIE CYNDY CYNTHEA CYNTHIA
 CYNTHIE CYNTHY DACEY DACIA DACIE DACY DAFFI DAFFIE DAFFY DAGMAR DAHLIA
 DAILE DAISEY DAISI DAISIE DAISY DALE DALENNA DALIA DALILA DALORIS
 DAMARA DAMARIS DAMITA DANA DANELL DANELLA DANETTE DANI DANIA DANICA
 DANICE DANIELA DANIELE DANIELLA DANIELLE DANIKA DANILA DANIT DANITA
 DANNA DANNI DANNIE DANYA DANYELLE DANYETTE DAPHENE DAPHNA DAPHNE DARA
 DARB DARBIE DARBY DARCEE DARCEY DARCI DARCIE DARCY DARDA DAREEN
 DARELLE DARI DARIA DARICE DARLA DARLEEN DARLENE DARLINE DARLLEEN DARON
 DARRELLE DARRYL DARSEY DARSIE DARYA DARYL DARYN DASHA DASYA DAVEEN
 DAVETA DAVIDA DAVINA DAVINE DAVITA DAWN DAWNA DAYLE DAYNA DEANA DEANE
 DEANNA DEANNE DEB DEBBI DEBBIE DEBBY DEBEE DEBERA DEBI DEBOR DEBORA
 DEBORAH DEBRA DEDE DEDIE DEDRA DEE DEE-DEE DEEANN DEEANNE DEEDEE DEENA
 DEERDRE DEEYN DEHLIA DEIDRE DEINA DEIRDRE DELA DELCINA DELCINE DELIA
 DELILA DELILAH DELINDA DELLA DELLY DELORA DELORES DELORIA DELORIS
 DELPHINE DELPHINIA DENA DENI DENICE DENISE DENNA DENNI DENNIE DENYSE
 DEONNE DESDEMONA DESIREE DESIRI DEVA DEVAN DEVI DEVIN DEVINA DEVINNE
 DEVON DEVONDRA DEVONNA DEVONNE DEVORA DI DIANA DIANDRA DIANE
 DIANE-MARIE DIANEMARIE DIANN DIANNA DIANNE DIDI DIDO DIENA DIERDRE
 DINA DINAH DINNIE DINNY DION DIONE DIONIS DIONNE DITA DIX DIXIE DODI
 DODIE DODY DOE DOLLEY DOLLI DOLLIE DOLLY DOLORES DOLORITA DOLORITAS
 DOMENIGA DOMINGA DOMINICA DOMINIQUE DONA DONELLA DONELLE DONETTA DONIA
 DONICA DONIELLE DONNA DONNAJEAN DONNAMARIE DONNI DONNIE DONNY DORA
 DORALIA DORALIN DORALYN DORALYNN DORALYNNE DOREEN DORELIA DORELLA
 DORELLE DORENA DORENE DORETTA DORETTE DOREY DORI DORIA DORIAN DORICE
 DORIE DORINE DORIS DORISA DORISE DORITA DORO DOROLISA DOROTEA DOROTHEA
 DOROTHEE DOROTHY DORREE DORRI DORRIE DORRIS DORRY DORTHEA DORY DOSI
 DOTI DOTTI DOTTIE DOTTY DRUSIE DRUSILLA DRUSY DULCE DULCEA DULCI
 DULCIA DULCIANA DULCIE DULCINE DULCINEA DULCY DULSEA DYAN DYANA DYANE
 DYANN DYANNA DYANNE DYNA DYNAH EARTHA EBA EBBA EBONEE EBONY EDA EDDI
 EDEE EDELINE EDEN EDI EDIE EDIN EDITA EDITH EDITHA EDITHE EDIVA EDNA
 EDWINA EDY EDYTH EDYTHE EFFIE EILEEN EILIS EIMILE EIRENA EKATERINA
 ELAINA ELAINE ELANA ELANE ELAYNE ELBERTA ELBERTINA ELBERTINE ELEANOR
 ELEANORA ELEANORE ELECTRA ELEEN ELENA ELENE ELENI ELENORE ELEONORA
 ELEONORE ELFIE ELFREDA ELFRIDA ELFRIEDA ELGA ELIANORA ELIANORE ELICIA
 ELIE ELINOR ELINORE ELISA ELISABET ELISABETH ELISABETTA ELISE ELISHA
 ELISSA ELITA ELIZA ELIZABET ELIZABETH ELKA ELKE ELLA ELLADINE ELLE
 ELLEN ELLENE ELLETTE ELLI ELLIE ELLISSA ELLY ELLYN ELLYNN ELMIRA ELNA
 ELNORA ELNORE ELOISA ELOISE ELONORE ELORA ELSA ELSBETH ELSE ELSET
 ELSEY ELSI ELSIE ELSINORE ELSPETH ELSY ELVA ELVERA ELVINA ELVIRA
 ELWIRA ELYN ELYSE ELYSEE ELYSHA ELYSIA ELYSSA EMA EMALEE EMALIA EMELDA
 EMELIA EMELINA EMELINE EMELITA EMELYNE EMERA EMILEE EMILI EMILIA
 EMILIE EMILINE EMILY EMLYN EMLYNN EMLYNNE EMMA EMMALEE EMMALINE
 EMMALYN EMMALYNN EMMALYNNE EMMELINE EMMEY EMMI EMMIE EMMY EMOGENE
 EMYLE EMYLEE ENGRACIA ENID ENRICA ENRICHETTA ENRIKA ENRIQUETA EOLANDA
 EOLANDE EP EPPIE ERAN ERDA ERENA ERICA ERICHA ERICKA ERIKA ERIN ERINA
 ERINN ERINNA ERMA ERMENGARDE ERMENTRUDE ERMINA ERMINIA ERMINIE ERNA
 ERNALINE ERNESTA ERNESTINE ERTHA ERYN ESMA ESMARIA ESME ESMERALDA ESSA
 ESSIE ESSY ESTA ESTEL ESTELE ESTELL ESTELLA ESTELLE ESTER ESTHER
 ESTRELLA ESTRELLITA ETHEL ETHELDA ETTA ETTI ETTIE ETTY EUDORA EUGENIA
 EUGENIE EUGINE EULA EULALIE EUNICE EUPHEMIA EUSTACIA EVA EVALEEN
 EVANGELIA EVANGELINA EVANGELINE EVANIA EVANNE EVE EVELEEN EVELINA
 EVELINE EVELYN EVEY EVIE EVITA EVONNE EVVIE EVVY EVY EYDE EYDIE
 EZMERALDA FAE FAINA FAITH FANIA FANNI FANNIE FANNY FANYA FARA FARAH
 FARICA FARRA FARRAH FAUN FAUNIE FAUSTINA FAUSTINE FAWN FAWNE FAWNIA
 FAY FAYDRA FAYE FAYETTE FAYINA FAYRE FAYTH FAYTHE FEDERICA FEDORA
 FELECIA FELICIDAD FELICE FELICIA FELICITY FELIPA FELISHA FELITA FELIZA
 FENELIA FEODORA FERDINANDA FERDINANDE FERN FERNANDA FERNANDE
 FERNANDINA FERNE FEY FIANN FIANNA FIDELA FIDELIA FIDELITY FIFI FIFINE
 FILIA FILIDE FILIPPA FINA FIONA FIONNA FIONNULA FIORENZE FLEUR
 FLEURETTE FLO FLOR FLORA FLORANCE FLORE FLORELLA FLORENCE FLORENCIA
 FLORENTIA FLORENZA FLORETTE FLORI FLORIA FLORIDA FLORIE FLORINA
 FLORINDA FLORIS FLORRI FLORRIE FLORRY FLORY FLOSSI FLOSSIE FLOSSY FRAN
 FRANCENE FRANCES FRANCESCA FRANCINE FRANCISCA FRANCISKA FRANCOISE
 FRANCYNE FRANKIE FRANNI FRANNIE FRANNY FRAYDA FRED FREDA FREDELIA
 FREDERICA FREDERICKA FREDERIQUE FREDIA FREDRIKA FREIDA FRIEDA
 FRIEDERIKE FULVIA GABBEY GABBI GABBIE GABEY GABI GABIE GABRIELA
 GABRIELLA GABRIELLE GABRIELLIA GABRILA GABY GAE GAEL GAIL GALE GALE
 GALINA GARNETTE GAVRA GAVRIELLE GAYE GAYEL GAYLA GAYLE GAYLEEN GAYLENE
 GAYNOR GELYA GENA GENEVA GENEVIEVE GENEVRA GENIA GENNA GENNI GENNIE
 GENNIFER GENNY GENOVERA GENVIEVE GEORGEANNA GEORGEANNE GEORGENA
 GEORGETA GEORGETTA GEORGETTE GEORGIANA GEORGIANNA GEORGIANNE GEORGIE
 GEORGINA GEORGINE GERALDA GERALDINE GERDA GERHARDINE GERI GERIANNA
 GERIANNE GERLADINA GERMAIN GERMAINE GERMANA GERRI GERRIE GERRILEE GERT
 GERTA GERTI GERTIE GERTRUD GERTRUDA GERTRUDE GERTY GIACINTA GIANA
 GIANINA GIANNA GIGI GILBERTA GILBERTINA GILBERTINE GILDA GILL GILLAN
 GILLI GILLIAN GILLIE GILLIGAN GILLY GINA GINELLE GINEVRA GINGER GINNI
 GINNIE GINNIFER GINNY GIORGIA GIOVANNA GIPSY GIRALDA GISELA GISELE
 GISELLA GISELLE GIUDITTA GIULIA GIULIETTA GIUSTINA GIZELA GLAD GLADI
 GLADYS GLEDA GLEN GLENDA GLENNA GLENNIE GLENNIS GLORI GLORIA GLORIANA
 GLORIANE GLORY GLYN GLYNDA GLYNIS GLYNNIS GODIVA GOLDA GOLDARINA GOLDI
 GOLDIA GOLDIE GOLDINA GOLDY GRACE GRACIA GRACIE GRATA GRATIA GRATIANA
 GRAYCE GRAZIA GRETA GRETAL GRETCHEN GRETE GRETEL GRETHEL GRETNA GRETTA
 GRISELDA GRISSEL GUENDOLEN GUENEVERE GUENNA GUI GUILLEMA GUILLEMETTE
 GUINEVERE GUINNA GUNILLA GUSELLA GUSSI GUSSIE GUSSY GUSTA GUSTI GUSTIE
 GUSTY GWEN GWENDOLEN GWENDOLIN GWENDOLYN GWENETH GWENETTE GWENNETH
 GWENNI GWENNIE GWENNY GWENORA GWENORE GWYN GWYNETH GWYNNE GYPSY HADRIA
 HALEIGH HALETTE HANA HANNA HANNAH HANNI HANNIE HANNIS HANNY HAPPY
 HARLENE HARLEY HARLI HARLIE HARMONIA HARMONIE HARMONY HARRI HARRIE
 HARRIET HARRIETT HARRIETTA HARRIETTE HARRIOT HARRIOTT HATTI HATTIE
 HATTY HAYLEY HAZEL HEATH HEATHER HEDA HEDDA HEDDI HEDDIE HEDI HEDVIG
 HEDVIGE HEDWIG HEDWIGA HEDY HEIDA HEIDI HEIDIE HELAINA HELAINE HELEN
 HELEN-ELIZABETH HELENA HELENE HELENKA HELGA HELGE HELLI HELOISE HELSA
 HELYN HENDRIKA HENKA HENRIE HENRIETA HENRIETTA HENRIETTE HENRYETTA
 HERMIA HERMINA HERMINE HERMINIA HERMIONE HERTA HERTHA HESTER HESTHER
 HESTIA HETTI HETTIE HETTY HILARY HILDA HILDAGARD HILDAGARDE HILDE
 HILDEGAARD HILDEGARDE HILDY HILLARY HILLIARY HINDA HOLLI HOLLIE HOLLY
 HOLLY-ANNE HOLLYANNE HONORIA HOPE HORATIA HORTENSE HORTENSIA HULDA
 HYACINTH HYACINTHA HYACINTHE HYACINTHIA HYACINTHIE IDA IDALIA IDALINA
 IDALINE IDELL IDELLE IDETTE ILEANA ILEANE ILENE ILISE ILKA ILLA ILSA
 ILSE ILYSA ILYSE ILYSSA IMELDA IMOGEN IMOGENE IMOJEAN INA INDIRA INES
 INESITA INESSA INEZ INGA INGABERG INGABORG INGE INGEBERG INGEBORG
 INGRID INGUNNA INNA IOLANDE IOLANTHE IONA IORMINA IRENA IRENE IRINA
 IRIS IRITA IRMA ISA ISABEAU ISABEL ISABELITA ISABELLA ISABELLE ISADORA
 ISAHELLA ISEABAL ISIDORA ISIS ISOBEL ISSI ISSIE ISSY IVETT IVETTE IVIE
 IVONNE IZABEL JACENTA JACINDA JACINTA JACINTHA JACINTHE JACKELYN JACKI
 JACKIE JACKLIN JACKLYN JACKQUELIN JACKQUELINE JACKY JACLIN JACLYN
 JACQUELIN JACQUELINE JACQUELYN JACQUELYNN JACQUETTA JACQUETTE JACQUI
 JACQUIE JADA JADE JAIMIE JAINE JAMI JAMIE JAMIMA JAMMIE JAN JANA
 JANAYA JANAYE JANDY JANE JANEAN JANEEN JANEL JANELA JANELLA JANELLE
 JANENE JANENNA JANESSA JANET JANETA JANETTA JANETTE JANEVA JANEY JANIA
 JANICE JANIE JANIFER JANINA JANINE JANIS JANITH JANKA JANNA JANNEL
 JANNELLE JANOT JANY JAQUELIN JAQUELYN JAQUENETTA JAQUENETTE JAQUITH
 JASMIN JASMINA JASMINE JAYME JAYMEE JAYNE JAYNELL JAZMIN JEAN JEANA
 JEANE JEANELLE JEANETTE JEANIE JEANINE JEANNA JEANNE JEANNETTE JEANNIE
 JEANNINE JEHANNA JELENE JEMIE JEMIMA JEMIMAH JEMMIE JEMMY JEN JENA
 JENDA JENELLE JENI JENICA JENIECE JENIFER JENIFFER JENILEE JENINE JENN
 JENNA JENNEE JENNETTE JENNI JENNICA JENNIE JENNIFER JENNILEE JENNINE
 JENNY JERALEE JERE JERI JERMAINE JERRIE JERRILEE JERRILYN JERRINE
 JERRYLEE JESS JESSA JESSALIN JESSALYN JESSAMINE JESSAMYN JESSELYN
 JESSI JESSICA JESSIE JESSIKA JESSY JEWEL JEWELL JEWELLE JILL JILLANA
 JILLANE JILLAYNE JILLEEN JILLENE JILLI JILLIAN JILLIE JILLY JINNY JO
 JO ANN JO-ANN JO-ANNE JOAN JOANA JOANE JOANIE JOANN JOANNA JOANNE
 JOBEY JOBI JOBIE JOBINA JOBY JOBYE JOBYNA JOCELIN JOCELINE JOCELYN
 JOCELYNE JODEE JODI JODIE JODY JOEANN JOELA JOELIE JOELLA JOELLE
 JOELLEN JOELLY JOELLYN JOELYNN JOETE JOHANNA JOHANNAH JOJO JOLEE
 JOLEEN JOLENE JOLETTA JOLI JOLIE JOLINE JOLY JOLYN JOLYNN JONELL JONI
 JONIE JONIS JORDAIN JORDAN JORDANA JORDANNA JOREY JORI JORIE JORRIE
 JORRY JOSCELIN JOSEE JOSEFA JOSEFINA JOSEPHA JOSEPHINA JOSEPHINE JOSEY
 JOSI JOSIE JOSSELYN JOSY JOY JOYA JOYAN JOYANN JOYCE JOYCELIN JOYE
 JOYOUS JUANA JUANITA JUDI JUDIE JUDITH JUDITHA JUDY JUDYE JUIETA JULEE
 JULI JULIA JULIANA JULIANE JULIANN JULIANNA JULIANNE JULIE JULIENNE
 JULIET JULIETA JULIETTA JULIETTE JULINA JULINE JULISSA JULITA JUNETTE
 JUNIA JUNIE JUNINA JUSTINA JUSTINE JUSTINN JYOTI KACEY KACIE KACY
 KAELA KAI KAIA KAILA KAILE KAILEY KAITLIN KAITLYN KAITLYNN KAJA
 KAKALINA KALA KALEENA KALI KALIE KALILA KALINA KALINDA KALINDI KALLI
 KALLY KAMEKO KAMILA KAMILAH KAMILLAH KANDACE KANDY KANIA KANYA KARA
 KARA-LYNN KARALEE KARALYNN KAREE KAREN KARENA KARI KARIA KARIE KARIL
 KARILYNN KARIN KARINA KARINE KARIOTTA KARISA KARISSA KARITA KARLA
 KARLEE KARLEEN KARLEN KARLENE KARLIE KARLOTTA KARLOTTE KARLY KARLYN
 KARMEN KARNA KAROLA KAROLE KAROLINA KAROLINE KAROLY KARON KARRAH
 KARRIE KARRY KARY KARYL KARYLIN KARYN KASEY KASS KASSANDRA KASSEY
 KASSI KASSIA KASSIE KAT KATA KATALIN KATE KATEE KATERINA KATERINE
 KATEY KATH KATHA KATHARINA KATHARINE KATHARYN KATHE KATHERINA
 KATHERINE KATHERYN KATHI KATHIE KATHLEEN KATHLIN KATHRINE KATHRYN
 KATHRYNE KATHY KATHYE KATI KATIE KATINA KATINE KATINKA KATLEEN KATLIN
 KATRINA KATRINE KATRINKA KATTI KATTIE KATUSCHA KATUSHA KATY KATYA KAY
 KAYCEE KAYE KAYLA KAYLE KAYLEE KAYLEY KAYLIL KAYLYN KEELEY KEELIA
 KEELY KELCEY KELCI KELCIE KELCY KELILA KELLEN KELLEY KELLI KELLIA
 KELLIE KELLINA KELLSIE KELLY KELLYANN KELSEY KELSI KELSY KENDRA KENDRE
 KENNA KERI KERIANN KERIANNE KERRI KERRIE KERRILL KERRIN KERRY KERSTIN
 KESLEY KESLIE KESSIA KESSIAH KETTI KETTIE KETTY KEVINA KEVYN KIAH KIAL
 KIELE KIERSTEN KIKELIA KILEY KIM KIMBERLEE KIMBERLEY KIMBERLI KIMBERLY
 KIMBERLYN KIMBRA KIMMI KIMMIE KIMMY KINNA KIP KIPP KIPPIE KIPPY KIRA
 KIRBEE KIRBIE KIRBY KIRI KIRSTEN KIRSTENI KIRSTI KIRSTIN KIRSTYN
 KISSEE KISSIAH KISSIE KIT KITTI KITTIE KITTY KIZZEE KIZZIE KLARA
 KLARIKA KLARRISA KONSTANCE KONSTANZE KOO KORA KORAL KORALLE KORDULA
 KORE KORELLA KOREN KORESSA KORI KORIE KORRIE KORRY KRIS KRISSIE KRISSY
 KRISTA KRISTAL KRISTAN KRISTE KRISTEL KRISTEN KRISTI KRISTIEN KRISTIN
 KRISTINA KRISTINE KRISTY KRISTYN KRYSTA KRYSTAL KRYSTALLE KRYSTLE
 KRYSTYNA KYLA KYLE KYLEN KYLIE KYLILA KYLYNN KYM KYRSTIN LURETTE
 LAVERNE LACEE LACEY LACIE LACY LADONNA LAETITIA LAINA LAINEY LANA
 LANAE LANE LANETTE LANEY LANI LANIE LANITA LANNA LANNI LANNY LARA
 LARAINE LARI LARINA LARINE LARISA LARISSA LARK LARYSSA LATASHIA LATIA
 LATISHA LAURA LAURAINE LAURAL LAURALEE LAURE LAUREE LAUREEN LAURELLA
 LAUREN LAURENA LAURENE LAURETTA LAURETTE LAURI LAURIANNE LAURICE
 LAURIE LAURYN LAVENA LAVERNA LAVERNE LAVINA LAVINIA LAVINIE LAYLA
 LAYNE LAYNEY LEA LEAH LEANDRA LEANN LEANNA LEANOR LEANORA LEBBIE LEDA
 LEE LEEANN LEEANNE LEELA LEELAH LEENA LEESA LEESE LEGRA LEIA LEIGH
 LEIGHA LEILA LEILAH LEISHA LELA LELAH LELAND LELIA LENA LENEE LENETTE
 LENKA LENNA LENORA LENORE LEODORA LEOINE LEOLA LEOLINE LEONA LEONANIE
 LEONE LEONELLE LEONIE LEONORA LEONORE LEONTINE LEONTYNE LEORA LESHIA
 LESLEY LESLI LESLIE LESLY LESYA LETA LETHIA LETICIA LETISHA LETITIA
 LETIZIA LETTA LETTI LETTIE LETTY LEXI LEXIE LEXINE LEXIS LEXY LEYLA
 LEZLIE LIA LIAN LIANA LIANE LIANNA LIANNE LIB LIBBEY LIBBI LIBBIE
 LIBBY LICHA LIDA LIDIA LIESA LIL LILA LILAH LILAS LILIA LILIAN LILIANE
 LILIAS LILITH LILLA LILLI LILLIAN LILLY LILY LILYAN LIN LINA LIND
 LINDA LINDI LINDIE LINDSAY LINDSEY LINDSY LINDY LINEA LINELL LINET
 LINETTE LINN LINNEA LINNELL LINNET LINNIE LINZY LIRA LISA LISABETH
 LISBETH LISE LISETTA LISETTE LISHA LISHE LISSA LISSI LISSIE LISSY LITA
 LIUKA LIV LIVA LIVIA LIVVIE LIVVY LIVVYY LIVY LIZ LIZA LIZABETH
 LIZBETH LIZETTE LIZZIE LIZZY LOELLA LOIS LOISE LOLA LOLETA LOLITA
 LOLLY LONA LONEE LONI LONNA LONNI LONNIE LORA LORAIN LORAINE LORALEE
 LORALIE LORALYN LOREE LOREEN LORELEI LORELLE LOREN LORENA LORENE
 LORENZA LORETTA LORETTALORNA LORETTE LORI LORIA LORIANNA LORIANNE
 LORIE LORILEE LORILYN LORINDA LORINE LORITA LORNA LORNE LORRAINE
 LORRAYNE LORRI LORRIE LORRIN LORRY LORY LOTTA LOTTE LOTTI LOTTIE LOTTY
 LOUELLA LOUISA LOUISE LOUISETTE LOUTITIA LUCI LUCIA LUCIANA LUCIE
 LUCIENNE LUCILA LUCILIA LUCILLE LUCINA LUCINDA LUCINE LUCITA LUCRETIA
 LUCY LUDOVIKA LUELLA LUELLE LUISA LUISE LULA LULITA LULU LURA LURETTE
 LURLEEN LURLENE LURLINE LUSA LUZ LYDA LYDIA LYDIE LYN LYNDA LYNDE
 LYNDEL LYNDELL LYNDSAY LYNDSEY LYNDSIE LYNDY LYNEA LYNELLE LYNETT
 LYNETTE LYNN LYNNA LYNNE LYNNEA LYNNELL LYNNELLE LYNNET LYNNETT
 LYNNETTE LYNSEY LYSSA MABEL MABELLE MABLE MADA MADALENA MADALYN
 MADDALENA MADDI MADDIE MADDY MADEL MADELAINE MADELEINE MADELENA
 MADELENE MADELIN MADELINA MADELINE MADELLA MADELLE MADELON MADELYN
 MADGE MADLEN MADLIN MADONNA MADY MAE MAEGAN MAG MAGDA MAGDAIA MAGDALEN
 MAGDALENA MAGDALENE MAGGEE MAGGI MAGGIE MAGGY MAHALA MAHALIA MAIA
 MAIBLE MAIGA MAIGHDILN MAIR MAIRE MAISEY MAISIE MAITILDE MALA MALANIE
 MALENA MALIA MALINA MALINDA MALINDE MALISSA MALISSIA MALLISSA MALLORIE
 MALLORY MALORIE MALORY MALVA MALVINA MALYNDA MAMIE MANDA MANDI MANDIE
 MANDY MANON MANYA MARA MARABEL MARCELA MARCELIA MARCELLA MARCELLE
 MARCELLINA MARCELLINE MARCHELLE MARCI MARCIA MARCIE MARCILE MARCILLE
 MARCY MAREAH MAREN MARENA MARESSA MARGA MARGALIT MARGALO MARGARET
 MARGARETA MARGARETE MARGARETHA MARGARETHE MARGARETTA MARGARETTE
 MARGARITA MARGAUX MARGE MARGEAUX MARGERY MARGET MARGETTE MARGI MARGIE
 MARGIT MARGO MARGOT MARGRET MARGUERITE MARGY MARI MARIA MARIAM MARIAN
 MARIANA MARIANN MARIANNA MARIANNE MARIBEL MARIBELLE MARIBETH MARICE
 MARIDEL MARIE MARIE-ANN MARIE-JEANNE MARIEANN MARIEJEANNE MARIEL
 MARIELE MARIELLE MARIELLEN MARIETTA MARIETTE MARIGOLD MARIJO MARIKA
 MARILEE MARILIN MARILLIN MARILYN MARIN MARINA MARINNA MARION
 MARIQUILLA MARIS MARISA MARISKA MARISSA MARITA MARITSA MARIYA MARJ
 MARJA MARJE MARJI MARJIE MARJORIE MARJORY MARJY MARKETA MARLA MARLANE
 MARLEAH MARLEE MARLEEN MARLENA MARLENE MARLEY MARLIE MARLINE MARLO
 MARLYN MARNA MARNE MARNEY MARNI MARNIA MARNIE MARQUITA MARRILEE MARRIS
 MARRISSA MARSHA MARSIELLA MARTA MARTELLE MARTHA MARTHE MARTHENA MARTI
 MARTICA MARTIE MARTINA MARTITA MARTIZA MARTY MARTYNNE MARY MARYA
 MARYANN MARYANNA MARYANNE MARYBELLE MARYBETH MARYELLEN MARYJANE MARYJO
 MARYL MARYLEE MARYLIN MARYLINDA MARYLOU MARYLYNNE MARYROSE MARYS
 MARYSA MASHA MATELDA MATHILDA MATHILDE MATILDA MATILDE MATTI MATTIE
 MATTY MAUD MAUDE MAUDIE MAURA MAURE MAUREEN MAUREENE MAURENE MAURINE
 MAURISE MAURITA MAURIZIA MAVIS MAVRA MAXI MAXIE MAXINE MAXY MAYBELLE
 MAYE MAZA MEAD MEADE MEAGAN MEAGHAN MEARA MECHELLE MEG MEGAN MEGEN
 MEGGI MEGGIE MEGGY MEGHAN MEGHANN MEHETABEL MEI MEL MELA MELAMIE
 MELANIA MELANIE MELANTHA MELANY MELBA MELESA MELESSA MELICENT MELINA
 MELINDA MELINDE MELISA MELISANDE MELISANDRA MELISENDA MELISENT MELISSA
 MELISSE MELITA MELITTA MELLA MELLI MELLICENT MELLIE MELLISA MELLISENT
 MELLONEY MELLY MELODEE MELODIE MELODY MELONIE MELONY MELOSA MELVA
 MEREDITH MEREDITHE MERIDEL MERIDITH MERIEL MERILEE MERILYN MERIS
 MERISSA MERLA MERLE MERLINA MERLINE MERNA MEROLA MERRALEE MERRIDIE
 MERRIE MERRIELLE MERRILE MERRILEE MERRILI MERRILL MERRILY MERSEY MERYL
 META MIA MICAELA MICHAELA MICHAELINA MICHAELINE MICHAELLA MICHELE
 MICHELINA MICHELINE MICHELLE MICKI MICKIE MICKY MIDGE MIGNON MIGNONNE
 MIGUELA MIGUELITA MIKAELA MIL MILDRED MILDRID MILENA MILICENT
 MILISSENT MILKA MILLI MILLICENT MILLIE MILLISENT MILLY MILZIE MIMI
 MINA MINDA MINDY MINERVA MINETTA MINETTE MINNA MINNE MINNI MINNIE
 MINNY MINTA MIQUELA MIRA MIRABEL MIRABELLA MIRABELLE MIRAN MIRANDA
 MIREIELLE MIREILLE MIRELLA MIRELLE MIRIAM MIRILLA MIRNA MISHA MISSIE
 MISSY MISTI MISTY MITZI MODESTA MODESTIA MODESTINE MODESTY MOINA MOIRA
 MOLL MOLLEE MOLLI MOLLIE MOLLY MONA MONAH MONICA MONIKA MONIQUE MORA
 MOREEN MORENA MORGAN MORGANA MORGANICA MORGANNE MORGEN MORIA MORISSA
 MORNA MOSELLE MOYNA MOYRA MOZELLE MUFFIN MUFI MUFINELLA MUIRE MUREIL
 MURIAL MURIEL MURIELLE MYRA MYRAH MYRANDA MYRIAM MYRILLA MYRLE MYRLENE
 MYRNA MYRTA MYRTIA MYRTICE MYRTIE MYRTLE NADA NADEAN NADEEN NADIA
 NADINE NADIYA NADY NADYA NALANI NAN NANA NANANNE NANCE NANCEE NANCEY
 NANCI NANCIE NANCY NANETE NANETTE NANI NANICE NANINE NANNETTE NANNI
 NANNIE NANNY NANON NAOMA NAOMI NARA NARI NARIKO NATA NATALA NATALEE
 NATALIE NATALINA NATALINE NATALYA NATASHA NATASSIA NATHALIA NATHALIE
 NATIVIDAD NATKA NATTY NEALA NEDA NEDDA NEDI NEELY NEILA NEILLA NEILLE
 NELIA NELIE NELL NELLE NELLI NELLIE NELLY NERISSA NERITA NERT NERTA
 NERTI NERTIE NERTY NESSA NESSI NESSIE NESSY NESTA NETTA NETTI NETTIE
 NETTLE NETTY NEVSA NEYSA NICHOLE NICHOLLE NICKI NICKIE NICKY NICOLA
 NICOLE NICOLEA NICOLETTE NICOLI NICOLINA NICOLINE NICOLLE NIKANIKI
 NIKI NIKKI NIKKIE NIKOLETTA NIKOLIA NINA NINETTA NINETTE NINNETTA
 NINNETTE NINON NISSA NISSE NISSIE NISSY NITA NIXIE NOAMI NOELANI NOELL
 NOELLA NOELLE NOELLYN NOELYN NOEMI NOLA NOLANA NOLIE NOLLIE NOMI NONA
 NONAH NONI NONIE NONNA NONNAH NORA NORAH NOREAN NOREEN NORENE NORINA
 NORINE NORMA NORRI NORRIE NORRY NOVELIA NYDIA NYSSA OCTAVIA ODELE
 ODELIA ODELINDA ODELLA ODELLE ODESSA ODETTA ODETTE ODILIA ODILLE
 OFELIA OFELLA OFILIA OLA OLENKA OLGA OLIA OLIMPIA OLIVE OLIVETTE
 OLIVIA OLIVIE OLIY OLLIE OLLY OLVA OLWEN OLYMPE OLYMPIA OLYMPIE ONDREA
 ONEIDA ONIDA OONA OPAL OPALINA OPALINE OPHELIA OPHELIE ORA ORALEE
 ORALIA ORALIE ORALLA ORELEE ORELIA ORELIE ORELLA ORELLE ORIANA ORLY
 ORSA ORSOLA ORTENSIA OTHA OTHELIA OTHELLA OTHILIA OTHILIE OTTILIE
 PALOMA PAM PAMELA PAMELINA PAMELLA PAMMI PAMMIE PAMMY PANDORA PANSIE
 PANSY PAOLA PAOLINA PAPAGENA PAT PATRICA PATRICIA PATRIZIA PATSY PATTI
 PATTIE PATTY PAULA PAULE PAULETTA PAULETTE PAULI PAULIE PAULINA
 PAULINE PAULITA PAULY PAVIA PAVLA PEG PEGEEN PEGGI PEGGIE PEGGY
 PENELOPA PENELOPE PENNI PENNIE PENNY PEPI PEPITA PERI PERIA PERL PERLA
 PERLE PERRI PERRINE PERRY PERSIS PETA PETRA PETRINA PETRONELLA
 PETRONIA PETRONILLA PETRONILLE PETUNIA PHAEDRA PHAIDRA PHEBE PHEDRA
 PHELIA PHILIPA PHILIPPA PHILIPPE PHILIPPINE PHILIS PHILLIDA PHILLIE
 PHILLIS PHILLY PHILOMENA PHOEBE PHYLIS PHYLLIDA PHYLLIS PHYLLYS PHYLYS
 PIA PIERETTE PIERRETTE PIETRA PIPPA PIPPY POLLY POLLYANNA PORTIA PRIS
 PRISCA PRISCELLA PRISCILLA PRISSIE PRUDENCE PRUDI PRUDY PRUE QUEENIE
 QUERIDA QUINTA QUINTANA QUINTILLA QUINTINA RACHAEL RACHEL RACHELE
 RACHELLE RAEANN RAFA RAFAELA RAFAELIA RAFAELITA RAHAL RAHEL RAINA
 RAINE RAKEL RALINA RAMONA RAMONDA RANA RANDA RANDEE RANDENE RANDI
 RANDIE RANDY RANEE RANI RANIA RANICE RANIQUE RANNA RAPHAELA RAQUEL
 RAQUELA RASIA RASLA RAVEN RAYCHEL RAYNA RAYNELL RAYSHELL REA REBA
 REBBECCA REBE REBECA REBECCA REBECKA REBEKA REBEKAH REBEKKAH REE REEBA
 REENA REETA REEVA REGAN REGGI REGGIE REGINA REGINE REIKO REINA REINE
 REMY RENA RENAE RENATA RENATE RENEE RENELL RENELLE RENIE RENNIE RETA
 RETHA REVKAH REYNA RHEA RHEBA RHETA RHETTA RHIAMON RHIANNA RHIANON
 RHODA RHODIA RHODIE RHODY RHONA RHONDA RIANE RIANNON RIANON RICA RICCA
 RICI RICKI RICKIE RICKY RIKI RIKKI RINA RISA RITA RIVA RIVALEE RIVI
 RIVKAH RIVY ROANA ROANNA ROANNE ROBBI ROBBIE ROBBIN ROBBY ROBBYN
 ROBENA ROBENIA ROBERTA ROBIN ROBINA ROBINET ROBINETT ROBINETTA
 ROBINETTE ROBINIA ROBY ROBYN ROCHELL ROCHELLA ROCHELLE ROCHETTE RODA
 RODI RODIE RODINA ROIS ROMOLA ROMONA ROMONDA ROMY RONA RONALDA RONDA
 RONICA RONNA RONNI RONNICA RONNIE RONNY RORA RORI RORIE RORY ROS ROSA
 ROSABEL ROSABELLA ROSABELLE ROSALEEN ROSALIA ROSALIE ROSALIND
 ROSALINDA ROSALINDE ROSALINE ROSALYN ROSALYND ROSAMOND ROSAMUND ROSANA
 ROSANNA ROSANNE ROSE ROSEANN ROSEANNA ROSEANNE ROSELIA ROSELIN
 ROSELINE ROSELLA ROSELLE ROSEMARIA ROSEMARIE ROSEMARY ROSEMONDE ROSENE
 ROSETTA ROSETTE ROSHELLE ROSIE ROSINA ROSITA ROSLYN ROSMUNDA ROSY
 ROWENA ROXANA ROXANE ROXANNA ROXANNE ROXI ROXIE ROXINE ROXY ROZ
 ROZALIE ROZALIN ROZAMOND ROZANNA ROZANNE ROZE ROZELE ROZELLA ROZELLE
 ROZINA RUBETTA RUBI RUBIA RUBIE RUBINA RUBY RUPERTA RUTH RUTHANN
 RUTHANNE RUTHI RUTHIE RUTHY RYANN RYCCA SABA SABINA SABINE SABRA
 SABRINA SACHA SADA SADELLA SADIE SADYE SAIDEE SAL SALAIDH SALLEE SALLI
 SALLIE SALLY SALLYANN SALLYANNE SALOMA SALOME SALOMI SAMANTHA SAMARA
 SAMARIA SANDI SANDIE SANDRA SANDY SANDYE SAPPHIRA SAPPHIRE SARA
 SARA-ANN SARAH SARAJANE SAREE SARENA SARENE SARETTE SARI SARINA SARINE
 SARITA SASHENKA SAUDRA SAUNDRA SAVINA SAYRE SCARLET SCARLETT SEAN
 SEANA SEKA SELA SELENA SELENE SELESTINA SELIA SELIE SELINA SELINDA
 SELINE SELLA SELLE SELMA SENA SEPHIRA SERENA SERENE SHAE SHAINA SHAINE
 SHALNA SHALNE SHANA SHANDA SHANDEE SHANDEIGH SHANDIE SHANDRA SHANDY
 SHANE SHANI SHANIE SHANNA SHANNAH SHANNEN SHANNON SHANON SHANTA
 SHANTEE SHARA SHARAI SHARI SHARIA SHARITY SHARL SHARLA SHARLEEN
 SHARLENE SHARLINE SHARON SHARONA SHARRON SHARYL SHAUN SHAUNA SHAWN
 SHAWNA SHAWNEE SHAY SHAYLA SHAYLAH SHAYLYN SHAYLYNN SHAYNA SHAYNE SHEA
 SHEBA SHEELA SHEELAGH SHEELAH SHEENA SHEEREE SHEILA SHEILA-KATHRYN
 SHEILAH SHEILAKATHRYN SHEL SHELA SHELAGH SHELBA SHELBI SHELBY SHELIA
 SHELLEY SHELLI SHELLIE SHELLY SHENA SHER SHEREE SHERI SHERIE SHERILL
 SHERILYN SHERLINE SHERRI SHERRIE SHERRY SHERYE SHERYL SHINA SHINEAD 
 SHIR SHIRL SHIRLEE SHIRLEEN SHIRLENE SHIRLEY SHIRLINE SHOSHANA SHOSHANNA 
 SIANA SIANNA SIB SIBBIE SIBBY SIBEAL SIBEL SIBELLA SIBELLE SIBILLA SIBYL
 SIBYLLA SIBYLLE SIDONEY SIDONIA SIDONNIE SIGRID SILEAS SILVA SILVANA
 SILVIA SILVIE SIMONA SIMONE SIMONETTE SIMONNE SINDEE SIOBHAN SISELY
 SISILE SISSIE SISSY SIUSAN SOFIA SOFIE SONDRA SONIA SONJA SONNI SONNIE
 SONNY SONYA SOPHEY SOPHI SOPHIA SOPHIE SOPHRONIA SORCHA SOSANNA STACEE
 STACEY STACI STACIA STACIE STACY STAFANI STARLA STARLENE STARLIN STEFA
 STEFANIA STEFANIE STEFFANE STEFFI STEFFIE STELLA STEPHA STEPHANA
 STEPHANI STEPHANIE STEPHANNIE STEPHENIE STEPHI STEPHIE STEPHINE STESHA
 STEVANA STEVENA STODDARD STORMI STORMIE SUE SUELLEN SUKEY SUKI SULA
 SUNNY SUSAN SUSANA SUSANETTA SUSANN SUSANNA SUSANNAH SUSANNE SUSETTE
 SUSI SUSIE SUSY SUZANN SUZANNA SUZANNE SUZETTE SUZI SUZIE SUZY SYBIL
 SYBILA SYBILLA SYBILLE SYBYL SYDEL SYDELLE SYDNEY SYLVIA TABATHA
 TABBATHA TABBI TABBIE TABBITHA TABINA TABITHA TALIA TALLIA TALLIE
 TALLOU TALLULAH TALLY TALYA TALYAH TAMAR TAMARA TAMARAH TAMARRA TAMERA
 TAMI TAMIKO TAMMA TAMMARA TAMMI TAMMIE TAMMY TAMQRAH TAMRA TANA TANDI
 TANDIE TANDY TANHYA TANI TANIA TANSY TANYA TARA TARAH TARRA TARRAH
 TARYN TASHA TASIA TATE TATIANA TATIANIA TATUM TAWNYA TAWSHA TEDDA
 TEDDI TEDI TEDRA TEENA TEIRTZA TEODORA TERA TERESA TERESE TERESINA
 TERESITA TERESSA TERI TERIANN TERRA TERRI TERRI-JO TERRIE TERRIJO
 TERRY TERRYE TERSINA TERZA TESS TESSA TESSI TESSIE TESSY THALIA THEA
 THEADORA THEDA THEKLA THELMA THEODORA THEODOSIA THERESA THERESE
 THERESINA THERESITA THERESSA THERINE THIA THOMASA THOMASIN THOMASINA
 THOMASINE TIENA TIERNEY TIERTZA TIFF TIFFANI TIFFANIE TIFFANY TIFFI
 TIFFIE TIFFY TILDA TILDI TILDIE TILDY TILLIE TILLY TIMI TIMMI TIMMIE
 TIMMY TIMOTHEA TINA TIPHANI TIPHANIE TIPHANY TISH TISHA TOBEY TOBI
 TOBY TOBYE TOINETTE TOMA TOMASINA TOMASINE TOMI TOMMI TONI TONIA TONYA
 TONYE TOOTSIE TOREY TORI TORIE TORRIE TORY TOVA TOVE TRACEE TRACEY
 TRACI TRACIE TRACY TRENNA TRESA TRESCHA TRESSA TRICIA TRINA TRISH
 TRISHA TRISTA TRIX TRIXI TRIXIE TRIXY TRUDA TRUDE TRUDEY TRUDI TRUDIE
 TRUDY TRULA TWILA TWYLA TYBI TYBIE TYNE ULA ULLA ULRICA ULRIKA
 ULRIKAUMEKO ULRIKE UMEKO URSALA URSOLA URSULA URSULINA URSULINE UTA
 VAL VALAREE VALARIA VALE VALEDA VALENCIA VALENE VALENKA VALENTIA
 VALENTINA VALENTINE VALERA VALERIA VALERIE VALERY VALERYE VALIDA
 VALINA VALLI VALLIE VALLY VALMA VANDA VANESSA VANIA VANNA VANNI VANNIE
 VANNY VANYA VEDA VELMA VELVET VENITA VENUS VERA VERADIS VERE VERENA
 VERENE VERIEE VERILE VERINA VERINE VERLA VERNA VERNICE VERONICA
 VERONIKA VERONIKE VERONIQUE VEVAY VI VICKI VICKIE VICKY VICTORIA VIDA
 VIKI VIKKI VIKKY VILHELMINA VILMA VIN VINA VINITA VINNI VINNIE VINNY
 VIOLA VIOLANTE VIOLE VIOLET VIOLETTA VIOLETTE VIRGIE VIRGINA VIRGINIA
 VIRGINIE VITA VITIA VITORIA VITTORIA VIV VIVA VIVI VIVIA VIVIAN
 VIVIANA VIVIANNA VIVIANNE VIVIE VIVIEN VIVIENE VIVIENNE VIVIYAN VIVYAN
 VIVYANNE VONNI VONNIE VONNY VYKY WALLIS WANDA WANDIE WANDIS WANETA
 WANIDS WENDA WENDELINE WENDI WENDIE WENDY WENDYE WENONA WENONAH
 WHITNEY WILEEN WILHELMINA WILHELMINE WILIE WILLA WILLABELLA WILLAMINA
 WILLETTA WILLETTE WILLOW WILMA WILMETTE WILONA WILONE WILOW WINDY WINI
 WINIFRED WINNA WINNAH WINNE WINNI WINNIE WINNIFRED WINNY WINONA
 WINONAH WREN WRENNIE WYLMA WYNN WYNNE WYNNIE WYNNY XAVIERA XENA XENIA
 XYLIA XYLINA YALONDA YASMEEN YASMIN YELENA YETTA YETTIE YETTY YEVETTE
 YNES YNEZ YOKO YOLANDA YOLANDE YOLANE YOLANTHE YOSHI YOSHIKO YOVONNDA
 YSABEL YVETTE YVONNE ZABRINA ZAHARA ZANDRA ZANETA ZARA ZARAH ZARIA
 ZARLA ZEA ZELDA ZELMA ZENA ZENIA ZIA ZILVIA ZITA ZITELLA ZOE ZOLA
 ZONDA ZONDRA ZONNYA ZORA ZORAH ZORANA ZORINA ZORINE ZSA-ZSA ZSAZSA
 ZULEMA ZUZANA

))

