#include <cmath>
#include <stack>
#include <algorithm>
#include <ctime>
#include <unordered_set>

#include "graphparsing_1ec_n4_depparser.h"
#include "common/token/word.h"
#include "common/token/pos.h"


namespace graphparsing_1ec_n4{
	WordPOSTag DepParser::empty_taggedword = WordPOSTag();
	WordPOSTag DepParser::start_taggedword = WordPOSTag();
	WordPOSTag DepParser::end_taggedword = WordPOSTag();
	double time, ftime;
	int fsum;
	int totalerr, total;
	int totaledge = 0;
	int m_bgetgraph = 0;
	int cut0 = 0, cut1 = 0, cut2 = 0, cut3 = 0,maxd = 0;
	DepParser::DepParser(const std::string & sFeatureInput, const std::string & sFeatureOut, int nState) :
		DepParserBase(sFeatureInput, nState) {

		m_nSentenceLength = 0;
		time = ftime = 0;
		fsum = 0;
		m_Weight = new Weight(sFeatureInput, sFeatureOut);
		totaledge = totalmy = total = totalcor = 0;

		cut0 = cut1 = cut2 = cut3 = maxd = 0;
		DepParser::empty_taggedword.refer(TWord::code(EMPTY_WORD), TPOSTag::code(EMPTY_POSTAG));
		DepParser::start_taggedword.refer(TWord::code(START_WORD), TPOSTag::code(START_POSTAG));
		DepParser::end_taggedword.refer(TWord::code(END_WORD), TPOSTag::code(END_POSTAG));
	}

	DepParser::~DepParser() {
		delete m_Weight;
	}
	void DepParser::GetOneEndPointGraph(const DependencyGraph & correct) {

		m_setFirstGoldScore.clear();
		for (const auto & arc : correct.getGraph()) {
			//std::cout << EDGE_X(arc) << ' ' << EDGE_Y(arc) << std::endl;
			m_setFirstGoldScore.insert(BiGram<int>(EDGE_X(arc) == -1 ? m_nSentenceLength : EDGE_X(arc) , EDGE_Y(arc) ));
		}
		m_bgetgraph = 1;
		getTrainArcs();
		/*for (auto arc : m_vecTrainArcs)
			std::cout << arc << std::endl;*/
		m_bgetgraph = 0;

	}
	void DepParser::train(const DependencyGraph & correct, const int & round) {
		// initialize
		int idx = 0;
		time_t b, e;
		b = clock();
		m_vecCorrectArcs.clear();
		m_nTrainingRound = round;
		m_nSentenceLength = correct.getSentence().size();
		for (const auto & node : correct.getSentence()) {
			m_lSentence[++idx].refer(TWord::code(std::get<0>(node)), TPOSTag::code(std::get<1>(node)));
		}

		if (m_nState == ParserState::TRAIN){
			totaledge += correct.getGraph().size();
			GetOneEndPointGraph(correct);
			int d = correct.getGraph().size() - m_vecTrainArcs.size();
			switch (d)
			{
				case 0:	cut0++; break;
				case 1: cut1++; break;
				case 2: cut2++; break;
				default: cut3++;
			}
			maxd = std::max(maxd, d);

			for (const auto arc : m_vecTrainArcs)
			{
				m_vecCorrectArcs.push_back(arc);
			}
		}
		else if (m_nState == ParserState::GOLDTEST){
			for (const auto arc : correct.getGraph())
			{
				m_vecCorrectArcs.push_back( Arc(EDGE_X(arc), EDGE_Y(arc)) );
			}
		}
		total += m_vecCorrectArcs.size();

		m_vecDependencyTree = correct.getTree();
		work(nullptr, correct);
		time += clock() - b;
		if (m_nTrainingRound % OUTPUT_STEP == 0) {
			std::cout << "total time " << 0.001 * time << ' ' << ' ' << 0.001*time / m_nTrainingRound << std::endl;
			std::cout << "edge cover" << total << " / " << totaledge << ' ' << 1.0*total / totaledge << std::endl;
			std::cout << "sentence wrong " << m_nTotalErrors << " / " << m_nTrainingRound << std::endl;
			std::cout << "CUT0  " << cut0 << " / " << m_nTrainingRound << ' ' << 1.0*cut0 / m_nTrainingRound << std::endl;
			std::cout << "CUT1  " << cut1 << " / " << m_nTrainingRound << ' ' << 1.0*cut1 / m_nTrainingRound << std::endl;
			std::cout << "CUT2  " << cut2 << " / " << m_nTrainingRound << ' ' << 1.0*cut2 / m_nTrainingRound << std::endl;
			std::cout << "CUT3+ " << cut3 << " / " << m_nTrainingRound << ' ' << 1.0*cut3 / m_nTrainingRound << std::endl;
			std::cout << "precision " << totalcor << " / " << totalmy << ' ' << 1.0*totalcor / totalmy << std::endl;
			std::cout << "recall " << totalcor << " / " << total << ' ' << 1.0*totalcor / total << std::endl;
			std::cout << "F-Score  " << 2.0*totalcor / (total + totalmy) << std::endl;
		}
	}

	void DepParser::parse(const DependencyGraph & graph, DependencyGraph * retval) {
		int idx = 0;
		m_nTrainingRound = 0;
		DependencyGraph correct;
		m_nSentenceLength = graph.getSentence().size();
		m_vecDependencyTree = graph.getTree();
		//std::cout << "xx" << std::endl;
		for (const auto & token : graph.getSentence()) {
			m_lSentence[++idx].refer(TWord::code(SENT_WORD(token)), TPOSTag::code(SENT_POSTAG(token)));
			retval->m_lSentence.push_back(token);
		}
		retval->m_lTree = m_vecDependencyTree;
		//std::cout << "yy" << std::endl;
		work(retval, correct);
	}

	void DepParser::work(DependencyGraph * retval, const DependencyGraph & correct) {
				
		//decode();
		//decodeArcs();
		getTrainArcs();

		switch (m_nState) {
		case ParserState::TRAIN:
			update();
			break;
		case ParserState::PARSE:
			generate(retval, correct);
			break;
		case ParserState::GOLDTEST:
			update();
			break;
		default:
			break;
		}
	}

	tscore Score[MAX_SENTENCE_SIZE][MAX_SENTENCE_SIZE][2];
	
	void DepParser::getTrainArcs(){
		int sumlen = m_nSentenceLength;
		m_lcaTree.loadPath(m_vecDependencyTree);
		for (int i = 1; i <= sumlen; i++)
			for (int j = 1; j <= sumlen; j++)
				if (i != j)
					Score[i][j][0] = arcScore(i, j);
				else Score[i][j][0] = 0;

				for (int i = 1; i <= sumlen; i++)
					for (int j = 1; j <= sumlen; j++)
						Score[i][j][1] = Score[j][i][0];

		/*if (m_bgetgraph == 1)
		for (int i = 1; i <= sumlen; i++)
			for (int j = 1; j <= sumlen; j++)
				std::cout << i << ' ' << j << ' ' << Score[i][j][0] << std::endl;*/

		graphparsing_1ec_n4::dpparse(sumlen,Score,m_vecTrainArcs);
	}

	void DepParser::outans()
	{
		std::cout << "total time " << 0.001 * time << ' ' << ' ' << 0.001*time / m_nTrainingRound << std::endl;
		std::cout << "edge cover " << total << " / " << totaledge << ' ' << 1.0*total / totaledge << std::endl;
		std::cout << "sentence wrong " << m_nTotalErrors << " / " << m_nTrainingRound << std::endl;
		std::cout << "CUT0  " << cut0 << " / " << m_nTrainingRound << ' ' << 1.0*cut0 / m_nTrainingRound << std::endl;
		std::cout << "CUT1  " << cut1 << " / " << m_nTrainingRound << ' ' << 1.0*cut1 / m_nTrainingRound << std::endl;
		std::cout << "CUT2  " << cut2 << " / " << m_nTrainingRound << ' ' << 1.0*cut2 / m_nTrainingRound << std::endl;
		std::cout << "CUT3+ " << cut3 << " / " << m_nTrainingRound << ' ' << 1.0*cut3 / m_nTrainingRound << std::endl;
		std::cout << "precision " << totalcor << " / " << totalmy << ' ' << 1.0*totalcor / totalmy << std::endl;
		std::cout << "recall " << totalcor << " / " << total << ' ' << 1.0*totalcor / total << std::endl;
		std::cout << "F-Score  " << 2.0*totalcor / (total + totalmy) << std::endl;
	}
	
	
	void DepParser::update() {
		std::unordered_set<Arc> positiveArcs;
		positiveArcs.insert(m_vecCorrectArcs.begin(), m_vecCorrectArcs.end());
		
		//total += positiveArcs.size();
		
		for (const auto & arc : m_vecTrainArcs) {
			if (positiveArcs.find(arc) != positiveArcs.end()) totalcor++;
			//std::cout << arc.first() << ' ' << arc.second() << std::endl;
			positiveArcs.erase(arc);
		}
		std::unordered_set<Arc> negativeArcs;
		negativeArcs.insert(m_vecTrainArcs.begin(), m_vecTrainArcs.end());
		totalmy += negativeArcs.size();
		for (const auto & arc : m_vecCorrectArcs) {
			negativeArcs.erase(arc);
		}
		if (!positiveArcs.empty() || !negativeArcs.empty()) {
			++m_nTotalErrors;
		}
		if (m_nState == ParserState::TRAIN)
		{
			for (const auto & arc : positiveArcs) {
				getOrUpdateStackScore(arc.first() == -1 ? m_nSentenceLength : arc.first(), arc.second(), 1);
			}
			for (const auto & arc : negativeArcs) {
				getOrUpdateStackScore(arc.first() == -1 ? m_nSentenceLength : arc.first(), arc.second(), -1);
			}
		}/*else if (m_nState == ParserState::GOLDTEST){
			std::cout << std::endl << m_nTrainingRound << std::endl;
			for (auto arc : m_vecCorrectArcs)
				std::cout << "cor " << arc.first() <<' ' << arc.second() << std::endl;
			for (auto arc : m_vecTrainArcs)
				std::cout << "my " << arc.first() <<' ' << arc.second() << std::endl;
			for (int i = 1 ; i <= m_nSentenceLength ; i++)
				for (int j = 1 ; j <= m_nSentenceLength ; j++)
					std::cout << i << ' ' << j << ' ' << Score[i][j][0] << std::endl;

		}*/
	}

	void DepParser::generate(DependencyGraph * retval, const DependencyGraph & correct) {
		//retval->clear();
		//std::cout << "zz" << std::endl;
		//std::cout << m_vecTrainArcs.size() << std::endl;
		if (m_vecTrainArcs.size() > 0)
		for (auto & arc : m_vecTrainArcs) {
			retval->m_lGraph.push_back(GraphEdge(arc.first(), arc.second(), NULL_LABEL));
		}
	}

	void DepParser::goldCheck() {
		
	}

	tscore DepParser::arcScore(const int & p, const int & c) {
		if (m_bgetgraph > 0) {
			m_nRetval = m_setFirstGoldScore.find(BiGram<int>(p, c)) == m_setFirstGoldScore.end() ? GOLD_NEG_SCORE : GOLD_POS_SCORE;
			return m_nRetval;
		}
		m_nRetval = 0;
		getOrUpdateStackScore(p, c);
		return m_nRetval;
	}

	void DepParser::getOrUpdateStackScore(const int & p, const int & c, const int & amount) {
		fsum++;
		Weight * cweight = (Weight*)m_Weight;

		p_1_tag = p - 1 >= 1 ? m_lSentence[p - 1].second() : start_taggedword.second();
		p1_tag = p + 1 <= m_nSentenceLength ? m_lSentence[p + 1].second() : end_taggedword.second();
		c_1_tag = c - 1 >= 1 ? m_lSentence[c - 1].second() : start_taggedword.second();
		c1_tag = c + 1 <= m_nSentenceLength ? m_lSentence[c + 1].second() : end_taggedword.second();

		p_1_word = p - 1 >= 1 ? m_lSentence[p - 1].first() : start_taggedword.first();
		p1_word = p + 1 <= m_nSentenceLength ? m_lSentence[p + 1].first() : end_taggedword.first();
		c_1_word = c - 1 >= 1 ? m_lSentence[c - 1].first() : start_taggedword.first();
		c1_word = c + 1 <= m_nSentenceLength ? m_lSentence[c + 1].first() : end_taggedword.first();

		p_word = m_lSentence[p].first();
		p_tag = m_lSentence[p].second();

		c_word = m_lSentence[c].first();
		c_tag = m_lSentence[c].second();

		m_nDis = encodeLinkDistanceOrDirection(p, c, false);
		m_nDir = encodeLinkDistanceOrDirection(p, c, true);
		int lay = 32768;

		//P
		word_int.refer(p_word, 0);
		cweight->m_mapPw.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDis);
		cweight->m_mapPw.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDir);
		cweight->m_mapPw.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_int.refer(p_tag, 0);
		cweight->m_mapPp.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDis);
		cweight->m_mapPp.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDir);
		cweight->m_mapPp.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(p_word, p_tag, 0);
		cweight->m_mapPwp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapPwp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapPwp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//C
		word_int.refer(c_word, 0);
		cweight->m_mapCw.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDis);
		cweight->m_mapCw.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDir);
		cweight->m_mapCw.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_int.refer(c_tag, 0);
		cweight->m_mapCp.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDis);
		cweight->m_mapCp.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDir);
		cweight->m_mapCp.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(c_word, c_tag, 0);
		cweight->m_mapCwp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapCwp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapCwp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//P_1
		word_int.refer(p_1_word, 0);
		cweight->m_mapP_1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDis);
		cweight->m_mapP_1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDir);
		cweight->m_mapP_1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_int.refer(p_1_tag, 0);
		cweight->m_mapP_1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDis);
		cweight->m_mapP_1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDir);
		cweight->m_mapP_1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(p_1_word, p_1_tag, 0);
		cweight->m_mapP_1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapP_1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapP_1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//P1
		word_int.refer(p1_word, 0);
		cweight->m_mapP1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDis);
		cweight->m_mapP1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDir);
		cweight->m_mapP1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_int.refer(p1_tag, 0);
		cweight->m_mapP1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDis);
		cweight->m_mapP1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDir);
		cweight->m_mapP1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(p1_word, p1_tag, 0);
		cweight->m_mapP1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapP1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapP1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//C_1
		word_int.refer(c_1_word, 0);
		cweight->m_mapC_1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDis);
		cweight->m_mapC_1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDir);
		cweight->m_mapC_1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_int.refer(c_1_tag, 0);
		cweight->m_mapC_1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDis);
		cweight->m_mapC_1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDir);
		cweight->m_mapC_1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(c_1_word, c_1_tag, 0);
		cweight->m_mapC_1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapC_1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapC_1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//C1
		word_int.refer(c1_word, 0);
		cweight->m_mapC1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDis);
		cweight->m_mapC1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_int.referLast(m_nDir);
		cweight->m_mapC1w.getOrUpdateScore(m_nRetval, word_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_int.refer(c1_tag, 0);
		cweight->m_mapC1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDis);
		cweight->m_mapC1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_int.referLast(m_nDir);
		cweight->m_mapC1p.getOrUpdateScore(m_nRetval, tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(c1_word, c1_tag, 0);
		cweight->m_mapC1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapC1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapC1wp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_word_tag_tag_int.refer(p_word, c_word, p_tag, c_tag, 0);
		cweight->m_mapPwpCwp.getOrUpdateScore(m_nRetval, word_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPwpCwp.getOrUpdateScore(m_nRetval, word_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPwpCwp.getOrUpdateScore(m_nRetval, word_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_tag_int.refer(p_word, p_tag, c_tag, 0);
		cweight->m_mapPwpCp.getOrUpdateScore(m_nRetval, word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPwpCp.getOrUpdateScore(m_nRetval, word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPwpCp.getOrUpdateScore(m_nRetval, word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_tag_int.refer(c_word, p_tag, c_tag, 0);
		cweight->m_mapPpCwp.getOrUpdateScore(m_nRetval, word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPpCwp.getOrUpdateScore(m_nRetval, word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPpCwp.getOrUpdateScore(m_nRetval, word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_word_tag_int.refer(p_word, c_word, p_tag, 0);
		cweight->m_mapPwpCw.getOrUpdateScore(m_nRetval, word_word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_tag_int.referLast(m_nDis);
		cweight->m_mapPwpCw.getOrUpdateScore(m_nRetval, word_word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_tag_int.referLast(m_nDir);
		cweight->m_mapPwpCw.getOrUpdateScore(m_nRetval, word_word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_word_tag_int.refer(p_word, c_word, c_tag, 0);
		cweight->m_mapPwCwp.getOrUpdateScore(m_nRetval, word_word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_tag_int.referLast(m_nDis);
		cweight->m_mapPwCwp.getOrUpdateScore(m_nRetval, word_word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_tag_int.referLast(m_nDir);
		cweight->m_mapPwCwp.getOrUpdateScore(m_nRetval, word_word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_word_int.refer(p_word, c_word, 0);
		cweight->m_mapPwCw.getOrUpdateScore(m_nRetval, word_word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_int.referLast(m_nDis);
		cweight->m_mapPwCw.getOrUpdateScore(m_nRetval, word_word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_int.referLast(m_nDir);
		cweight->m_mapPwCw.getOrUpdateScore(m_nRetval, word_word_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_int.refer(p_tag, c_tag, 0);
		cweight->m_mapPpCp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_int.referLast(m_nDis);
		cweight->m_mapPpCp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_int.referLast(m_nDir);
		cweight->m_mapPpCp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//window_feat

		tag_tag_tag_tag_int.refer(p_tag, p1_tag, c_1_tag, c_tag, 0);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_1_tag, p_tag, c_1_tag, c_tag, 0);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_tag, p1_tag, c_tag, c1_tag, 0);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_1_tag, p_tag, c_tag, c1_tag, 0);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(empty_taggedword.second(), p1_tag, c_1_tag, c_tag, 0);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.refer(empty_taggedword.second(), p1_tag, c_1_tag, c_tag, m_nDir);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_1_tag, empty_taggedword.second(), c_1_tag, c_tag, 0);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(empty_taggedword.second(), p1_tag, c_tag, c1_tag, 0);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_1_tag, empty_taggedword.second(), c_tag, c1_tag, 0);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_tag, p1_tag, c_1_tag, empty_taggedword.second(), 0);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_1_tag, p_tag, c_1_tag, empty_taggedword.second(), 0);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_tag, p1_tag, empty_taggedword.second(), c1_tag, 0);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_1_tag, p_tag, empty_taggedword.second(), c1_tag, 0);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_tag, empty_taggedword.second(), c_1_tag, c_tag, 0);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPpPp1Cp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(empty_taggedword.second(), p_tag, c_1_tag, c_tag, 0);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPp_1PpCp_1Cp.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_tag, p1_tag, c_tag, empty_taggedword.second(), 0);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPpPp1CpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		tag_tag_tag_tag_int.refer(p_1_tag, p_tag, c_tag, empty_taggedword.second(), 0);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPp_1PpCpCp1.getOrUpdateScore(m_nRetval, tag_tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//P_1C
		flag_tag_tag_int.refer(0,p_1_tag,c_tag,0);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(1,p_1_word,c_tag,0);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(2,p_1_tag,c_word,0);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(3,p_1_word,c_word,0);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP_1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);


		//P1C
		flag_tag_tag_int.refer(0,p1_tag,c_tag,0);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(1,p1_word,c_tag,0);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(2,p1_tag,c_word,0);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(3,p1_word,c_word,0);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP1C.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//PC_1
		flag_tag_tag_int.refer(0,p_tag,c_1_tag,0);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(1,p_word,c_1_tag,0);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(2,p_tag,c_1_word,0);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(3,p_word,c_1_word,0);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPC_1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//PC1
		flag_tag_tag_int.refer(0,p_tag,c1_tag,0);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(1,p_word,c1_tag,0);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(2,p_tag,c1_word,0);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_tag_tag_int.refer(3,p_word,c1_word,0);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPC1.getOrUpdateScore(m_nRetval, flag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//P_1PC
		flag_word_tag_tag_int.refer(0,p_1_word,p_tag,c_tag,0);
		cweight->m_mapP_1PC.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP_1PC.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP_1PC.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_word_tag_tag_int.refer(1,p_1_tag,p_word,c_tag,0);
		cweight->m_mapP_1PC.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP_1PC.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP_1PC.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_word_tag_tag_int.refer(2,p_1_tag,p_tag,c_word,0);
		cweight->m_mapP_1PC.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapP_1PC.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapP_1PC.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//PP1C
		flag_word_tag_tag_int.refer(0,p_word,p1_tag,c_tag,0);
		cweight->m_mapPP1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPP1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPP1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_word_tag_tag_int.refer(1,p_tag,p1_word,c_tag,0);
		cweight->m_mapPP1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis+0);
		cweight->m_mapPP1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir+0);
		cweight->m_mapPP1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_word_tag_tag_int.refer(2,p_tag,p1_tag,c_word,2*0);
		cweight->m_mapPP1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis+2*0);
		cweight->m_mapPP1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir+2*0);
		cweight->m_mapPP1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//PC_1C
		flag_word_tag_tag_int.refer(0,p_word,c_1_tag,c_tag,0);
		cweight->m_mapPC_1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPC_1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPC_1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_word_tag_tag_int.refer(1,p_tag,c_1_word,c_tag,0);
		cweight->m_mapPC_1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis+lay);
		cweight->m_mapPC_1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir+lay);
		cweight->m_mapPC_1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_word_tag_tag_int.refer(2,p_tag,c_1_tag,c_word,2*0);
		cweight->m_mapPC_1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis+2*0);
		cweight->m_mapPC_1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir+2*0);
		cweight->m_mapPC_1C.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//PCC1
		flag_word_tag_tag_int.refer(0,p_word,c_tag,c1_tag,0);
		cweight->m_mapPCC1.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPCC1.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPCC1.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_word_tag_tag_int.refer(1,p_tag,c_word,c1_tag,0);
		cweight->m_mapPCC1.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPCC1.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPCC1.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		flag_word_tag_tag_int.refer(2,p_tag,c_tag,c1_word,0);
		cweight->m_mapPCC1.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDis);
		cweight->m_mapPCC1.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		flag_word_tag_tag_int.referLast(m_nDir);
		cweight->m_mapPCC1.getOrUpdateScore(m_nRetval, flag_word_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		for (int b = (int)std::fmin(p, c) + 1, e = (int)std::fmax(p, c); b < e; ++b) {
			b_tag = m_lSentence[b].second();
			tag_tag_tag_int.refer(p_tag, b_tag, c_tag, 0);
			cweight->m_mapPpBpCp.getOrUpdateScore(m_nRetval, tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
			tag_tag_tag_int.refer(p_tag, b_tag, c_tag, m_nDis);
			cweight->m_mapPpBpCp.getOrUpdateScore(m_nRetval, tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
			tag_tag_tag_int.refer(p_tag, b_tag, c_tag, m_nDir);
			cweight->m_mapPpBpCp.getOrUpdateScore(m_nRetval, tag_tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		}

		std::string path = "PATH=" + m_lcaTree.POSPath[p][c];
		path_int.refer(TPOSTag::code(path), 0);
		cweight->m_mapPath.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);
		path_int.referLast( m_nDir);
		cweight->m_mapPath.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);
		path_int.referLast( m_nDis);
		cweight->m_mapPath.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);
		
		std::string fpath = "FPATH=" + m_lcaTree.FPOSPath[p][c];
		path_int.refer(TPOSTag::code(fpath), 0);
		cweight->m_mapFPath.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);
		path_int.referLast( m_nDir);
		cweight->m_mapFPath.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);
		path_int.referLast( m_nDis);
		cweight->m_mapFPath.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);

		fpath = "UpFPATH=" + m_lcaTree.UpFPOSPath[p][c];
		path_tag_int.refer(TPOSTag::code(fpath),c_word, 0);
		cweight->m_mapPFPathCtag.getOrUpdateScore(m_nRetval, path_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		path_tag_int.referLast( m_nDir);
		cweight->m_mapPFPathCtag.getOrUpdateScore(m_nRetval, path_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		path_tag_int.referLast( m_nDis);
		cweight->m_mapPFPathCtag.getOrUpdateScore(m_nRetval, path_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		fpath = "DownFPATH=" + m_lcaTree.DownFPOSPath[p][c];
		path_tag_int.refer(TPOSTag::code(fpath),p_word, 0);
		cweight->m_mapPFPathCtag.getOrUpdateScore(m_nRetval, path_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		path_tag_int.referLast( m_nDir);
		cweight->m_mapPFPathCtag.getOrUpdateScore(m_nRetval, path_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		path_tag_int.referLast( m_nDis);
		cweight->m_mapPFPathCtag.getOrUpdateScore(m_nRetval, path_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		std::string lpath = "LPATH=" + m_lcaTree.LABELPath[p][c];
		path_int.refer(TPOSTag::code(lpath), 0);
		cweight->m_mapLPath.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);
		path_int.referLast(m_nDir);
		cweight->m_mapLPath.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);
		path_int.referLast(m_nDis);
		cweight->m_mapLPath.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);

		std::string subcatp = "subcat=" + TREENODE_POSTAG(m_vecDependencyTree[p]);
		for (auto & child : m_lcaTree.Children[p])
			subcatp+=TREENODE_POSTAG(m_vecDependencyTree[child]);
		subcat_int.refer(TPOSTag::code(subcatp), 0);
		cweight->m_mapPsubcat.getOrUpdateScore(m_nRetval, subcat_int, m_nScoreIndex, amount, m_nTrainingRound);
		subcat_int.referLast(m_nDir);
		cweight->m_mapPsubcat.getOrUpdateScore(m_nRetval, subcat_int, m_nScoreIndex, amount, m_nTrainingRound);
		subcat_int.referLast(m_nDis);
		cweight->m_mapPsubcat.getOrUpdateScore(m_nRetval, subcat_int, m_nScoreIndex, amount, m_nTrainingRound);
		subcat_tag_int.refer(TPOSTag::code(subcatp),c_tag,0);
		cweight->m_mapPsubcatCtag.getOrUpdateScore(m_nRetval, subcat_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		subcat_tag_int.referLast(m_nDir);
		cweight->m_mapPsubcatCtag.getOrUpdateScore(m_nRetval, subcat_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		subcat_tag_int.referLast(m_nDis);
		cweight->m_mapPsubcatCtag.getOrUpdateScore(m_nRetval, subcat_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		std::string subcatc = "subcat=" + TREENODE_POSTAG(m_vecDependencyTree[c]);
		for (auto & child : m_lcaTree.Children[c])
			subcatc+=TREENODE_POSTAG(m_vecDependencyTree[child]);
		subcat_int.refer(TPOSTag::code(subcatc), 0);
		cweight->m_mapCsubcat.getOrUpdateScore(m_nRetval, subcat_int, m_nScoreIndex, amount, m_nTrainingRound);
		subcat_int.referLast(m_nDir);
		cweight->m_mapCsubcat.getOrUpdateScore(m_nRetval, subcat_int, m_nScoreIndex, amount, m_nTrainingRound);
		subcat_int.referLast(m_nDis);
		cweight->m_mapCsubcat.getOrUpdateScore(m_nRetval, subcat_int, m_nScoreIndex, amount, m_nTrainingRound);
		subcat_tag_int.refer(TPOSTag::code(subcatc),p_tag,0);
		cweight->m_mapCsubcatPtag.getOrUpdateScore(m_nRetval, subcat_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		subcat_tag_int.referLast(m_nDir);
		cweight->m_mapCsubcatPtag.getOrUpdateScore(m_nRetval, subcat_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		subcat_tag_int.referLast(m_nDis);
		cweight->m_mapCsubcatPtag.getOrUpdateScore(m_nRetval, subcat_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		int edgeflag = TREENODE_HEAD(m_vecDependencyTree[c]) == p ? 1 :
                               (TREENODE_HEAD(m_vecDependencyTree[p]) == c ? -1 : 0);
		if (edgeflag != 0){
			path_int.refer(edgeflag, 0);
			cweight->m_mapPC.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);
			path_int.referLast(m_nDir);
			cweight->m_mapPC.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);
			path_int.referLast(m_nDis);
			cweight->m_mapPC.getOrUpdateScore(m_nRetval, path_int, m_nScoreIndex, amount, m_nTrainingRound);
		}


		int label = TPOSTag::code("CLABEL=" + TREENODE_LABEL(m_vecDependencyTree[c]));
		label_int.refer(label, 0);
		cweight->m_mapCLabel.getOrUpdateScore(m_nRetval, label_int, m_nScoreIndex, amount, m_nTrainingRound);
		label_int.referLast(m_nDir);
		cweight->m_mapCLabel.getOrUpdateScore(m_nRetval, label_int, m_nScoreIndex, amount, m_nTrainingRound);
		label_int.referLast(m_nDis);
		cweight->m_mapCLabel.getOrUpdateScore(m_nRetval, label_int, m_nScoreIndex, amount, m_nTrainingRound);


		int f = TREENODE_HEAD(m_vecDependencyTree[c]);
		int lc = m_lcaTree.Children[c].empty() ? -1 : m_lcaTree.Children[c].front();
		int rc = m_lcaTree.Children[c].empty() ? -1 : m_lcaTree.Children[c].back();
		int cf = 0;
		for (int i = 0; i < m_lcaTree.Children[f].size(); i++)
			if (m_lcaTree.Children[f][i] == c)
			{
				cf = i;
				break;
			}
		int ls = cf == 0 ? -1 : m_lcaTree.Children[f][cf - 1];
		int rs = cf + 1 == m_lcaTree.Children[f].size() ? -1 : m_lcaTree.Children[f][cf + 1];
		int lw=m_lcaTree.Range[c].first(),rw = m_lcaTree.Range[c].second();

		int lw_tag = m_lSentence[lw].second(),rw_tag = m_lSentence[rw].second();
		int lw_word = m_lSentence[lw].first(),rw_word = m_lSentence[rw].first();
		int lw_1_tag = lw -1 >= 1? m_lSentence[lw-1].second() : start_taggedword.second();
		int rw1_tag = lw + 1 <= m_nSentenceLength ? m_lSentence[rw+1].second() : end_taggedword.second();
		int lw_1_word = lw -1 >= 1? m_lSentence[lw-1].first() : start_taggedword.first();
		int rw1_word = lw + 1 <= m_nSentenceLength ? m_lSentence[rw+1].first() : end_taggedword.first();

		int lc_tag = lc == -1 ? start_taggedword.second() : m_lSentence[lc].second();
		int lc_word = lc == -1 ? start_taggedword.first() : m_lSentence[lc].first();
		int rc_tag = rc == -1 ? end_taggedword.second() : m_lSentence[rc].second();
		int rc_word = rc == -1 ? end_taggedword.first() : m_lSentence[rc].first();

		int ls_tag = ls == -1 ? start_taggedword.second() : m_lSentence[ls].second();
		int ls_word = ls == -1 ? start_taggedword.first() : m_lSentence[ls].first();
		int rs_tag = rs == -1 ? end_taggedword.second() : m_lSentence[rs].second();
		int rs_word = rs == -1 ? end_taggedword.first() : m_lSentence[rs].first();

		//lw
		word_tag_int.refer(lw_word,0,0);
		cweight->m_mapLW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapLW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapLW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.refer(0,lw_tag,0);
		cweight->m_mapLW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapLW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapLW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.refer(lw_word,lw_tag,0);
		cweight->m_mapLW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapLW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapLW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		//rw
		word_tag_int.refer(rw_word,0,0);
		cweight->m_mapRW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapRW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapRW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.refer(0,rw_tag,0);
		cweight->m_mapRW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapRW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapRW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.refer(rw_word,rw_tag,0);
		cweight->m_mapRW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapRW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapRW.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		//lw_1
		word_tag_int.refer(lw_1_word,0,0);
		cweight->m_mapLW_1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapLW_1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapLW_1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.refer(0,lw_1_tag,0);
		cweight->m_mapLW_1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapLW_1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapLW_1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.refer(lw_1_word,lw_1_tag,0);
		cweight->m_mapLW_1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapLW_1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapLW_1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		//rw1
		word_tag_int.refer(rw1_word,0,0);
		cweight->m_mapRW1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapRW1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapRW1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.refer(0,rw1_tag,0);
		cweight->m_mapRW1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapRW1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapRW1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.refer(rw1_word,rw1_tag,0);
		cweight->m_mapRW1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapRW1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapRW1.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);



		//lc-p
		tag_tag_int.refer(lc_tag, p_tag,0);
		cweight->m_mapLCpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_int.referLast(m_nDis);
		cweight->m_mapLCpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_int.referLast(m_nDir);
		cweight->m_mapLCpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(lc_word, p_tag, 0);
		cweight->m_mapLCwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapLCwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapLCwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(p_word, lc_tag, 0);
		cweight->m_mapLCpPw.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapLCpPw.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapLCpPw.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_word_int.refer(lc_word, p_word, 0);
		cweight->m_mapLCwPw.getOrUpdateScore(m_nRetval, word_word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_int.referLast(m_nDis);
		cweight->m_mapLCwPw.getOrUpdateScore(m_nRetval, word_word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_int.referLast(m_nDir);
		cweight->m_mapLCwPw.getOrUpdateScore(m_nRetval, word_word_int, m_nScoreIndex, amount, m_nTrainingRound);

		//rc-p
		tag_tag_int.refer(rc_tag, p_tag, 0);
		cweight->m_mapRCpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_int.referLast(m_nDis);
		cweight->m_mapRCpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_int.referLast(m_nDir);
		cweight->m_mapRCpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(rc_word, p_tag, 0);
		cweight->m_mapRCwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapRCwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapRCwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(p_word, rc_tag, 0);
		cweight->m_mapRCpPw.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapRCpPw.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapRCpPw.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_word_int.refer(rc_word, p_word, 0);
		cweight->m_mapRCwPw.getOrUpdateScore(m_nRetval, word_word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_int.referLast(m_nDis);
		cweight->m_mapRCwPw.getOrUpdateScore(m_nRetval, word_word_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_word_int.referLast(m_nDir);
		cweight->m_mapRCwPw.getOrUpdateScore(m_nRetval, word_word_int, m_nScoreIndex, amount, m_nTrainingRound);


		//ls-p
		tag_tag_int.refer(ls_tag, p_tag, 0);
		cweight->m_mapLSpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_int.referLast(m_nDis);
		cweight->m_mapLSpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_int.referLast(m_nDir);
		cweight->m_mapLSpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(ls_word, p_tag, 0);
		cweight->m_mapLSwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapLSwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapLSwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		//rs-p
		tag_tag_int.refer(rs_tag, p_tag, 0);
		cweight->m_mapRSpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_int.referLast(m_nDis);
		cweight->m_mapRSpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		tag_tag_int.referLast(m_nDir);
		cweight->m_mapRSpPp.getOrUpdateScore(m_nRetval, tag_tag_int, m_nScoreIndex, amount, m_nTrainingRound);

		word_tag_int.refer(rs_word, p_tag, 0);
		cweight->m_mapRSwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDis);
		cweight->m_mapRSwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);
		word_tag_int.referLast(m_nDir);
		cweight->m_mapRSwPp.getOrUpdateScore(m_nRetval, word_tag_int, m_nScoreIndex, amount, m_nTrainingRound);


	}
}
