
import re
import sys
from copy import deepcopy
from model import Model, CondModel

########################################
#
#  main
#
########################################

########## read rule counts

# init relevant models
Pc = CondModel('Pc')
Pw = CondModel('Pw')
P  = Model('P')
W  = Model('W')
Gh0_giv_BL_D_Gh = CondModel('G0_L')
Gh0_giv_BR_D_Gh = CondModel('G0_R')
Gh1_giv_BL_D_Gh = CondModel('G1_L')
Gh1_giv_BR_D_Gh = CondModel('G1_R')
Gh0_Gh1_giv_BL_D_Gh = CondModel('GG_L')
Gh0_Gh1_giv_BR_D_Gh = CondModel('GG_R')

# read in GG model and obtain relevant models
for s in sys.stdin:
    m = re.search('Pg (.*)\^.,. : (.*) = (.*)',s)
    if m is not None:
        Pc[m.group(1)][m.group(2)] = float(m.group(3))
    m = re.search('Pw (.*) : (.*) = (.*)',s)
    if m is not None:
        Pw[m.group(1)][m.group(2)] = float(m.group(3))
        P[m.group(2)] += float(m.group(3))
        W[m.group(1)] += float(m.group(3))
    s = re.sub('^G : (.*\^[Ll],1) =','GG REST^R,0 : \\1 REST^R,0 =',s)
    m = re.search('GG (.*)\^(.),(.) : (.*)\^.,. (.*)\^.,. = (.*)',s)
    if m is not None:
        (gh, b,sd, gh0, gh1, ct) = m.groups()
        d = int(sd)
        if b=='L' or b=='l':
            Gh0_giv_BL_D_Gh[d,gh][gh0] += float(ct)
            Gh1_giv_BL_D_Gh[d,gh][gh1] += float(ct)
            Gh0_Gh1_giv_BL_D_Gh[d,gh][gh0,gh1] += float(ct)
        else:
            Gh0_giv_BR_D_Gh[d+1,gh][gh0] += float(ct)
            Gh1_giv_BR_D_Gh[d,gh][gh1] += float(ct)
            Gh0_Gh1_giv_BR_D_Gh[d,gh][gh0,gh1] += float(ct)

# normalize models
Gh0_giv_BL_D_Gh.normalize()
Gh0_giv_BR_D_Gh.normalize()
Gh1_giv_BL_D_Gh.normalize()
Gh1_giv_BR_D_Gh.normalize()
Gh0_Gh1_giv_BL_D_Gh.normalize()
Gh0_Gh1_giv_BR_D_Gh.normalize()
Pc.normalize()
Pw.normalize()
P.normalize()
W.normalize()

Pc.write()
Pw.write()
P.write()
W.write()

sys.stderr.write('1\n')


########## obtain intermediate models

# define iteration constant
K=20

# obtain expected counts for unbounded left descendants
Ghi_giv_D_Gh_prev = CondModel('Grl*_k-1')
Ghi_giv_D_Gh_curr = CondModel('Grl*_k')
Ghi_giv_D_Gh      = CondModel('Grl*')
for d,gh in Gh0_giv_BR_D_Gh:
    for gh0 in Gh0_giv_BR_D_Gh[d,gh]:
        Ghi_giv_D_Gh_curr[d,gh][gh0] += Gh0_giv_BR_D_Gh[d,gh][gh0]
        Ghi_giv_D_Gh     [d,gh][gh0] += Gh0_giv_BR_D_Gh[d,gh][gh0]
    for k in range(1,K+1):
        Ghi_giv_D_Gh_prev = deepcopy(Ghi_giv_D_Gh_curr)
        Ghi_giv_D_Gh_curr.clear()
        for ghi in Ghi_giv_D_Gh_prev.get((d,gh)):
            for ghi0 in Gh0_giv_BL_D_Gh.get((d,ghi)):
                pr = Ghi_giv_D_Gh_prev.get((d,gh)).get(ghi) * Gh0_giv_BL_D_Gh[d,ghi][ghi0]
                if pr > 0.0:
                    Ghi_giv_D_Gh_curr[d,gh][ghi0] += pr
                    Ghi_giv_D_Gh     [d,gh][ghi0] += pr

sys.stderr.write('2\n')


########## obtain agf models

# obtain expansion model
Ge = CondModel('Ge')
for d,gh in Ghi_giv_D_Gh:
    for ghi in Ghi_giv_D_Gh[d,gh]:
        if not re.search('(^[A-Z]|_)',ghi):
            Ge[d,gh][ghi] += Ghi_giv_D_Gh[d,gh][ghi]

Ge.normalize()
Ge.write()

sys.stderr.write('3\n')


# obtain reduction model
Fr = CondModel('F')
for d,gh in Ghi_giv_D_Gh:
    for ghi in Ghi_giv_D_Gh[d,gh]:
        pr = Gh0_giv_BR_D_Gh[d,gh][ghi]
        if pr > 0.0:
            Fr[d,gh,ghi]['1,'+ghi] += pr
        pr = (Ghi_giv_D_Gh[d,gh][ghi] - Gh0_giv_BR_D_Gh[d,gh][ghi])
        if pr > 0.0:
            Fr[d,gh,ghi]['0,'+ghi] += pr

Fr.normalize()
Fr.write()

sys.stderr.write('4\n')


# obtain active transition models
Ghi_giv_D_Gh_Ghi0   = CondModel('Gtaa')
Ghi1_giv_D_Ghi_Ghi0 = CondModel('Gtaw')
for d,gh in Ghi_giv_D_Gh:
    for ghi in Ghi_giv_D_Gh[d,gh]:
        for ghi0,ghi1 in Gh0_Gh1_giv_BL_D_Gh[d,ghi]:
            pr = Ghi_giv_D_Gh[d,gh][ghi] * Gh0_Gh1_giv_BL_D_Gh[d,ghi][ghi0,ghi1]
            if pr > 0.0:
                Ghi_giv_D_Gh_Ghi0[d,gh,ghi0][ghi]     += pr
                Ghi1_giv_D_Ghi_Ghi0[d,ghi,ghi0][ghi1] += pr

Ghi_giv_D_Gh_Ghi0.normalize()
Ghi1_giv_D_Ghi_Ghi0.normalize()
Ghi_giv_D_Gh_Ghi0.write()
Ghi1_giv_D_Ghi_Ghi0.write()

sys.stderr.write('5\n')


# obtain awaited transition models
Ghim1_giv_D_Ghim_Ghim0 = CondModel('Gtww')
for d,ghim in Gh0_Gh1_giv_BR_D_Gh:
    if d>0:
        for ghim0,ghim1 in Gh0_Gh1_giv_BR_D_Gh[d,ghim]:
            pr = Gh0_Gh1_giv_BR_D_Gh[d,ghim][ghim0,ghim1]
            if pr > 0.0:
                Ghim1_giv_D_Ghim_Ghim0[d,ghim,ghim0][ghim1] += pr

Ghim1_giv_D_Ghim_Ghim0.normalize()
Ghim1_giv_D_Ghim_Ghim0.write()

